<h1 align="center">📝 TeXeTeScribe</h1>
<p align="center"><b>Offline Android app that saves notes locally as .TXT files - supports external microSD storage</b></p>

<p align="center">
  <img alt="TXTNotes app icon" src="https://raw.githubusercontent.com/Eb43/txtnotes/refs/heads/main/TXTNotes/TXTNotes_icon.png" width="130">
</p>

<p align="center">
    📦 Download APK: </p>
  
<p><a href="https://f-droid.org/ru/packages/barilyuk.texetescribe/"><img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get TeXeTeScribe on F-Droid"
     height="80"></a></p>
  
  <p>or in Releases section of this repository: <a href="https://github.com/Eb43/txtnotes/releases/latest">https://github.com/Eb43/txtnotes/releases/latest</a>
</p>

---
### 🗒️ Overview

**TeXeTeScribe** provides what Android still lacks - the ability to read, edit, and create text-based files directly in folders you choose, including on **microSD cards**.  
It is a free, offline note editor designed around plain `.TXT` files for maximum compatibility, privacy, and reliability.

<p align="center">
  <img alt="TeXeTeScribe main screen" src="https://raw.githubusercontent.com/Eb43/txtnotes/refs/heads/main/screenshots/Screenshot_2024-09-26-22-55-00-835_com.txtnotes.jpg" width="300">
  <img alt="TeXeTeScribe edit screen" src="https://raw.githubusercontent.com/Eb43/txtnotes/refs/heads/main/screenshots/Screenshot_2024-09-26-23-09-36-947_com.txtnotes.jpg" width="300">
</p>

---

### 💡 Why TeXeTeScribe

- **Your data is always readable**. Storing notes in plain `.TXT` format makes them viewable and editable on any device - Android, iOS, Windows, macOS, Linux, ChromeOS, Smart TVs, e-readers, and cloud drives. Every system understands text.  

- **Your notes survive Android failures**. When Android glitches, encrypts, or bricks itself after an update, files in internal storage become unreadable. Saving notes on a microSD card keeps them visible and copyable in any file manager, even if the phone is dead or replaced.  

- **Your text always displays correctly**. The app detects file encoding automatically - whether UTF-8 (Android), ANSI-1251 (Windows), CP-866 (DOS), MacRoman (macOS), or UTF-32. Most Android apps ignore encodings and show gibberish; TeXeTeScribe ensures text looks right.  

- **You find notes instantly**. The folder view shows a preview of each file and its modification time, helping you locate the right note without opening them one by one.  

- **You always return to your latest thoughts**. Files are sorted by last modification time, so your most recent ideas appear on top - exactly how note-taking works in real life.  

- **You stay offline and private**. No cloud sync, no analytics, no background tasks. Everything stays on your device, in your folders.  

- **You control storage**. Create, rename, and manage notes directly inside user-selected folders using Android’s built-in file access system.  

- **You work with any text-based file**. Beyond TXT, it opens and edits MD, LOG, INI, CFG, YAML, JSON, XML, CSV, and more.  

- **You never lose progress**. Notes are automatically saved on exit or app minimization, preventing accidental data loss.  

- **You own your data**. No accounts, ads, or hidden databases. Every note is a transparent text file you can move, back up, or open anywhere.

<p align="center">
  <img alt="TeXeTeScribe folder preview" src="https://raw.githubusercontent.com/Eb43/txtnotes/refs/heads/main/screenshots/Screenshot_2024-09-26-22-56-08-766_com.txtnotes.jpg" width="300">
  <img alt="TeXeTeScribe SD card view" src="https://raw.githubusercontent.com/Eb43/txtnotes/refs/heads/main/screenshots/Screenshot_2024-09-26-23-04-22-495_com.ghisler.android.TotalCommander.jpg" width="300">
</p>

---

### ⚙️ Features

- Save notes as **.TXT** files  
- Choose any folder - including **microSD**  
- Automatic **encoding detection and display**  
- File list with **previews and modification times**  
- Sort by **last modified** date  
- **Auto-save** on exit or minimize  
- **No databases**, just plain text files  
- **Offline and private** operation  
- **Lightweight:** 6.5 MB APK  
- Works on **Android 8.0 and newer**  
- **Open source** and completely free  

---

### 📱 How to Use

1. Tap **➕** to create a new note.  
2. Tap a file to open and edit it.  
3. Tap **Refresh** to reload folder contents.  
4. Tap **X** to close the editor - the note saves automatically.  
5. Use **Select Folder** to switch where your notes are stored.

---

### 🔐 Privacy & Design Philosophy

TeXeTeScribe never leaves your storage.  
No telemetry, no background services, no cloud connections.  
Every note remains a readable `.TXT` file in a location you control.  
What you write stays fully under your ownership.

---

### 🧩 Technical Details

- **App name:** TeXeTeScribe  
- **APK size:** 6.5 MB  
- **Minimum Android:** 8.0 (Oreo)  
- **Permissions:** Storage access (read/write to selected folders)  
- **License:** Open Source (see repository)  

---
