package audio.omgsoundboard.core.data.local.daos

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Update
import audio.omgsoundboard.core.data.local.entities.CategoryEntity
import audio.omgsoundboard.core.utils.Constants.CATEGORIES_TABLE
import kotlinx.coroutines.flow.Flow

@Dao
interface CategoryDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertCategory(category: CategoryEntity): Long

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertCategories(categories: List<CategoryEntity>)

    @Update
    suspend fun updateCategory(category: CategoryEntity)

    @Query("DELETE FROM categories WHERE id = :id")
    suspend fun deleteCategory(id: Int)

    @Query("SELECT * FROM categories WHERE name = :name LIMIT 1")
    suspend fun getCategoryByName(name: String): CategoryEntity

    @Query("SELECT * FROM $CATEGORIES_TABLE")
    fun getAllCategories(): Flow<List<CategoryEntity>>

    @Query("SELECT * FROM $CATEGORIES_TABLE")
    suspend fun getAllCategoriesOnce(): List<CategoryEntity>

    @Query("SELECT * FROM $CATEGORIES_TABLE ORDER BY RANDOM() LIMIT 1")
    suspend fun getRandomCategory(): CategoryEntity

    @Query("DELETE FROM $CATEGORIES_TABLE")
    suspend fun deleteAllCategories()
}