package org.getdisconnected.awhip;

import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import at.h4x.awhip.R;

public class AboutActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_about);

        TextView credits = findViewById(R.id.credits);
        credits.setMovementMethod(LinkMovementMethod.getInstance());


        TextView upperBlock = findViewById(R.id.upper_block);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            upperBlock.setText(Html.fromHtml("<b>" + getString(R.string.waring_title) + ":</b> " + getString(R.string.warning) + "<br/><br/>" + getString(R.string.about_text), Html.FROM_HTML_MODE_COMPACT));
            credits.setText(Html.fromHtml(getString(R.string.credits), Html.FROM_HTML_MODE_COMPACT));
        } else {
            upperBlock.setText(Html.fromHtml(getString(R.string.warning) + "<br/><br/>" + getString(R.string.about_text)));
            credits.setText(Html.fromHtml(getString(R.string.credits)));
        }
        upperBlock.setMovementMethod(LinkMovementMethod.getInstance());
        credits.setMovementMethod(LinkMovementMethod.getInstance());
    }
}
