/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.acra.NaiveTrustManager;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;

class HttpUtils {
    private static final String LOG_TAG = "ACRA";
    private static final TrustManager[] TRUST_MANAGER = new TrustManager[]{new NaiveTrustManager()};
    private static final AllowAllHostnameVerifier HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    private static final int SOCKET_TIMEOUT = 3000;

    HttpUtils() {
    }

    static void doPost(Map<?, ?> parameters, URL url) throws UnsupportedEncodingException, IOException, KeyManagementException, NoSuchAlgorithmException {
        String line;
        URLConnection cnx = HttpUtils.getConnection(url);
        StringBuilder dataBfr = new StringBuilder();
        Iterator<?> iKeys = parameters.keySet().iterator();
        while (iKeys.hasNext()) {
            if (dataBfr.length() != 0) {
                dataBfr.append('&');
            }
            String key = (String)iKeys.next();
            dataBfr.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode((String)parameters.get(key), "UTF-8"));
        }
        cnx.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(cnx.getOutputStream());
        Log.d((String)LOG_TAG, (String)"Posting crash report data");
        wr.write(dataBfr.toString());
        wr.flush();
        wr.close();
        Log.d((String)LOG_TAG, (String)"Reading response");
        BufferedReader rd = new BufferedReader(new InputStreamReader(cnx.getInputStream()));
        while ((line = rd.readLine()) != null) {
            Log.d((String)LOG_TAG, (String)line);
        }
        rd.close();
    }

    private static URLConnection getConnection(URL url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(new KeyManager[0], TRUST_MANAGER, new SecureRandom());
            SSLSocketFactory socketFactory = context.getSocketFactory();
            ((HttpsURLConnection)conn).setSSLSocketFactory(socketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier((HostnameVerifier)HOSTNAME_VERIFIER);
        }
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        return conn;
    }
}

