/**
 *  Field.java
 *
Copyright (c) 2018, Innovatics Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
 
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and / or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package com.pdfjet;


/**
 *  Please see Example_45
 */
public class Field {

    float x;
    String[] values;
    String[] altDescription;
    String[] actualText;
    boolean format = false;


    public Field(float x, String[] values) {
        this(x, values, false);
    }

    public Field(float x, String[] values, boolean format) {
        this.x = x;
        this.values = values;
        this.format = format;
        if (values != null) {
            this.altDescription = new String[values.length];
            this.actualText     = new String[values.length];
            for (int i = 0; i < values.length; i++) {
                this.altDescription[i] = values[i];
                this.actualText[i]     = values[i];
            }
        }
    }


    public Field setAltDescription(String altDescription) {
        this.altDescription[0] = altDescription;
        return this;
    }


    public Field setActualText(String actualText) {
        this.actualText[0] = actualText;
        return this;
    }

}
