/*
 * Copyright (c) 2014 - 2025 askanimus@gmail.com
 *
 * This File is part of "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).  If not, see <http://www.gnu.org/licenses/>.
 * Diese Datei ist Teil von "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
 * veröffentlichten Version, weiter verteilen und/oder modifizieren.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <https://www.gnu.org/licenses/>.
 */

package askanimus.arbeitszeiterfassung2.feiertage;

import java.util.ArrayList;

public class FeiertageJahr {
        private int jahr;
        private ArrayList<Feiertag> feiertagTage;

        public FeiertageJahr(int j) {
            jahr = j;
            feiertagTage = new ArrayList<Feiertag>();
        }

        public int size(){
            return feiertagTage.size();
        }

        public Feiertag getFeiertag(int index){
            return feiertagTage.get(index);
        }

        public int getJahr(){
            return jahr;
        }

        public ArrayList<Feiertag> getFeiertage(){
            return feiertagTage;
        }

        public void addFeiertag(Feiertag tagNeu){
            feiertagTage.add(tagNeu);
        }

        boolean insertFeiertag(Feiertag termin) {
            for (int i = 0; i < feiertagTage.size(); i++) {
                if (feiertagTage.get(i).getDatumStart().istGleich(termin.getDatumStart())) {
                    // diesen Termin ignorieren weil er schon existiert
                    return false;
                }

                if (feiertagTage.get(i).getDatumStart().liegtNach(termin.getDatumStart())) {
                    // der Termin in der Liste vor diesen Termin einordnen
                    feiertagTage.add(i, termin);
                    return true;
                }
            }
            // der Termin wird ans Ende der Liste eingefügt
            feiertagTage.add(termin);
            return true;
        }

        boolean loesche(){
            for (Feiertag ft : feiertagTage) {
                ft.loesche();
            }
            return true;
        }
}
