/*
 * Copyright (c) 2014 - 2025 askanimus@gmail.com
 *
 * This File is part of "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).  If not, see <http://www.gnu.org/licenses/>.
 * Diese Datei ist Teil von "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
 * veröffentlichten Version, weiter verteilen und/oder modifizieren.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <https://www.gnu.org/licenses/>.
 */

package askanimus.arbeitszeiterfassung2.Ics;

import java.util.Calendar;

import askanimus.arbeitszeiterfassung2.Datum;
import askanimus.arbeitszeiterfassung2.Uhrzeit;
import askanimus.arbeitszeiterfassung2.arbeitsplatz.Arbeitsplatz;
import askanimus.arbeitszeiterfassung2.einsatzort.Einsatzort;

public class icsTermin implements IIcs {
    protected Datum datStart;
    private Datum datEnd;
    private Uhrzeit zeitStart;
    private Uhrzeit zeitEnd;
    protected String name;
    private String beschreibung;
    private Einsatzort ort;
    private Arbeitsplatz arbeitsplatz;
    private int Wiederholung_Typ;
    private int Wiederholung_Anzahl;
    private int Wiederholung_Interval;

    /*
     * Set
     */

    /**
     * Setzt das Datum und die Zeit des Beginns des Termins
     * @param jahr die Jahreszahl >= 0
     * @param monat die Nummer des Monats 0...11
     * @param tag   der Tag im Monat 1...28|30|31
     * @param zeit  die Uhrzeit in Minuten
     */
    public void setStart(int jahr, int monat, int tag, int zeit){
        datStart = new Datum(jahr, monat, tag, Calendar.MONDAY);
        if (zeit >= 0){
            zeitStart = new Uhrzeit(zeit);
        }
    }

    public void setStart(String datumString) {
        datumString = datumString.substring(datumString.indexOf(":") + 1).trim();
        datStart = extraktDatum(datumString);
        int beginnZeit = datumString.indexOf("T") + 1;
        if(beginnZeit > 0){
            zeitStart = extraktZeit(datumString.substring(beginnZeit));
        }
    }

    public void setStartJahr(int jahr){
        datStart.setJahr(jahr);
    }

    public void setEnd(String datumString) {
        datumString = datumString.substring(datumString.indexOf(":") + 1).trim();
        datEnd = extraktDatum(datumString);
        int beginnZeit = datumString.indexOf("T") + 1;
        if(beginnZeit > 0){
            zeitEnd = extraktZeit(datumString.substring(beginnZeit));
        }
    }

    public void setWiederholung(int typ, int anzahl, int intervall){
        Wiederholung_Typ = typ;
        Wiederholung_Anzahl = anzahl;
        Wiederholung_Interval = intervall;
    }

    public void setName(String name){
        if(name.contains(TAG_TERMIN_NAME)) {
            this.name = name.substring(TAG_TERMIN_NAME.length()).trim();
        } else {
            this.name = name;
        }
    }

    void setBeschreibung(String beschreibung){
        this.beschreibung = beschreibung.substring(TAG_BESCHREIBUNG.length()).trim();
    }

    void setArbeitsplatz(Arbeitsplatz arbeitsplatz){
        this.arbeitsplatz = arbeitsplatz;
    }

    void setOrt(Einsatzort ort){
        this.ort = ort;
    }


    /*
     * Get
     */
    public Datum getDatumStart(){
        return datStart;
    }

    public Datum getDatumEnd(){
        return datEnd;
    }

    public Uhrzeit getZeitStart(){
        return zeitStart;
    }

    public Uhrzeit getZeitEnd(){
        return zeitEnd;
    }

    public int getWiederholung_Typ(){
        return Wiederholung_Typ;
    }

    public int getWiederholung_Anzahl(){
        return Wiederholung_Anzahl;
    }

    public int getWiederholung_Interval(){
        return Wiederholung_Interval;
    }

    public String getName(){
        return name;
    }

    public String getBeschreibung(){
        return beschreibung;
    }

    public Arbeitsplatz getArbeitsplatz(){
        return arbeitsplatz;
    }

    public Einsatzort getOrt(){
        return ort;
    }


    /*
     * verarbeite
     */
    private Datum extraktDatum(String datumString){
        if(datumString.length() >= 8) {
            int jahr;
            int monat;
            int tag;

            try {
                jahr = Integer.parseInt(datumString.substring(0, 4));
                monat = Integer.parseInt(datumString.substring(4, 6));
                tag = Integer.parseInt(datumString.substring(6));
            } catch (NumberFormatException e){
                return null;
            }

            if (monat > 0 && monat <= 12) {
                if (tag > 0 && tag <= 31) {
                    return new Datum(jahr, monat, tag, Calendar.MONDAY);
                }
            }
        }
        return null;
    }

    private Uhrzeit extraktZeit(String zeitString){
        if(zeitString.length() >= 6) {
            int stunde;
            int minute;
            //int sekunde;

            try {
                stunde = Integer.parseInt(zeitString.substring(0, 2));
                minute = Integer.parseInt(zeitString.substring(2, 4));
                //sekunde = Integer.parseInt(zeitString.substring(4, 6));
            } catch (NumberFormatException e) {
                return null;
            }

            if (stunde >= 0 && stunde <= 23) {
                if (minute >= 0 && minute <= 59) {
                    return new Uhrzeit(stunde, minute);
                }
            }
        }
        return null;
    }
}
