/*
 * Copyright (c) 2014 - 2025 askanimus@gmail.com
 *
 * This File is part of "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).  If not, see <http://www.gnu.org/licenses/>.
 * Diese Datei ist Teil von "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
 * veröffentlichten Version, weiter verteilen und/oder modifizieren.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <https://www.gnu.org/licenses/>.
 */

package askanimus.arbeitszeiterfassung2.feiertage;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;

import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import askanimus.arbeitszeiterfassung2.Ics.IIcs;
import askanimus.arbeitszeiterfassung2.MainActivity;
import askanimus.arbeitszeiterfassung2.R;
import askanimus.arbeitszeiterfassung2.datenbank.DatenbankHelper;
import askanimus.arbeitszeiterfassung2.setup.ASettings;
import askanimus.arbeitszeiterfassung2.setup.ISettings;

public class ImportActivity extends Activity {

    Context mContext;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mContext = getApplicationContext();
        // Empfange Daten behandeln
        Intent intent = getIntent();
        String action = intent.getAction();
        String type = intent.getType();

        if (IIcs.DATEI_TYP_ICS.equals(type)) {
            Uri uri = null;
            if(Intent.ACTION_SEND.equals(action)){
                uri = intent.getParcelableExtra(Intent.EXTRA_STREAM);
            } else if(Intent.ACTION_VIEW.equals(action)) {
                uri = intent.getData();
            }

            if (uri != null) {
                // Datenbank erzeugen, falls noch nicht geschehen und öffnen
                if (ASettings.feiertage == null) {
                    if (ASettings.stundenDBHelper == null) {
                        ASettings.stundenDBHelper = new DatenbankHelper(mContext);
                    }

                    if (ASettings.mDatenbank == null || !ASettings.mDatenbank.isOpen()) {
                        ASettings.mDatenbank = ASettings.stundenDBHelper.getWritableDatabase();
                    }
                    ASettings.feiertage = new FeiertageListe(ASettings.mDatenbank);
                }

                ArrayList<Feiertag> listeImport = ASettings.feiertage.FeiertageIcsImport(mContext, uri);
                if (listeImport != null) {
                    int anzahl = ASettings.feiertage.FeiertageListeImport(listeImport);
                    Toast.makeText(
                            mContext,
                            String.format(
                                    Locale.getDefault(),
                                    "%d %s",
                                    anzahl,
                                    mContext.getString(R.string.toast_import_erfolg)
                            ),
                            Toast.LENGTH_LONG
                    ).show();
                } else {
                    Toast.makeText(mContext, mContext.getString(R.string.toast_import_miserfolg), Toast.LENGTH_LONG).show();
                }
            }
        }
        Intent mMainIntent = new Intent();
        mMainIntent.setClass(this, MainActivity.class);
        mMainIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        mMainIntent.setAction(ISettings.APP_RESET);
        mMainIntent.putExtra(ISettings.KEY_ANZEIGE_VIEW, ISettings.VIEW_FEIERTAGE);
        mMainIntent.putExtra(ISettings.KEY_ANZEIGE_DATUM, new Date().getTime());
        finish();
        startActivity(mMainIntent);
    }

   /* @Override
    public void onResume() {
        super.onResume();
        ASettings.init(mContext, this::resume);
    }

    void resume() {
    }*/
}
