/*
 * Copyright (c) 2014 - 2025 askanimus@gmail.com
 *
 * This File is part of "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).  If not, see <http://www.gnu.org/licenses/>.
 * Diese Datei ist Teil von "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
 * veröffentlichten Version, weiter verteilen und/oder modifizieren.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <https://www.gnu.org/licenses/>.
 */

package askanimus.arbeitszeiterfassung2.feiertage;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;

import java.util.Calendar;

import askanimus.arbeitszeiterfassung2.Datum;
import askanimus.arbeitszeiterfassung2.R;
import askanimus.arbeitszeiterfassung2.setup.ASettings;
import askanimus.betterpickers.calendardatepicker.CalendarDatePickerDialogFragment;

public class FragmentDialogEditFeiertag
        extends DialogFragment
        implements CalendarDatePickerDialogFragment.OnDateSetListener, View.OnClickListener
{
    private Context mContext;
    private FragmentManager mFragmentManager;
    private FeiertageListAdapter mListAdapter;
    private String editName;
    private Datum editDatum;
    private Feiertag feiertagOrig;

    private TextView tDatum;

    public FragmentDialogEditFeiertag(Feiertag editFeiertag, FragmentManager fm, FeiertageListAdapter la){
        editName = editFeiertag.getName();
        editDatum = new Datum(editFeiertag.getDatumStart());
        feiertagOrig = editFeiertag;
        mFragmentManager = fm;
        mListAdapter = la;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mContext = getContext();
    }
   @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
       LayoutInflater inflater = getLayoutInflater();

       View mInhalt = inflater.inflate(R.layout.fragment_feiertag_edit, null);
       TextView tName = mInhalt.findViewById(R.id.FE_wert_name);
       tDatum = mInhalt.findViewById(R.id.FE_wert_datum);

       tName.setText(editName);
       tDatum.setText(editDatum.getString_Datum(mContext));
       tDatum.setOnClickListener(this);

       return new AlertDialog.Builder(requireActivity())
               .setView(mInhalt)
               .setTitle(String.format(
                       "%s %s",
                       getString(R.string.feiertag),
                       getString(R.string.edit)
               ))
               .setIcon(R.mipmap.ic_launcher_round)
               .setPositiveButton(android.R.string.ok, (dialog, which) -> {
                   feiertagOrig.setName(tName.getText().toString());
                   feiertagOrig.getDatumStart().set(editDatum);
                   if (feiertagOrig.getId() > 0) {
                       feiertagOrig.save();
                   } else {
                       if (ASettings.feiertage.add(feiertagOrig)) {
                           feiertagOrig.save();
                       } else {
                           Toast.makeText(
                                   mContext,
                                   getString(R.string.feiertag_existiert),
                                   Toast.LENGTH_LONG).show();
                       }
                   }
                   mListAdapter.notifyDataSetChanged();
               })
               .setNegativeButton(android.R.string.cancel, (dialog, which) -> {
               })
               .create();

   }

    @Override
    public void onClick(View v) {
        CalendarDatePickerDialogFragment kalenderPicker =
                new CalendarDatePickerDialogFragment()
                        .setOnDateSetListener(this)
                        .setFirstDayOfWeek(editDatum.getWochenbeginn())
                        .setPreselectedDate(
                                editDatum.get(Calendar.YEAR),
                                editDatum.get(Calendar.MONTH) - 1,
                                editDatum.get(Calendar.DAY_OF_MONTH));
        if (ASettings.isThemaDunkel)
            kalenderPicker.setThemeDark();
        else
            kalenderPicker.setThemeLight();

        kalenderPicker.show(mFragmentManager, editName);
    }


    @Override
    public void onDateSet(CalendarDatePickerDialogFragment dialog, int year, int monthOfYear, int dayOfMonth) {
        editDatum.set(year, monthOfYear+1, dayOfMonth);
        tDatum.setText(editDatum.getString_Datum(mContext));
    }
}
