/*
 * Copyright (c) 2014 - 2025 askanimus@gmail.com
 *
 * This File is part of "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).  If not, see <http://www.gnu.org/licenses/>.
 * Diese Datei ist Teil von "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
 * veröffentlichten Version, weiter verteilen und/oder modifizieren.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <https://www.gnu.org/licenses/>.
 */

package askanimus.arbeitszeiterfassung2.feiertage;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import askanimus.arbeitszeiterfassung2.R;
import askanimus.arbeitszeiterfassung2.setup.ASettings;

public class FeiertageListAdapter extends BaseExpandableListAdapter {
    private final Context mContext;

    private final FeiertageCallbacks mCallback;

    private final FeiertageListe mFeiertage;

    public FeiertageListAdapter(Context context, FeiertageListe tagesliste, int jahr, FeiertageCallbacks cb){
        mContext = context;
        mCallback = cb;
        mFeiertage = tagesliste;

    }


    @Override
    public Feiertag getChild(int posJahr, int posTag) {
        return mFeiertage.getFeiertag(posJahr, posTag);
    }

    @Override
    public long getChildId(int posJahr, int posTag) {
        return getChild(posJahr, posTag).getId();
    }

    @Override
    public View getChildView(int posJahr, int posTag, boolean isLastChild, View contentView, ViewGroup parent) {
        LayoutInflater mInflater = (LayoutInflater) mContext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        if (mInflater != null) {
            contentView = mInflater.inflate(R.layout.item_feiertag_zeile, parent, false);

            TextView textFeiertag = contentView.findViewById(R.id.F_Zeile_Text);
            ImageView buttonKopie = contentView.findViewById(R.id.F_Zeile_kopie);
            ImageView buttonDelete = contentView.findViewById(R.id.F_Zeile_delete);

            textFeiertag.setText(String.format("%s (%s)", getChild(posJahr, posTag).getDatumStart().getString_Datum(mContext), getChild(posJahr, posTag).getName()));

            contentView.findViewById(R.id.F_container).setBackgroundColor(ASettings.aktJob.getFarbe_Hintergrund());

            textFeiertag.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mCallback.onFeiertagEdit(getChild(posJahr, posTag));
                }
            });

            buttonKopie.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mCallback.onFeiertagKopie(posJahr, posTag);
                }
            });

            buttonDelete.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mCallback.onFeiertagDelete(posJahr, posTag);
                }
            });
        }
        return contentView;
    }

    @Override
    public int getChildrenCount(int posJahr) {
        return mFeiertage.getAnzahlFeiertageJahr(posJahr);
    }

    @Override
    public FeiertageJahr getGroup(int posJahr) {
        return mFeiertage.getFeiertageJahr(posJahr);
    }

    @Override
    public int getGroupCount() {
        return mFeiertage.getAnzahlJahre();
    }

    @Override
    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @Override
    public View getGroupView(int posJahr, boolean isExpanded, View contentView, ViewGroup parent) {
      LayoutInflater mInflater = (LayoutInflater) mContext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        if (mInflater != null) {
            contentView = mInflater.inflate(R.layout.item_feiertag_zeile, parent, false);

            TextView textJahr = contentView.findViewById(R.id.F_Zeile_Text);
            ImageView buttonDelete = contentView.findViewById(R.id.F_Zeile_delete);
            ImageView buttonKopie = contentView.findViewById(R.id.F_Zeile_kopie);
            buttonKopie.setVisibility(View.GONE);

            textJahr.setText(String.valueOf(mFeiertage.getJahr(posJahr)));

            buttonDelete.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mCallback.onJahrDelete(posJahr);
                }
            });
        }

        return contentView;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return false;
    }

    /*
     * Callback interface
     */
    public interface FeiertageCallbacks {
        /**
         * Aufgerufen wenn sich Werte des Tages geändert haben
         */
        void onFeiertagEdit(Feiertag feiertag);
        void onFeiertagKopie(int posJahr, int posTag);
        void onFeiertagDelete(int posJahr, int posTag);
        void onJahrDelete(int posJahr);
    }
}
