/*
 * Copyright (c) 2014 - 2025 askanimus@gmail.com
 *
 * This File is part of "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).  If not, see <http://www.gnu.org/licenses/>.
 * Diese Datei ist Teil von "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2).
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) ist Freie Software: Sie können es unter den Bedingungen
 * der GNU General Public License, wie von der Free Software Foundation,
 * Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
 * veröffentlichten Version, weiter verteilen und/oder modifizieren.
 * "Arbeitszeitkonto" (askanimus.arbeitszeiterfassung2) wird in der Hoffnung, dass es nützlich sein wird, aber
 * OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
 * Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
 * Siehe die GNU General Public License für weitere Details.
 * Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 * Programm erhalten haben. Wenn nicht, siehe <https://www.gnu.org/licenses/>.
 */

package askanimus.arbeitszeiterfassung2.feiertage;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;

import askanimus.arbeitszeiterfassung2.Datum;
import askanimus.arbeitszeiterfassung2.Ics.icsTermin;
import askanimus.arbeitszeiterfassung2.datenbank.DatenbankHelper;
import askanimus.arbeitszeiterfassung2.setup.ASettings;

public class Feiertag extends icsTermin {
    private long id;

    public Feiertag(){
        super();
        id =  -1;
    }

    @SuppressLint("Range")
    public Feiertag(Cursor dbResult){
            super();
            id = dbResult.getLong(dbResult.getColumnIndex(DatenbankHelper.DB_F_ID));
            setStart(
                    dbResult.getInt(dbResult.getColumnIndex(DatenbankHelper.DB_F_JAHR)),
                    dbResult.getInt(dbResult.getColumnIndex(DatenbankHelper.DB_F_MONAT)),
                    dbResult.getInt(dbResult.getColumnIndex(DatenbankHelper.DB_F_TAG)),
                    -1
            );
            setName(dbResult.getString(dbResult.getColumnIndex(DatenbankHelper.DB_F_NAME)));
    }

    public Feiertag(int jahr, int monat, int tag, String name){
        super();
        id =  -1;
        setStart(jahr, monat, tag, -1);
        setName(name);
    }

    public Feiertag(Feiertag feiertag){
        super();
        id= -1;
        datStart = new Datum(feiertag.getDatumStart());
        name = feiertag.getName();
    }

    public long getId(){
        return id;
    }

    public int getJahr() {
        return getDatumStart().getJahr();
    }

    public void save(){
       ContentValues werte = new ContentValues();
       werte.put(DatenbankHelper.DB_F_JAHR, getJahr());
       werte.put(DatenbankHelper.DB_F_MONAT, getDatumStart().getMonat());
       werte.put(DatenbankHelper.DB_F_TAG, getDatumStart().getTagimMonat());
       werte.put(DatenbankHelper.DB_F_NAME, getName());
       if(id < 0){
           id = ASettings.mDatenbank.insert(DatenbankHelper.DB_T_FEIERTAGE, null, werte);
       } else {
          ASettings.mDatenbank.update(
                  DatenbankHelper.DB_T_FEIERTAGE,
                  werte,
                  DatenbankHelper.DB_F_ID + "=?", new String[]{Long.toString(id)});
       }
    }

    boolean loesche(){
        int rows = ASettings.mDatenbank.delete(
                DatenbankHelper.DB_T_FEIERTAGE,
                DatenbankHelper.DB_F_ID + "=?",
                new String[]{Long.toString(id)}
        );
        return rows > 0;
    }
}
