/*******************************************************************************
 * Copyright (C) 2023 Andreas Redmer <ar-lato@abga.be>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ardash.lato.terrain.distributors;

import java.util.TreeMap;

import ardash.lato.terrain.TerrainItemType;

public abstract class ColliderDistributor extends TerrainItemDistributor {

	private static final TreeMap<Integer, TerrainItemType> COLLIDER_RANGE_MAP = new TreeMap<>();

	public ColliderDistributor() {
		super();
	}

	@Override
	protected TreeMap<Integer, TerrainItemType> getRangeMap() {
		return COLLIDER_RANGE_MAP;
	}

}