<p align="center">
<img alt="Wispar" src= "https://github.com/Scriptbash/Wispar/blob/main/assets/icon/icon.png?raw=true" width="100">
</p>
<h3 align="center">Stay up-to-date with academic journals and the latest research articles!</h3>
<p align="center">
<a href="https://github.com/Scriptbash/Wispar/actions/workflows/build.yml">
    <img alt="GitHub Workflow Status" src="https://github.com/Scriptbash/Wispar/actions/workflows/build.yml/badge.svg">
</a>
<a href="https://hosted.weblate.org/engage/wispar/">
<img src="https://hosted.weblate.org/widget/wispar/svg-badge.svg" alt="Translation status" />
</a>
<a href="https://doi.org/10.5281/zenodo.14901602"><img src="https://zenodo.org/badge/732206774.svg" alt="DOI"></a>
</br>
<a href="https://play.google.com/store/apps/details?id=app.wispar.wispar" target="_blank">
  <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Get it on Google Play" height="50"/>
</a>
<a href="https://apps.apple.com/us/app/wispar/id6741366984" target="_blank">
  <img src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" alt="Download on the App Store"width="150">
</a>
</br>
<a href="https://f-droid.org/packages/app.wispar.wispar">
    <img src="https://f-droid.org/badge/get-it-on.png"
    alt="Get it on F-Droid"
    height="80">
</a>
</br></br>
<a href='https://ko-fi.com/A0A6ME7SJ' target='_blank'><img height='36' style='border:0px;height:36px;' src='https://storage.ko-fi.com/cdn/kofi5.png?v=6' border='0' alt='Buy Me a Coffee at ko-fi.com' /></a>
</p>

---

## Description
<p align="justify">
Wispar is a user-friendly and privacy-friendly Android/iOS app that seamlessly searches scientific journals and articles using the Crossref and OpenAlex APIs. Stay updated on your preferred journals by following them and receive new article abstracts in your main feed. No account required. The integration of Unpaywall ensures convenient access to open-access articles, while EZproxy helps overcome subscription barriers.  
</p>

## Features overview
<ul>
    <li> [x] Search and follow journals</li>
    <li> [x] Search for articles and save the queries for easy access later. You can even include them in your feed!</li>
    <li> [x] Download articles for offline reading</li>
    <li> [x] EZproxy and Unpaywall integration</li>
    <li> [x] Send articles to Zotero</li>
    <li> [x] Share articles</li>
    <li> [x] Scrape missing abstracts</li>
    <li> [x] Scrape graphical abstracts</li>
    <li> [x] Export/Import the local database</li>
    <li> [x] Notifications and background journals updates</li>
    <li> [x] Create custom feeds</li>
    <li> [x] Customizable swipe gestures</li>
    <li> [x] Translate title and abstracts (requires an AI API key)</li>
    <li> [x] Chat with your papers using AI</li>
</ul>

## Translations

<p align ="justify">
Wispar uses Weblate to manage translations. You can find the hosted instance at <a href="https://hosted.weblate.org/engage/wispar/">https://hosted.weblate.org/engage/wispar/</a>

A huge thank you to Weblate for hosting the translations for free :heart:.

Translation status:
</p>
<a href="https://hosted.weblate.org/engage/wispar/">
<img src="https://hosted.weblate.org/widget/wispar/multi-auto.svg" alt="Translation status" />
</a>

## Contribute
<p align ="justify">
    <ul>
        <li>There are many ways you can contribute to improving Wispar—and it's not just about writing code!</li>
        <li>You can help translate Wispar into your language by using our hosted Weblate instance.</li>
        <li>Additionally, providing feedback and reporting bugs are invaluable ways to contribute!</li>
    </ul>
    <b>If you contribute to the project, feel free to add yourself to the .zenodo.json file to be credited!</b>
</p>

## Help
<p align ="justify">
If you run into any issue while using Wispar, have a question or want to share your feedback, please open an issue here : https://github.com/Scriptbash/Wispar/issues
</p>

## Credits
<ul>
    <li>Thank you<a href="https://github.com/reds2401" target='_blank'> Sergio </a>for the original app icon and <a href="https://github.com/Meigane" target='_blank'> Lingling </a>for the updated app icon!</li>
    <li><a href="https://libproxy-db.org/" target='_blank'>Library Proxy URL Database</a></li>
    <li><a href="https://unpaywall.org/" target='_blank'>Unpaywall</a></li>
    <li><a href="https://www.crossref.org/" target='_blank'>Crossref</a></li>
    <li><a href="https://openalex.org/" target='_blank'>OpenAlex</a></li>
</ul>

## Screenshots



| ![Feed](android/fastlane/metadata/android/en-US/images/phoneScreenshots/1_en-US.png) | ![Abstract](android/fastlane/metadata/android/en-US/images/phoneScreenshots/2_en-US.png) | ![Search](android/fastlane/metadata/android/en-US/images/phoneScreenshots/3_en-US.png) |
|---|---|---|
| ![Customize feed](android/fastlane/metadata/android/en-US/images/phoneScreenshots/4_en-US.png) | ![Journal latest publications](android/fastlane/metadata/android/en-US/images/phoneScreenshots/5_en-US.png) | ![Settings](android/fastlane/metadata/android/en-US/images/phoneScreenshots/8_en-US.png) |
