import * as zod_v4_mini from 'zod/v4-mini';
import { z } from 'zod/v4-mini';
import * as zod_v4_core from 'zod/v4/core';
import { GetComments as GetComments$1, ListCommunities as ListCommunities$1, GetPosts as GetPosts$1, Search as Search$1 } from 'lemmy-js-client-v0';
export { LemmyErrorType } from 'lemmy-js-client-v0';
import { GetComments as GetComments$2, ListCommunities as ListCommunities$2, GetPosts as GetPosts$2, Search as Search$2 } from 'lemmy-js-client-v1';

declare const PersonAggregates$1: z.ZodMiniObject<{
    comment_count: z.ZodMiniNumber<number>;
    post_count: z.ZodMiniNumber<number>;
}, z.core.$strip>;
declare const PersonView$1: z.ZodMiniObject<{
    counts: z.ZodMiniObject<{
        comment_count: z.ZodMiniNumber<number>;
        post_count: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    is_admin: z.ZodMiniBoolean<boolean>;
    person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;

declare const Comment$1: z.ZodMiniObject<{
    /**
     * The federated activity id / ap_id.
     */
    ap_id: z.ZodMiniString<string>;
    content: z.ZodMiniString<string>;
    creator_id: z.ZodMiniNumber<number>;
    /**
     * Whether the comment has been deleted by its creator.
     */
    deleted: z.ZodMiniBoolean<boolean>;
    /**
     * Whether the comment has been distinguished(speaking officially) by a mod.
     */
    distinguished: z.ZodMiniBoolean<boolean>;
    id: z.ZodMiniNumber<number>;
    language_id: z.ZodMiniNumber<number>;
    /**
     * Whether the comment is local.
     */
    local: z.ZodMiniBoolean<boolean>;
    /**
     * The path / tree location of a comment, separated by dots, ending with the comment's id. Ex:
     * 0.24.27
     */
    path: z.ZodMiniString<string>;
    post_id: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    /**
     * Whether the comment has been removed.
     */
    removed: z.ZodMiniBoolean<boolean>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;

/**
 * A comment reply.
 */
declare const CommentReply$1: z.ZodMiniObject<{
    comment_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    read: z.ZodMiniBoolean<boolean>;
    recipient_id: z.ZodMiniNumber<number>;
}, z.core.$strip>;

/**
 * A comment reply view.
 */
declare const CommentReplyView$1: z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    comment_reply: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        read: z.ZodMiniBoolean<boolean>;
        recipient_id: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    recipient: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>;

/**
 * A comment report.
 */
declare const CommentReport$1: z.ZodMiniObject<{
    comment_id: z.ZodMiniNumber<number>;
    creator_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    original_comment_text: z.ZodMiniString<string>;
    published: z.ZodMiniString<string>;
    reason: z.ZodMiniString<string>;
    resolved: z.ZodMiniBoolean<boolean>;
    resolver_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;

/**
 * A comment report view.
 */
declare const CommentReportView$1: z.ZodMiniObject<{
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    comment_creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    comment_report: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        original_comment_text: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
        reason: z.ZodMiniString<string>;
        resolved: z.ZodMiniBoolean<boolean>;
        resolver_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    resolver: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>;

declare const CommentAggregates$1: z.ZodMiniObject<{
    /**
     * The total number of children in this comment branch.
     */
    child_count: z.ZodMiniNumber<number>;
    comment_id: z.ZodMiniNumber<number>;
    downvotes: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    score: z.ZodMiniNumber<number>;
    upvotes: z.ZodMiniNumber<number>;
}, z.core.$strip>;
declare const CommentView$1: z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        /**
         * The total number of children in this comment branch.
         */
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>;

declare const Community$1: z.ZodMiniObject<{
    actor_id: z.ZodMiniString<string>;
    banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
    deleted: z.ZodMiniBoolean<boolean>;
    description: z.ZodMiniOptional<z.ZodMiniString<string>>;
    hidden: z.ZodMiniBoolean<boolean>;
    icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
    id: z.ZodMiniNumber<number>;
    local: z.ZodMiniBoolean<boolean>;
    name: z.ZodMiniString<string>;
    nsfw: z.ZodMiniBoolean<boolean>;
    posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
    published: z.ZodMiniString<string>;
    removed: z.ZodMiniBoolean<boolean>;
    title: z.ZodMiniString<string>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    visibility: z.ZodMiniEnum<{
        Public: "Public";
        Unlisted: "Unlisted";
        LocalOnlyPublic: "LocalOnlyPublic";
        LocalOnlyPrivate: "LocalOnlyPrivate";
        Private: "Private";
    }>;
}, z.core.$strip>;

declare const CommunityAggregates$1: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
    comments: z.ZodMiniNumber<number>;
    posts: z.ZodMiniNumber<number>;
    subscribers: z.ZodMiniNumber<number>;
}, z.core.$strip>, z.ZodMiniObject<{
    comments: z.ZodMiniNumber<number>;
    posts: z.ZodMiniNumber<number>;
    subscribers: z.ZodMiniNumber<number>;
    subscribers_local: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last day.
     */
    users_active_day: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last year.
     */
    users_active_half_year: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last month.
     */
    users_active_month: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last week.
     */
    users_active_week: z.ZodMiniNumber<number>;
}, z.core.$strip>]>;

declare const CommunityFollowerView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    follower: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;

declare const CommunityModeratorView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    moderator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;

declare const CommunityView$1: z.ZodMiniObject<{
    blocked: z.ZodMiniBoolean<boolean>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        posts: z.ZodMiniNumber<number>;
        subscribers: z.ZodMiniNumber<number>;
    }, z.core.$strip>, z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        posts: z.ZodMiniNumber<number>;
        subscribers: z.ZodMiniNumber<number>;
        subscribers_local: z.ZodMiniNumber<number>;
        users_active_day: z.ZodMiniNumber<number>;
        users_active_half_year: z.ZodMiniNumber<number>;
        users_active_month: z.ZodMiniNumber<number>;
        users_active_week: z.ZodMiniNumber<number>;
    }, z.core.$strip>]>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>;

/**
 * Defines who can browse and interact with content in a community.
 */
declare const CommunityVisibility$1: z.ZodMiniEnum<{
    Public: "Public";
    Unlisted: "Unlisted";
    LocalOnlyPublic: "LocalOnlyPublic";
    LocalOnlyPrivate: "LocalOnlyPrivate";
    Private: "Private";
}>;

/**
 * A list of federated instances.
 */
declare const FederatedInstances$1: z.ZodMiniObject<{
    allowed: z.ZodMiniArray<z.ZodMiniObject<{
        domain: z.ZodMiniString<string>;
        federation_state: z.ZodMiniOptional<z.ZodMiniObject<{
            fail_count: z.ZodMiniNumber<number>;
            instance_id: z.ZodMiniNumber<number>;
            last_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
            last_successful_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
            last_successful_published_time: z.ZodMiniOptional<z.ZodMiniString<string>>;
            next_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        software: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        version: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>>;
    blocked: z.ZodMiniArray<z.ZodMiniObject<{
        domain: z.ZodMiniString<string>;
        federation_state: z.ZodMiniOptional<z.ZodMiniObject<{
            fail_count: z.ZodMiniNumber<number>;
            instance_id: z.ZodMiniNumber<number>;
            last_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
            last_successful_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
            last_successful_published_time: z.ZodMiniOptional<z.ZodMiniString<string>>;
            next_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        software: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        version: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>>;
    linked: z.ZodMiniArray<z.ZodMiniObject<{
        domain: z.ZodMiniString<string>;
        federation_state: z.ZodMiniOptional<z.ZodMiniObject<{
            fail_count: z.ZodMiniNumber<number>;
            instance_id: z.ZodMiniNumber<number>;
            last_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
            last_successful_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
            last_successful_published_time: z.ZodMiniOptional<z.ZodMiniString<string>>;
            next_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        software: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        version: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>>;
}, z.core.$strip>;

/**
 * A wrapper for the captcha response.
 */
declare const GetCaptchaResponse$1: z.ZodMiniObject<{
    /**
     * Will be None if captchas are disabled.
     */
    ok: z.ZodMiniOptional<z.ZodMiniObject<{
        /**
         * A Base64 encoded png
         */
        png: z.ZodMiniString<string>;
        /**
         * The UUID for the captcha item.
         */
        uuid: z.ZodMiniString<string>;
        /**
         * A Base64 encoded wav audio
         */
        wav: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;

declare const GetCommunityResponse$1: z.ZodMiniObject<{
    community_view: z.ZodMiniObject<{
        blocked: z.ZodMiniBoolean<boolean>;
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        counts: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
            comments: z.ZodMiniNumber<number>;
            posts: z.ZodMiniNumber<number>;
            subscribers: z.ZodMiniNumber<number>;
        }, z.core.$strip>, z.ZodMiniObject<{
            comments: z.ZodMiniNumber<number>;
            posts: z.ZodMiniNumber<number>;
            subscribers: z.ZodMiniNumber<number>;
            subscribers_local: z.ZodMiniNumber<number>;
            users_active_day: z.ZodMiniNumber<number>;
            users_active_half_year: z.ZodMiniNumber<number>;
            users_active_month: z.ZodMiniNumber<number>;
            users_active_week: z.ZodMiniNumber<number>;
        }, z.core.$strip>]>;
        subscribed: z.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, z.core.$strip>;
    moderators: z.ZodMiniArray<z.ZodMiniObject<{
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        moderator: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
}, z.core.$strip>;

/**
 * When a moderator removes a post.
 */
declare const ModRemovePost$1: z.ZodMiniObject<{
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    post_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    removed: z.ZodMiniBoolean<boolean>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a moderator locks a post (prevents new comments being made).
 */
declare const ModLockPost$1: z.ZodMiniObject<{
    id: z.ZodMiniNumber<number>;
    locked: z.ZodMiniBoolean<boolean>;
    mod_person_id: z.ZodMiniNumber<number>;
    post_id: z.ZodMiniNumber<number>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a moderator features a post on a community (pins it to the top).
 */
declare const ModFeaturePost$1: z.ZodMiniObject<{
    featured: z.ZodMiniBoolean<boolean>;
    id: z.ZodMiniNumber<number>;
    is_featured_community: z.ZodMiniBoolean<boolean>;
    mod_person_id: z.ZodMiniNumber<number>;
    post_id: z.ZodMiniNumber<number>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a moderator removes a comment.
 */
declare const ModRemoveComment$1: z.ZodMiniObject<{
    comment_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    removed: z.ZodMiniBoolean<boolean>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a moderator removes a community.
 */
declare const ModRemoveCommunity$1: z.ZodMiniObject<{
    community_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    removed: z.ZodMiniBoolean<boolean>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When someone is banned from a community.
 */
declare const ModBanFromCommunity$1: z.ZodMiniObject<{
    banned: z.ZodMiniBoolean<boolean>;
    community_id: z.ZodMiniNumber<number>;
    expires: z.ZodMiniOptional<z.ZodMiniString<string>>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    other_person_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When someone is banned from the site.
 */
declare const ModBan$1: z.ZodMiniObject<{
    banned: z.ZodMiniBoolean<boolean>;
    expires: z.ZodMiniOptional<z.ZodMiniString<string>>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    other_person_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When someone is added as a community moderator.
 */
declare const ModAddCommunity$1: z.ZodMiniObject<{
    community_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    other_person_id: z.ZodMiniNumber<number>;
    removed: z.ZodMiniBoolean<boolean>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a moderator transfers a community to a new owner.
 */
declare const ModTransferCommunity$1: z.ZodMiniObject<{
    community_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    other_person_id: z.ZodMiniNumber<number>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When someone is added as a site moderator.
 */
declare const ModAdd$1: z.ZodMiniObject<{
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    other_person_id: z.ZodMiniNumber<number>;
    removed: z.ZodMiniBoolean<boolean>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When an admin purges a person.
 */
declare const AdminPurgePerson$1: z.ZodMiniObject<{
    admin_person_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When an admin purges a community.
 */
declare const AdminPurgeCommunity$1: z.ZodMiniObject<{
    admin_person_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When an admin purges a post.
 */
declare const AdminPurgePost$1: z.ZodMiniObject<{
    admin_person_id: z.ZodMiniNumber<number>;
    community_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When an admin purges a comment.
 */
declare const AdminPurgeComment$1: z.ZodMiniObject<{
    admin_person_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    post_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a community is hidden from public view.
 */
declare const ModHideCommunity$1: z.ZodMiniObject<{
    community_id: z.ZodMiniNumber<number>;
    hidden: z.ZodMiniBoolean<boolean>;
    id: z.ZodMiniNumber<number>;
    mod_person_id: z.ZodMiniNumber<number>;
    reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
    when_: z.ZodMiniString<string>;
}, z.core.$strip>;
/**
 * When a moderator removes a post.
 */
declare const ModRemovePostView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_remove_post: z.ZodMiniObject<{
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When a moderator locks a post (prevents new comments being made).
 */
declare const ModLockPostView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_lock_post: z.ZodMiniObject<{
        id: z.ZodMiniNumber<number>;
        locked: z.ZodMiniBoolean<boolean>;
        mod_person_id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When a moderator features a post on a community (pins it to the top).
 */
declare const ModFeaturePostView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_feature_post: z.ZodMiniObject<{
        featured: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        is_featured_community: z.ZodMiniBoolean<boolean>;
        mod_person_id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When a moderator removes a comment.
 */
declare const ModRemoveCommentView$1: z.ZodMiniObject<{
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    commenter: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_remove_comment: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When a moderator removes a community.
 */
declare const ModRemoveCommunityView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_remove_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * When someone is banned from a community.
 */
declare const ModBanFromCommunityView$1: z.ZodMiniObject<{
    banned_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_ban_from_community: z.ZodMiniObject<{
        banned: z.ZodMiniBoolean<boolean>;
        community_id: z.ZodMiniNumber<number>;
        expires: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * When someone is banned from the site.
 */
declare const ModBanView$1: z.ZodMiniObject<{
    banned_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    mod_ban: z.ZodMiniObject<{
        banned: z.ZodMiniBoolean<boolean>;
        expires: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * When someone is added as a community moderator.
 */
declare const ModAddCommunityView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_add_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    modded_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * When a moderator transfers a community to a new owner.
 */
declare const ModTransferCommunityView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_transfer_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    modded_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * When someone is added as a site moderator.
 */
declare const ModAddView$1: z.ZodMiniObject<{
    mod_add: z.ZodMiniObject<{
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    modded_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * When an admin purges a person.
 */
declare const AdminPurgePersonView$1: z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_person: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When an admin purges a community.
 */
declare const AdminPurgeCommunityView$1: z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_community: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When an admin purges a post.
 */
declare const AdminPurgePostView$1: z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_post: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When an admin purges a comment.
 */
declare const AdminPurgeCommentView$1: z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_comment: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * When a community is hidden from public view.
 */
declare const ModHideCommunityView$1: z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_hide_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        hidden: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * The modlog fetch response.
 */
declare const ModlogItem$1: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_remove_post: z.ZodMiniObject<{
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_lock_post: z.ZodMiniObject<{
        id: z.ZodMiniNumber<number>;
        locked: z.ZodMiniBoolean<boolean>;
        mod_person_id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_feature_post: z.ZodMiniObject<{
        featured: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        is_featured_community: z.ZodMiniBoolean<boolean>;
        mod_person_id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    commenter: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_remove_comment: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_remove_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodMiniObject<{
    banned_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_ban_from_community: z.ZodMiniObject<{
        banned: z.ZodMiniBoolean<boolean>;
        community_id: z.ZodMiniNumber<number>;
        expires: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodMiniObject<{
    banned_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    mod_ban: z.ZodMiniObject<{
        banned: z.ZodMiniBoolean<boolean>;
        expires: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_add_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    modded_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_transfer_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    modded_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodMiniObject<{
    mod_add: z.ZodMiniObject<{
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        other_person_id: z.ZodMiniNumber<number>;
        removed: z.ZodMiniBoolean<boolean>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    modded_person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    moderator: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_person: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_community: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_post: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        community_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    admin_purge_comment: z.ZodMiniObject<{
        admin_person_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        post_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    admin: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    mod_hide_community: z.ZodMiniObject<{
        community_id: z.ZodMiniNumber<number>;
        hidden: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        mod_person_id: z.ZodMiniNumber<number>;
        reason: z.ZodMiniOptional<z.ZodMiniString<string>>;
        when_: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>]>;

/**
 * A person's details response.
 */
declare const GetPersonDetailsResponse$1: z.ZodMiniObject<{
    moderates: z.ZodMiniArray<z.ZodMiniObject<{
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        moderator: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
    person_view: z.ZodMiniObject<{
        counts: z.ZodMiniObject<{
            comment_count: z.ZodMiniNumber<number>;
            post_count: z.ZodMiniNumber<number>;
        }, z.core.$strip>;
        is_admin: z.ZodMiniBoolean<boolean>;
        person: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>;
}, z.core.$strip>;

/**
 * Site metadata, from its opengraph tags.
 */
declare const LinkMetadata$1: z.ZodMiniObject<{
    content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    description: z.ZodMiniOptional<z.ZodMiniString<string>>;
    embed_video_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
    image: z.ZodMiniOptional<z.ZodMiniString<string>>;
    title: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;
/**
 * The site metadata response.
 */
declare const GetSiteMetadataResponse$1: z.ZodMiniObject<{
    metadata: z.ZodMiniObject<{
        content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_video_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        image: z.ZodMiniOptional<z.ZodMiniString<string>>;
        title: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;

declare const MyUserInfo$1: z.ZodMiniObject<{
    community_blocks: z.ZodMiniArray<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>>;
    follows: z.ZodMiniArray<z.ZodMiniObject<{
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        follower: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
    instance_blocks: z.ZodMiniArray<z.ZodMiniObject<{
        domain: z.ZodMiniString<string>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        software: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        version: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>>;
    local_user_view: z.ZodMiniObject<{
        counts: z.ZodMiniObject<{
            comment_count: z.ZodMiniNumber<number>;
            post_count: z.ZodMiniNumber<number>;
        }, z.core.$strip>;
        local_user: z.ZodMiniObject<{
            admin: z.ZodMiniBoolean<boolean>;
            show_nsfw: z.ZodMiniBoolean<boolean>;
        }, z.core.$strip>;
        person: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>;
    moderates: z.ZodMiniArray<z.ZodMiniObject<{
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        moderator: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
    person_blocks: z.ZodMiniArray<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
}, z.core.$strip>;
declare const LocalSite$1: z.ZodMiniObject<{
    /**
     * An optional registration application questionnaire in markdown.
     */
    application_question: z.ZodMiniOptional<z.ZodMiniString<string>>;
    captcha_enabled: z.ZodMiniBoolean<boolean>;
    /**
     * What kind of comment downvotes your site allows.
     */
    comment_downvotes: z.ZodMiniEnum<{
        All: "All";
        Local: "Local";
        Disable: "Disable";
    }>;
    /**
     * What kind of comment upvotes your site allows.
     */
    comment_upvotes: z.ZodMiniEnum<{
        All: "All";
        Local: "Local";
        Disable: "Disable";
    }>;
    legal_information: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * What kind of post downvotes your site allows.
     */
    post_downvotes: z.ZodMiniEnum<{
        All: "All";
        Local: "Local";
        Disable: "Disable";
    }>;
    /**
     * What kind of post upvotes your site allows.
     */
    post_upvotes: z.ZodMiniEnum<{
        All: "All";
        Local: "Local";
        Disable: "Disable";
    }>;
    registration_mode: z.ZodMiniEnum<{
        Closed: "Closed";
        RequireApplication: "RequireApplication";
        Open: "Open";
    }>;
    require_email_verification: z.ZodMiniBoolean<boolean>;
}, z.core.$strip>;
declare const Site$1: z.ZodMiniObject<{
    actor_id: z.ZodMiniString<string>;
    banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
    description: z.ZodMiniOptional<z.ZodMiniString<string>>;
    icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
    name: z.ZodMiniString<string>;
    sidebar: z.ZodMiniOptional<z.ZodMiniString<string>>;
    version: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;
declare const SiteView$1: z.ZodMiniObject<{
    counts: z.ZodMiniOptional<z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        communities: z.ZodMiniNumber<number>;
        posts: z.ZodMiniNumber<number>;
        users: z.ZodMiniNumber<number>;
        users_active_day: z.ZodMiniNumber<number>;
        users_active_half_year: z.ZodMiniNumber<number>;
        users_active_month: z.ZodMiniNumber<number>;
        users_active_week: z.ZodMiniNumber<number>;
    }, z.core.$strip>>;
    local_site: z.ZodMiniObject<{
        /**
         * An optional registration application questionnaire in markdown.
         */
        application_question: z.ZodMiniOptional<z.ZodMiniString<string>>;
        captcha_enabled: z.ZodMiniBoolean<boolean>;
        /**
         * What kind of comment downvotes your site allows.
         */
        comment_downvotes: z.ZodMiniEnum<{
            All: "All";
            Local: "Local";
            Disable: "Disable";
        }>;
        /**
         * What kind of comment upvotes your site allows.
         */
        comment_upvotes: z.ZodMiniEnum<{
            All: "All";
            Local: "Local";
            Disable: "Disable";
        }>;
        legal_information: z.ZodMiniOptional<z.ZodMiniString<string>>;
        /**
         * What kind of post downvotes your site allows.
         */
        post_downvotes: z.ZodMiniEnum<{
            All: "All";
            Local: "Local";
            Disable: "Disable";
        }>;
        /**
         * What kind of post upvotes your site allows.
         */
        post_upvotes: z.ZodMiniEnum<{
            All: "All";
            Local: "Local";
            Disable: "Disable";
        }>;
        registration_mode: z.ZodMiniEnum<{
            Closed: "Closed";
            RequireApplication: "RequireApplication";
            Open: "Open";
        }>;
        require_email_verification: z.ZodMiniBoolean<boolean>;
    }, z.core.$strip>;
    site: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        name: z.ZodMiniString<string>;
        sidebar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        version: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
}, z.core.$strip>;
declare const GetSiteResponse$1: z.ZodMiniObject<{
    admins: z.ZodMiniArray<z.ZodMiniObject<{
        counts: z.ZodMiniObject<{
            comment_count: z.ZodMiniNumber<number>;
            post_count: z.ZodMiniNumber<number>;
        }, z.core.$strip>;
        is_admin: z.ZodMiniBoolean<boolean>;
        person: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
    my_user: z.ZodMiniOptional<z.ZodMiniObject<{
        community_blocks: z.ZodMiniArray<z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>>;
        follows: z.ZodMiniArray<z.ZodMiniObject<{
            community: z.ZodMiniObject<{
                actor_id: z.ZodMiniString<string>;
                banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
                deleted: z.ZodMiniBoolean<boolean>;
                description: z.ZodMiniOptional<z.ZodMiniString<string>>;
                hidden: z.ZodMiniBoolean<boolean>;
                icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
                id: z.ZodMiniNumber<number>;
                local: z.ZodMiniBoolean<boolean>;
                name: z.ZodMiniString<string>;
                nsfw: z.ZodMiniBoolean<boolean>;
                posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
                published: z.ZodMiniString<string>;
                removed: z.ZodMiniBoolean<boolean>;
                title: z.ZodMiniString<string>;
                updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
                visibility: z.ZodMiniEnum<{
                    Public: "Public";
                    Unlisted: "Unlisted";
                    LocalOnlyPublic: "LocalOnlyPublic";
                    LocalOnlyPrivate: "LocalOnlyPrivate";
                    Private: "Private";
                }>;
            }, z.core.$strip>;
            follower: z.ZodMiniObject<{
                actor_id: z.ZodMiniString<string>;
                avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
                banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
                bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
                bot_account: z.ZodMiniBoolean<boolean>;
                deleted: z.ZodMiniBoolean<boolean>;
                display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
                id: z.ZodMiniNumber<number>;
                local: z.ZodMiniBoolean<boolean>;
                name: z.ZodMiniString<string>;
                published: z.ZodMiniString<string>;
            }, z.core.$strip>;
        }, z.core.$strip>>;
        instance_blocks: z.ZodMiniArray<z.ZodMiniObject<{
            domain: z.ZodMiniString<string>;
            id: z.ZodMiniNumber<number>;
            published: z.ZodMiniString<string>;
            software: z.ZodMiniOptional<z.ZodMiniString<string>>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            version: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>>;
        local_user_view: z.ZodMiniObject<{
            counts: z.ZodMiniObject<{
                comment_count: z.ZodMiniNumber<number>;
                post_count: z.ZodMiniNumber<number>;
            }, z.core.$strip>;
            local_user: z.ZodMiniObject<{
                admin: z.ZodMiniBoolean<boolean>;
                show_nsfw: z.ZodMiniBoolean<boolean>;
            }, z.core.$strip>;
            person: z.ZodMiniObject<{
                actor_id: z.ZodMiniString<string>;
                avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
                banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
                bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
                bot_account: z.ZodMiniBoolean<boolean>;
                deleted: z.ZodMiniBoolean<boolean>;
                display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
                id: z.ZodMiniNumber<number>;
                local: z.ZodMiniBoolean<boolean>;
                name: z.ZodMiniString<string>;
                published: z.ZodMiniString<string>;
            }, z.core.$strip>;
        }, z.core.$strip>;
        moderates: z.ZodMiniArray<z.ZodMiniObject<{
            community: z.ZodMiniObject<{
                actor_id: z.ZodMiniString<string>;
                banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
                deleted: z.ZodMiniBoolean<boolean>;
                description: z.ZodMiniOptional<z.ZodMiniString<string>>;
                hidden: z.ZodMiniBoolean<boolean>;
                icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
                id: z.ZodMiniNumber<number>;
                local: z.ZodMiniBoolean<boolean>;
                name: z.ZodMiniString<string>;
                nsfw: z.ZodMiniBoolean<boolean>;
                posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
                published: z.ZodMiniString<string>;
                removed: z.ZodMiniBoolean<boolean>;
                title: z.ZodMiniString<string>;
                updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
                visibility: z.ZodMiniEnum<{
                    Public: "Public";
                    Unlisted: "Unlisted";
                    LocalOnlyPublic: "LocalOnlyPublic";
                    LocalOnlyPrivate: "LocalOnlyPrivate";
                    Private: "Private";
                }>;
            }, z.core.$strip>;
            moderator: z.ZodMiniObject<{
                actor_id: z.ZodMiniString<string>;
                avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
                banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
                bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
                bot_account: z.ZodMiniBoolean<boolean>;
                deleted: z.ZodMiniBoolean<boolean>;
                display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
                id: z.ZodMiniNumber<number>;
                local: z.ZodMiniBoolean<boolean>;
                name: z.ZodMiniString<string>;
                published: z.ZodMiniString<string>;
            }, z.core.$strip>;
        }, z.core.$strip>>;
        person_blocks: z.ZodMiniArray<z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    site_view: z.ZodMiniObject<{
        counts: z.ZodMiniOptional<z.ZodMiniObject<{
            comments: z.ZodMiniNumber<number>;
            communities: z.ZodMiniNumber<number>;
            posts: z.ZodMiniNumber<number>;
            users: z.ZodMiniNumber<number>;
            users_active_day: z.ZodMiniNumber<number>;
            users_active_half_year: z.ZodMiniNumber<number>;
            users_active_month: z.ZodMiniNumber<number>;
            users_active_week: z.ZodMiniNumber<number>;
        }, z.core.$strip>>;
        local_site: z.ZodMiniObject<{
            /**
             * An optional registration application questionnaire in markdown.
             */
            application_question: z.ZodMiniOptional<z.ZodMiniString<string>>;
            captcha_enabled: z.ZodMiniBoolean<boolean>;
            /**
             * What kind of comment downvotes your site allows.
             */
            comment_downvotes: z.ZodMiniEnum<{
                All: "All";
                Local: "Local";
                Disable: "Disable";
            }>;
            /**
             * What kind of comment upvotes your site allows.
             */
            comment_upvotes: z.ZodMiniEnum<{
                All: "All";
                Local: "Local";
                Disable: "Disable";
            }>;
            legal_information: z.ZodMiniOptional<z.ZodMiniString<string>>;
            /**
             * What kind of post downvotes your site allows.
             */
            post_downvotes: z.ZodMiniEnum<{
                All: "All";
                Local: "Local";
                Disable: "Disable";
            }>;
            /**
             * What kind of post upvotes your site allows.
             */
            post_upvotes: z.ZodMiniEnum<{
                All: "All";
                Local: "Local";
                Disable: "Disable";
            }>;
            registration_mode: z.ZodMiniEnum<{
                Closed: "Closed";
                RequireApplication: "RequireApplication";
                Open: "Open";
            }>;
            require_email_verification: z.ZodMiniBoolean<boolean>;
        }, z.core.$strip>;
        site: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            name: z.ZodMiniString<string>;
            sidebar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            version: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>;
    }, z.core.$strip>;
    version: z.ZodMiniString<string>;
}, z.core.$strip>;

declare const GetUnreadCountResponse$1: z.ZodMiniObject<{
    mentions: z.ZodMiniNumber<number>;
    private_messages: z.ZodMiniNumber<number>;
    replies: z.ZodMiniNumber<number>;
}, z.core.$strip>;

/**
 * A federated instance / site.
 */
declare const Instance$1: z.ZodMiniObject<{
    domain: z.ZodMiniString<string>;
    id: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    software: z.ZodMiniOptional<z.ZodMiniString<string>>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    version: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;

declare const InstanceWithFederationState$1: z.ZodMiniObject<{
    domain: z.ZodMiniString<string>;
    /**
     * if federation to this instance is or was active, show state of outgoing federation to this
     * instance
     */
    federation_state: z.ZodMiniOptional<z.ZodMiniObject<{
        fail_count: z.ZodMiniNumber<number>;
        instance_id: z.ZodMiniNumber<number>;
        last_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
        last_successful_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
        last_successful_published_time: z.ZodMiniOptional<z.ZodMiniString<string>>;
        next_retry: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>>;
    id: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    software: z.ZodMiniOptional<z.ZodMiniString<string>>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    version: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;

/**
 * A listing type for post and comment list fetches.
 */
declare const ListingType$1: z.ZodMiniEnum<{
    Subscribed: "Subscribed";
    All: "All";
    Local: "Local";
    ModeratorView: "ModeratorView";
}>;

/**
 * A response for your login.
 */
declare const LoginResponse$1: z.ZodMiniObject<{
    /**
     * This is None in response to `Register` if email verification is enabled, or the server
     * requires registration applications.
     */
    jwt: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * If registration applications are required, this will return true for a signup response.
     *
     * Omitted for piefed
     */
    registration_created: z.ZodMiniOptional<z.ZodMiniBoolean<boolean>>;
    /**
     * If email verifications are required, this will return true for a signup response.
     *
     * Omitted for piefed
     */
    verify_email_sent: z.ZodMiniOptional<z.ZodMiniBoolean<boolean>>;
}, z.core.$strip>;

declare const Notification$1: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    comment_reply: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        read: z.ZodMiniBoolean<boolean>;
        recipient_id: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    recipient: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>, z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    person_mention: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        read: z.ZodMiniBoolean<boolean>;
        recipient_id: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    recipient: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>, z.ZodMiniObject<{
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    private_message: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        read: z.ZodMiniBoolean<boolean>;
        recipient_id: z.ZodMiniNumber<number>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    recipient: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>]>;

declare const PageCursor$2: z.ZodMiniUnion<readonly [z.ZodMiniString<string>, z.ZodMiniNumber<number>]>;
declare const PagableResponse$1: z.ZodMiniObject<{
    next_page: z.ZodMiniOptional<z.ZodMiniUnion<readonly [z.ZodMiniString<string>, z.ZodMiniNumber<number>]>>;
    prev_page: z.ZodMiniOptional<z.ZodMiniUnion<readonly [z.ZodMiniString<string>, z.ZodMiniNumber<number>]>>;
}, z.core.$strip>;

declare const Person$1: z.ZodMiniObject<{
    actor_id: z.ZodMiniString<string>;
    avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
    banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
    bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
    bot_account: z.ZodMiniBoolean<boolean>;
    deleted: z.ZodMiniBoolean<boolean>;
    display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
    id: z.ZodMiniNumber<number>;
    local: z.ZodMiniBoolean<boolean>;
    name: z.ZodMiniString<string>;
    published: z.ZodMiniString<string>;
}, z.core.$strip>;

/**
 * A person's content response.
 */
declare const PersonContentItem$1: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        newest_comment_time: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    hidden: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    read: z.ZodMiniBoolean<boolean>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
    unread_comments: z.ZodMiniNumber<number>;
}, z.core.$strip>, z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>]>;

/**
 * A person mention.
 */
declare const PersonMention$1: z.ZodMiniObject<{
    comment_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    read: z.ZodMiniBoolean<boolean>;
    recipient_id: z.ZodMiniNumber<number>;
}, z.core.$strip>;

/**
 * A person mention view.
 */
declare const PersonMentionView$1: z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    person_mention: z.ZodMiniObject<{
        comment_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        read: z.ZodMiniBoolean<boolean>;
        recipient_id: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    recipient: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>;

declare const Post$1: z.ZodMiniObject<{
    /**
     * An optional alt_text, usable for image posts.
     */
    alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * The federated activity id / ap_id.
     */
    ap_id: z.ZodMiniString<string>;
    /**
     * An optional post body, in markdown.
     */
    body: z.ZodMiniOptional<z.ZodMiniString<string>>;
    community_id: z.ZodMiniNumber<number>;
    creator_id: z.ZodMiniNumber<number>;
    /**
     * Whether the post is deleted.
     */
    deleted: z.ZodMiniBoolean<boolean>;
    /**
     * A description for the link.
     */
    embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * A title for the link.
     */
    embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * Whether the post is featured to its community.
     */
    featured_community: z.ZodMiniBoolean<boolean>;
    /**
     * Whether the post is featured to its site.
     */
    featured_local: z.ZodMiniBoolean<boolean>;
    id: z.ZodMiniNumber<number>;
    language_id: z.ZodMiniNumber<number>;
    /**
     * Whether the post is local.
     */
    local: z.ZodMiniBoolean<boolean>;
    /**
     * Whether the post is locked.
     */
    locked: z.ZodMiniBoolean<boolean>;
    name: z.ZodMiniString<string>;
    /**
     * Whether the post is NSFW.
     */
    nsfw: z.ZodMiniBoolean<boolean>;
    published: z.ZodMiniString<string>;
    /**
     * Whether the post is removed.
     */
    removed: z.ZodMiniBoolean<boolean>;
    /**
     * A thumbnail picture url.
     */
    thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * An optional link / url for the post.
     */
    url: z.ZodMiniOptional<z.ZodMiniString<string>>;
    url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;

/**
 * A post report.
 */
declare const PostReport$1: z.ZodMiniObject<{
    creator_id: z.ZodMiniNumber<number>;
    id: z.ZodMiniNumber<number>;
    /**
     * The original post body.
     */
    original_post_body: z.ZodMiniOptional<z.ZodMiniString<string>>;
    /**
     * The original post title.
     */
    original_post_name: z.ZodMiniString<string>;
    /**
     * The original post url.
     */
    original_post_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
    post_id: z.ZodMiniNumber<number>;
    published: z.ZodMiniString<string>;
    reason: z.ZodMiniString<string>;
    resolved: z.ZodMiniBoolean<boolean>;
    resolver_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
}, z.core.$strip>;

/**
 * A post report view.
 */
declare const PostReportView$1: z.ZodMiniObject<{
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        newest_comment_time: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    hidden: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    post_creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    post_report: z.ZodMiniObject<{
        creator_id: z.ZodMiniNumber<number>;
        id: z.ZodMiniNumber<number>;
        original_post_body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        original_post_name: z.ZodMiniString<string>;
        original_post_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        reason: z.ZodMiniString<string>;
        resolved: z.ZodMiniBoolean<boolean>;
        resolver_id: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    read: z.ZodMiniBoolean<boolean>;
    resolver: z.ZodMiniOptional<z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
    unread_comments: z.ZodMiniNumber<number>;
}, z.core.$strip>;

declare const PostAggregates$1: z.ZodMiniObject<{
    comments: z.ZodMiniNumber<number>;
    downvotes: z.ZodMiniNumber<number>;
    /**
     * The time of the newest comment in the post.
     */
    newest_comment_time: z.ZodMiniString<string>;
    published: z.ZodMiniString<string>;
    score: z.ZodMiniNumber<number>;
    upvotes: z.ZodMiniNumber<number>;
}, z.core.$strip>;
declare const PostView$1: z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        /**
         * The time of the newest comment in the post.
         */
        newest_comment_time: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    hidden: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    read: z.ZodMiniBoolean<boolean>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
    unread_comments: z.ZodMiniNumber<number>;
}, z.core.$strip>;

/**
 * A private message view.
 */
declare const PrivateMessageView$1: z.ZodMiniObject<{
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    private_message: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        read: z.ZodMiniBoolean<boolean>;
        recipient_id: z.ZodMiniNumber<number>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    recipient: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>;

/**
 * The registration mode for your site. Determines what happens after a user signs up.
 */
declare const RegistrationMode$1: z.ZodMiniEnum<{
    Closed: "Closed";
    RequireApplication: "RequireApplication";
    Open: "Open";
}>;

declare const ResolveObjectResponse$1: z.ZodMiniObject<{
    comment: z.ZodMiniOptional<z.ZodMiniObject<{
        banned_from_community: z.ZodMiniBoolean<boolean>;
        comment: z.ZodMiniObject<{
            ap_id: z.ZodMiniString<string>;
            content: z.ZodMiniString<string>;
            creator_id: z.ZodMiniNumber<number>;
            deleted: z.ZodMiniBoolean<boolean>;
            distinguished: z.ZodMiniBoolean<boolean>;
            id: z.ZodMiniNumber<number>;
            language_id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            path: z.ZodMiniString<string>;
            post_id: z.ZodMiniNumber<number>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>;
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        counts: z.ZodMiniObject<{
            child_count: z.ZodMiniNumber<number>;
            comment_id: z.ZodMiniNumber<number>;
            downvotes: z.ZodMiniNumber<number>;
            published: z.ZodMiniString<string>;
            score: z.ZodMiniNumber<number>;
            upvotes: z.ZodMiniNumber<number>;
        }, z.core.$strip>;
        creator: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
        creator_banned_from_community: z.ZodMiniBoolean<boolean>;
        creator_is_admin: z.ZodMiniBoolean<boolean>;
        creator_is_moderator: z.ZodMiniBoolean<boolean>;
        my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
        post: z.ZodMiniObject<{
            alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
            ap_id: z.ZodMiniString<string>;
            body: z.ZodMiniOptional<z.ZodMiniString<string>>;
            community_id: z.ZodMiniNumber<number>;
            creator_id: z.ZodMiniNumber<number>;
            deleted: z.ZodMiniBoolean<boolean>;
            embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
            featured_community: z.ZodMiniBoolean<boolean>;
            featured_local: z.ZodMiniBoolean<boolean>;
            id: z.ZodMiniNumber<number>;
            language_id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            locked: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            url: z.ZodMiniOptional<z.ZodMiniString<string>>;
            url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>;
        saved: z.ZodMiniBoolean<boolean>;
        subscribed: z.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, z.core.$strip>>;
    community: z.ZodMiniOptional<z.ZodMiniObject<{
        blocked: z.ZodMiniBoolean<boolean>;
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        counts: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
            comments: z.ZodMiniNumber<number>;
            posts: z.ZodMiniNumber<number>;
            subscribers: z.ZodMiniNumber<number>;
        }, z.core.$strip>, z.ZodMiniObject<{
            comments: z.ZodMiniNumber<number>;
            posts: z.ZodMiniNumber<number>;
            subscribers: z.ZodMiniNumber<number>;
            subscribers_local: z.ZodMiniNumber<number>;
            users_active_day: z.ZodMiniNumber<number>;
            users_active_half_year: z.ZodMiniNumber<number>;
            users_active_month: z.ZodMiniNumber<number>;
            users_active_week: z.ZodMiniNumber<number>;
        }, z.core.$strip>]>;
        subscribed: z.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, z.core.$strip>>;
    person: z.ZodMiniOptional<z.ZodMiniObject<{
        counts: z.ZodMiniObject<{
            comment_count: z.ZodMiniNumber<number>;
            post_count: z.ZodMiniNumber<number>;
        }, z.core.$strip>;
        is_admin: z.ZodMiniBoolean<boolean>;
        person: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
    }, z.core.$strip>>;
    post: z.ZodMiniOptional<z.ZodMiniObject<{
        banned_from_community: z.ZodMiniBoolean<boolean>;
        community: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            deleted: z.ZodMiniBoolean<boolean>;
            description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            hidden: z.ZodMiniBoolean<boolean>;
            icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            title: z.ZodMiniString<string>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            visibility: z.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, z.core.$strip>;
        counts: z.ZodMiniObject<{
            comments: z.ZodMiniNumber<number>;
            downvotes: z.ZodMiniNumber<number>;
            newest_comment_time: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
            score: z.ZodMiniNumber<number>;
            upvotes: z.ZodMiniNumber<number>;
        }, z.core.$strip>;
        creator: z.ZodMiniObject<{
            actor_id: z.ZodMiniString<string>;
            avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
            banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
            bot_account: z.ZodMiniBoolean<boolean>;
            deleted: z.ZodMiniBoolean<boolean>;
            display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
            id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            published: z.ZodMiniString<string>;
        }, z.core.$strip>;
        creator_banned_from_community: z.ZodMiniBoolean<boolean>;
        creator_blocked: z.ZodMiniBoolean<boolean>;
        creator_is_admin: z.ZodMiniBoolean<boolean>;
        creator_is_moderator: z.ZodMiniBoolean<boolean>;
        hidden: z.ZodMiniBoolean<boolean>;
        my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
        post: z.ZodMiniObject<{
            alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
            ap_id: z.ZodMiniString<string>;
            body: z.ZodMiniOptional<z.ZodMiniString<string>>;
            community_id: z.ZodMiniNumber<number>;
            creator_id: z.ZodMiniNumber<number>;
            deleted: z.ZodMiniBoolean<boolean>;
            embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
            embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
            featured_community: z.ZodMiniBoolean<boolean>;
            featured_local: z.ZodMiniBoolean<boolean>;
            id: z.ZodMiniNumber<number>;
            language_id: z.ZodMiniNumber<number>;
            local: z.ZodMiniBoolean<boolean>;
            locked: z.ZodMiniBoolean<boolean>;
            name: z.ZodMiniString<string>;
            nsfw: z.ZodMiniBoolean<boolean>;
            published: z.ZodMiniString<string>;
            removed: z.ZodMiniBoolean<boolean>;
            thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
            updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
            url: z.ZodMiniOptional<z.ZodMiniString<string>>;
            url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
        }, z.core.$strip>;
        read: z.ZodMiniBoolean<boolean>;
        saved: z.ZodMiniBoolean<boolean>;
        subscribed: z.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: z.ZodMiniNumber<number>;
    }, z.core.$strip>>;
}, z.core.$strip>;

declare const SearchItem$1: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    comment: z.ZodMiniObject<{
        ap_id: z.ZodMiniString<string>;
        content: z.ZodMiniString<string>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        distinguished: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        path: z.ZodMiniString<string>;
        post_id: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        child_count: z.ZodMiniNumber<number>;
        comment_id: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>, z.ZodMiniObject<{
    blocked: z.ZodMiniBoolean<boolean>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniUnion<readonly [z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        posts: z.ZodMiniNumber<number>;
        subscribers: z.ZodMiniNumber<number>;
    }, z.core.$strip>, z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        posts: z.ZodMiniNumber<number>;
        subscribers: z.ZodMiniNumber<number>;
        subscribers_local: z.ZodMiniNumber<number>;
        users_active_day: z.ZodMiniNumber<number>;
        users_active_half_year: z.ZodMiniNumber<number>;
        users_active_month: z.ZodMiniNumber<number>;
        users_active_week: z.ZodMiniNumber<number>;
    }, z.core.$strip>]>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
}, z.core.$strip>, z.ZodMiniObject<{
    counts: z.ZodMiniObject<{
        comment_count: z.ZodMiniNumber<number>;
        post_count: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    is_admin: z.ZodMiniBoolean<boolean>;
    person: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodMiniObject<{
    banned_from_community: z.ZodMiniBoolean<boolean>;
    community: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        deleted: z.ZodMiniBoolean<boolean>;
        description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        hidden: z.ZodMiniBoolean<boolean>;
        icon: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        posting_restricted_to_mods: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        title: z.ZodMiniString<string>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        visibility: z.ZodMiniEnum<{
            Public: "Public";
            Unlisted: "Unlisted";
            LocalOnlyPublic: "LocalOnlyPublic";
            LocalOnlyPrivate: "LocalOnlyPrivate";
            Private: "Private";
        }>;
    }, z.core.$strip>;
    counts: z.ZodMiniObject<{
        comments: z.ZodMiniNumber<number>;
        downvotes: z.ZodMiniNumber<number>;
        newest_comment_time: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
        score: z.ZodMiniNumber<number>;
        upvotes: z.ZodMiniNumber<number>;
    }, z.core.$strip>;
    creator: z.ZodMiniObject<{
        actor_id: z.ZodMiniString<string>;
        avatar: z.ZodMiniOptional<z.ZodMiniString<string>>;
        banner: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bio: z.ZodMiniOptional<z.ZodMiniString<string>>;
        bot_account: z.ZodMiniBoolean<boolean>;
        deleted: z.ZodMiniBoolean<boolean>;
        display_name: z.ZodMiniOptional<z.ZodMiniString<string>>;
        id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        published: z.ZodMiniString<string>;
    }, z.core.$strip>;
    creator_banned_from_community: z.ZodMiniBoolean<boolean>;
    creator_blocked: z.ZodMiniBoolean<boolean>;
    creator_is_admin: z.ZodMiniBoolean<boolean>;
    creator_is_moderator: z.ZodMiniBoolean<boolean>;
    hidden: z.ZodMiniBoolean<boolean>;
    my_vote: z.ZodMiniOptional<z.ZodMiniNumber<number>>;
    post: z.ZodMiniObject<{
        alt_text: z.ZodMiniOptional<z.ZodMiniString<string>>;
        ap_id: z.ZodMiniString<string>;
        body: z.ZodMiniOptional<z.ZodMiniString<string>>;
        community_id: z.ZodMiniNumber<number>;
        creator_id: z.ZodMiniNumber<number>;
        deleted: z.ZodMiniBoolean<boolean>;
        embed_description: z.ZodMiniOptional<z.ZodMiniString<string>>;
        embed_title: z.ZodMiniOptional<z.ZodMiniString<string>>;
        featured_community: z.ZodMiniBoolean<boolean>;
        featured_local: z.ZodMiniBoolean<boolean>;
        id: z.ZodMiniNumber<number>;
        language_id: z.ZodMiniNumber<number>;
        local: z.ZodMiniBoolean<boolean>;
        locked: z.ZodMiniBoolean<boolean>;
        name: z.ZodMiniString<string>;
        nsfw: z.ZodMiniBoolean<boolean>;
        published: z.ZodMiniString<string>;
        removed: z.ZodMiniBoolean<boolean>;
        thumbnail_url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        updated: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url: z.ZodMiniOptional<z.ZodMiniString<string>>;
        url_content_type: z.ZodMiniOptional<z.ZodMiniString<string>>;
    }, z.core.$strip>;
    read: z.ZodMiniBoolean<boolean>;
    saved: z.ZodMiniBoolean<boolean>;
    subscribed: z.ZodMiniEnum<{
        Subscribed: "Subscribed";
        NotSubscribed: "NotSubscribed";
        Pending: "Pending";
        ApprovalRequired: "ApprovalRequired";
    }>;
    unread_comments: z.ZodMiniNumber<number>;
}, z.core.$strip>]>;

/**
 * Aggregate data for a site.
 */
declare const SiteAggregates$1: z.ZodMiniObject<{
    comments: z.ZodMiniNumber<number>;
    communities: z.ZodMiniNumber<number>;
    posts: z.ZodMiniNumber<number>;
    users: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last day.
     */
    users_active_day: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last half year.
     */
    users_active_half_year: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last month.
     */
    users_active_month: z.ZodMiniNumber<number>;
    /**
     * The number of users with any activity in the last week.
     */
    users_active_week: z.ZodMiniNumber<number>;
}, z.core.$strip>;

/**
 * A type / status for a community subscribe.
 */
declare const SubscribedType$1: z.ZodMiniEnum<{
    Subscribed: "Subscribed";
    NotSubscribed: "NotSubscribed";
    Pending: "Pending";
    ApprovalRequired: "ApprovalRequired";
}>;

declare const UploadImageResponse$1: z.ZodMiniObject<{
    delete_token: z.ZodMiniOptional<z.ZodMiniString<string>>;
    url: z.ZodMiniString<string>;
}, z.core.$strip>;

declare const ListPostsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            newest_comment_time: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        read: zod_v4_mini.ZodMiniBoolean<boolean>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: zod_v4_mini.ZodMiniNumber<number>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListCommentsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListModlogResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_remove_post: zod_v4_mini.ZodMiniObject<{
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_lock_post: zod_v4_mini.ZodMiniObject<{
            id: zod_v4_mini.ZodMiniNumber<number>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_feature_post: zod_v4_mini.ZodMiniObject<{
            featured: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            is_featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        commenter: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_remove_comment: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_remove_community: zod_v4_mini.ZodMiniObject<{
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        banned_person: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_ban_from_community: zod_v4_mini.ZodMiniObject<{
            banned: zod_v4_mini.ZodMiniBoolean<boolean>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            expires: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            other_person_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        banned_person: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        mod_ban: zod_v4_mini.ZodMiniObject<{
            banned: zod_v4_mini.ZodMiniBoolean<boolean>;
            expires: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            other_person_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_add_community: zod_v4_mini.ZodMiniObject<{
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            other_person_id: zod_v4_mini.ZodMiniNumber<number>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        modded_person: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_transfer_community: zod_v4_mini.ZodMiniObject<{
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            other_person_id: zod_v4_mini.ZodMiniNumber<number>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        modded_person: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        mod_add: zod_v4_mini.ZodMiniObject<{
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            other_person_id: zod_v4_mini.ZodMiniNumber<number>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        modded_person: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        moderator: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        admin: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        admin_purge_person: zod_v4_mini.ZodMiniObject<{
            admin_person_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        admin: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        admin_purge_community: zod_v4_mini.ZodMiniObject<{
            admin_person_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        admin: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        admin_purge_post: zod_v4_mini.ZodMiniObject<{
            admin_person_id: zod_v4_mini.ZodMiniNumber<number>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        admin: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        admin_purge_comment: zod_v4_mini.ZodMiniObject<{
            admin_person_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        admin: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        mod_hide_community: zod_v4_mini.ZodMiniObject<{
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            mod_person_id: zod_v4_mini.ZodMiniNumber<number>;
            reason: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            when_: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>]>>;
}, zod_v4_core.$strip>;
declare const ListNotificationsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        comment_reply: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            read: zod_v4_mini.ZodMiniBoolean<boolean>;
            recipient_id: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        recipient: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        person_mention: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            read: zod_v4_mini.ZodMiniBoolean<boolean>;
            recipient_id: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        recipient: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        private_message: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            read: zod_v4_mini.ZodMiniBoolean<boolean>;
            recipient_id: zod_v4_mini.ZodMiniNumber<number>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        recipient: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>]>>;
}, zod_v4_core.$strip>;
declare const ListPersonMentionsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        person_mention: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            read: zod_v4_mini.ZodMiniBoolean<boolean>;
            recipient_id: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        recipient: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListPrivateMessagesResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        private_message: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            read: zod_v4_mini.ZodMiniBoolean<boolean>;
            recipient_id: zod_v4_mini.ZodMiniNumber<number>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        recipient: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListRepliesResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        comment_reply: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            read: zod_v4_mini.ZodMiniBoolean<boolean>;
            recipient_id: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        recipient: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListCommentReportsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        comment_creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        comment_report: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            original_comment_text: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            reason: zod_v4_mini.ZodMiniString<string>;
            resolved: zod_v4_mini.ZodMiniBoolean<boolean>;
            resolver_id: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        resolver: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListCommunitiesResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            posts: zod_v4_mini.ZodMiniNumber<number>;
            subscribers: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            posts: zod_v4_mini.ZodMiniNumber<number>;
            subscribers: zod_v4_mini.ZodMiniNumber<number>;
            subscribers_local: zod_v4_mini.ZodMiniNumber<number>;
            users_active_day: zod_v4_mini.ZodMiniNumber<number>;
            users_active_half_year: zod_v4_mini.ZodMiniNumber<number>;
            users_active_month: zod_v4_mini.ZodMiniNumber<number>;
            users_active_week: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>]>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListPersonContentResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            newest_comment_time: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        read: zod_v4_mini.ZodMiniBoolean<boolean>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: zod_v4_mini.ZodMiniNumber<number>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>]>>;
}, zod_v4_core.$strip>;
declare const ListPostReportsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            newest_comment_time: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        post_creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        post_report: zod_v4_mini.ZodMiniObject<{
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            original_post_body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            original_post_name: zod_v4_mini.ZodMiniString<string>;
            original_post_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            reason: zod_v4_mini.ZodMiniString<string>;
            resolved: zod_v4_mini.ZodMiniBoolean<boolean>;
            resolver_id: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        read: zod_v4_mini.ZodMiniBoolean<boolean>;
        resolver: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: zod_v4_mini.ZodMiniNumber<number>;
    }, zod_v4_core.$strip>>;
}, zod_v4_core.$strip>;
declare const ListReportsResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        comment_creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        comment_report: zod_v4_mini.ZodMiniObject<{
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            original_comment_text: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            reason: zod_v4_mini.ZodMiniString<string>;
            resolved: zod_v4_mini.ZodMiniBoolean<boolean>;
            resolver_id: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        resolver: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            newest_comment_time: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        post_creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        post_report: zod_v4_mini.ZodMiniObject<{
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            original_post_body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            original_post_name: zod_v4_mini.ZodMiniString<string>;
            original_post_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            reason: zod_v4_mini.ZodMiniString<string>;
            resolved: zod_v4_mini.ZodMiniBoolean<boolean>;
            resolver_id: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        read: zod_v4_mini.ZodMiniBoolean<boolean>;
        resolver: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: zod_v4_mini.ZodMiniNumber<number>;
    }, zod_v4_core.$strip>]>>;
}, zod_v4_core.$strip>;
declare const ListSearchResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            posts: zod_v4_mini.ZodMiniNumber<number>;
            subscribers: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            posts: zod_v4_mini.ZodMiniNumber<number>;
            subscribers: zod_v4_mini.ZodMiniNumber<number>;
            subscribers_local: zod_v4_mini.ZodMiniNumber<number>;
            users_active_day: zod_v4_mini.ZodMiniNumber<number>;
            users_active_half_year: zod_v4_mini.ZodMiniNumber<number>;
            users_active_month: zod_v4_mini.ZodMiniNumber<number>;
            users_active_week: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>]>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        counts: zod_v4_mini.ZodMiniObject<{
            comment_count: zod_v4_mini.ZodMiniNumber<number>;
            post_count: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        person: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            newest_comment_time: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        read: zod_v4_mini.ZodMiniBoolean<boolean>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: zod_v4_mini.ZodMiniNumber<number>;
    }, zod_v4_core.$strip>]>>;
}, zod_v4_core.$strip>;
declare const ListPersonLikedResponse$1: zod_v4_mini.ZodMiniObject<{
    next_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    prev_page: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniString<string>, zod_v4_mini.ZodMiniNumber<number>]>>;
    data: zod_v4_mini.ZodMiniArray<zod_v4_mini.ZodMiniUnion<readonly [zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            comments: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            newest_comment_time: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_blocked: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        read: zod_v4_mini.ZodMiniBoolean<boolean>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
        unread_comments: zod_v4_mini.ZodMiniNumber<number>;
    }, zod_v4_core.$strip>, zod_v4_mini.ZodMiniObject<{
        banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        comment: zod_v4_mini.ZodMiniObject<{
            ap_id: zod_v4_mini.ZodMiniString<string>;
            content: zod_v4_mini.ZodMiniString<string>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            distinguished: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            path: zod_v4_mini.ZodMiniString<string>;
            post_id: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        community: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            hidden: zod_v4_mini.ZodMiniBoolean<boolean>;
            icon: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            posting_restricted_to_mods: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            title: zod_v4_mini.ZodMiniString<string>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            visibility: zod_v4_mini.ZodMiniEnum<{
                Public: "Public";
                Unlisted: "Unlisted";
                LocalOnlyPublic: "LocalOnlyPublic";
                LocalOnlyPrivate: "LocalOnlyPrivate";
                Private: "Private";
            }>;
        }, zod_v4_core.$strip>;
        counts: zod_v4_mini.ZodMiniObject<{
            child_count: zod_v4_mini.ZodMiniNumber<number>;
            comment_id: zod_v4_mini.ZodMiniNumber<number>;
            downvotes: zod_v4_mini.ZodMiniNumber<number>;
            published: zod_v4_mini.ZodMiniString<string>;
            score: zod_v4_mini.ZodMiniNumber<number>;
            upvotes: zod_v4_mini.ZodMiniNumber<number>;
        }, zod_v4_core.$strip>;
        creator: zod_v4_mini.ZodMiniObject<{
            actor_id: zod_v4_mini.ZodMiniString<string>;
            avatar: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            banner: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bio: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            bot_account: zod_v4_mini.ZodMiniBoolean<boolean>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            display_name: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            published: zod_v4_mini.ZodMiniString<string>;
        }, zod_v4_core.$strip>;
        creator_banned_from_community: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_admin: zod_v4_mini.ZodMiniBoolean<boolean>;
        creator_is_moderator: zod_v4_mini.ZodMiniBoolean<boolean>;
        my_vote: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniNumber<number>>;
        post: zod_v4_mini.ZodMiniObject<{
            alt_text: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            ap_id: zod_v4_mini.ZodMiniString<string>;
            body: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            community_id: zod_v4_mini.ZodMiniNumber<number>;
            creator_id: zod_v4_mini.ZodMiniNumber<number>;
            deleted: zod_v4_mini.ZodMiniBoolean<boolean>;
            embed_description: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            embed_title: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            featured_community: zod_v4_mini.ZodMiniBoolean<boolean>;
            featured_local: zod_v4_mini.ZodMiniBoolean<boolean>;
            id: zod_v4_mini.ZodMiniNumber<number>;
            language_id: zod_v4_mini.ZodMiniNumber<number>;
            local: zod_v4_mini.ZodMiniBoolean<boolean>;
            locked: zod_v4_mini.ZodMiniBoolean<boolean>;
            name: zod_v4_mini.ZodMiniString<string>;
            nsfw: zod_v4_mini.ZodMiniBoolean<boolean>;
            published: zod_v4_mini.ZodMiniString<string>;
            removed: zod_v4_mini.ZodMiniBoolean<boolean>;
            thumbnail_url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            updated: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
            url_content_type: zod_v4_mini.ZodMiniOptional<zod_v4_mini.ZodMiniString<string>>;
        }, zod_v4_core.$strip>;
        saved: zod_v4_mini.ZodMiniBoolean<boolean>;
        subscribed: zod_v4_mini.ZodMiniEnum<{
            Subscribed: "Subscribed";
            NotSubscribed: "NotSubscribed";
            Pending: "Pending";
            ApprovalRequired: "ApprovalRequired";
        }>;
    }, zod_v4_core.$strip>]>>;
}, zod_v4_core.$strip>;

/**
 * Ban a user from a community.
 */
type BanFromCommunity = {
    ban: boolean;
    community_id: number;
    /**
     * A time that the ban will expire, in unix epoch seconds.
     *
     * An i64 unix timestamp is used for a simpler API client implementation.
     */
    expires?: number;
    person_id: number;
    reason?: string;
    /**
     * Optionally remove or restore all their data. Useful for new troll accounts.
     * If ban is true, then this means remove. If ban is false, it means restore.
     */
    remove_or_restore_data?: boolean;
};

/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */
interface paths {
    "/api/alpha/site": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Gets the site, and your user data. */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetSiteResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/site/version": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Gets version of PieFed. */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetSiteVersionResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/site/block": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Block an instance. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["BlockInstanceRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["BlockInstanceResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/site/instance_chooser": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Gets the site info for use by other instances in the Instance Chooser functionality. */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetSiteInstanceChooserResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/site/instance_chooser_search": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Search for other instances. */
        get: {
            parameters: {
                query?: {
                    q?: string;
                    nsfw?: string;
                    language?: string;
                    newbie?: string;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetSiteInstanceChooserSearchResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/search": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Search PieFed. */
        get: {
            parameters: {
                query: {
                    q: string;
                    type_: "Communities" | "Posts" | "Users" | "Url";
                    limit?: number;
                    listing_type?: "All" | "Local" | "Subscribed" | "Popular" | "Moderating" | "ModeratorView";
                    page?: number;
                    sort?: "Active" | "Hot" | "New" | "Top" | "TopHour" | "TopSixHour" | "TopTwelveHour" | "TopDay" | "TopWeek" | "TopMonth" | "TopThreeMonths" | "TopSixMonths" | "TopNineMonths" | "TopYear" | "TopAll" | "Scaled" | "Old";
                    community_name?: string;
                    community_id?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["SearchResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/resolve_object": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Fetch a non-local / federated object. */
        get: {
            parameters: {
                query: {
                    q: string;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ResolveObjectResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/federated_instances": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Fetch federated instances. */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetFederatedInstancesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get / fetch a community. */
        get: {
            parameters: {
                query?: {
                    id?: number;
                    name?: string;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Edit community. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["EditCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Create a new community. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CreateCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** List communities, with various filters. */
        get: {
            parameters: {
                query?: {
                    limit?: number;
                    page?: number;
                    show_nsfw?: boolean;
                    sort?: "Hot" | "Top" | "New";
                    type_?: "All" | "Local" | "Subscribed";
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListCommunitiesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/follow": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Follow / subscribe to a community. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["FollowCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/block": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Block a community. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["BlockCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["BlockCommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/subscribe": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Subscribe to activities in a community. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["SubscribeCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/delete": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Delete a community. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["DeleteCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/mod": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Add or remove a moderator for your community. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["ModCommunityRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ModCommunityResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/moderate/bans": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get the list of banned users for a community. */
        get: {
            parameters: {
                query: {
                    community_id: number;
                    limit?: number;
                    page?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityModerationBansListResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/moderate/unban": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Unban a user from a community. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CommunityModerationUnbanRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityModerationBanItem"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/moderate/ban": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Ban a user from a community. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CommunityModerationBanRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityModerationBanItem"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/moderate/post/nsfw": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Mark or unmark a post as NSFW. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CommunityModerationNsfwRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PostView"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/flair": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Edit an existing post flair in the community */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CommunityFlairEditRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityFlairEditResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Create a new post flair in the community */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CommunityFlairCreateRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityFlairCreateResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/community/flair/delete": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Delete a post flair in a community */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CommunityFlairDeleteRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["CommunityFlairDeleteResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/feed/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get list of feeds */
        get: {
            parameters: {
                query?: {
                    /** @description include list of communities in each feed with result */
                    include_communities?: boolean;
                    /** @description only return feeds created by the authorized user */
                    mine_only?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["FeedListResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/topic/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get list of topics */
        get: {
            parameters: {
                query?: {
                    /** @description include list of communities in each topic with result */
                    include_communities?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["TopicListResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get the details for a person */
        get: {
            parameters: {
                query?: {
                    /** @description One of either person_id or username must be specified */
                    person_id?: number;
                    /** @description One of either person_id or username must be specified */
                    username?: string;
                    sort?: "Active" | "Hot" | "New" | "Top" | "TopHour" | "TopSixHour" | "TopTwelveHour" | "TopDay" | "TopWeek" | "TopMonth" | "TopThreeMonths" | "TopSixMonths" | "TopNineMonths" | "TopYear" | "TopAll" | "Scaled" | "Old";
                    page?: number;
                    limit?: number;
                    /** @description Limit posts/comments to just a single community */
                    community_id?: number;
                    saved_only?: boolean;
                    include_content?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetUserResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/login": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Log into PieFed */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserLoginRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserLoginResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/unread_count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get your unread counts */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserUnreadCountsResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/replies": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get comment replies */
        get: {
            parameters: {
                query?: {
                    limit?: number;
                    page?: number;
                    sort?: "Hot" | "Top" | "New" | "Old";
                    unread_only?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserRepliesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/mentions": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get mentions of your account made in comments */
        get: {
            parameters: {
                query?: {
                    limit?: number;
                    page?: number;
                    sort?: "Hot" | "Top" | "New" | "Old";
                    unread_only?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserMentionsResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/block": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Block or unblock a person */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserBlockRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserBlockResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/mark_all_as_read": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Mark all notifications and messages as read */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserMarkAllReadResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/subscribe": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Subscribe or unsubscribe to activites of another user */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserSubscribeRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserSubscribeResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/save_user_settings": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Save your user settings */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserSaveSettingsRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserSaveSettingsResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/notifications": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get your user notifications (not all notification types supported yet) */
        get: {
            parameters: {
                query: {
                    status: "All" | "Unread" | "Read";
                    limit?: number;
                    page?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserNotificationsResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/notification_state": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Set the read status of a given notification (not all notification types supported yet) */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserNotificationStateRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserNotificationItemView"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/notifications_count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get user unread notifications count */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserNotificationsCountResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/mark_all_notifications_read": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Mark all notifications as read */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserMarkAllNotifsReadResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/verify_credentials": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Verify username/password credentials */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserLoginRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/user/set_flair": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Set your flair for a community */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["UserSetFlairRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["UserSetFlairResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** List comments, with various filters. */
        get: {
            parameters: {
                query?: {
                    limit?: number;
                    page?: number;
                    sort?: "Hot" | "Top" | "New" | "Old";
                    liked_only?: boolean;
                    saved_only?: boolean;
                    person_id?: number;
                    community_id?: number;
                    post_id?: number;
                    parent_id?: number;
                    max_depth?: number;
                    /** @description guarantee parent comments are on the same page as any fetched comments */
                    depth_first?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListCommentsResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/like": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Like / vote on a comment. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["LikeCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/save": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Save a comment. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["SaveCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/subscribe": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Subscribe to a comment. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["SubscribeCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get / fetch a comment. */
        get: {
            parameters: {
                query: {
                    id: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Edit a comment. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["EditCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Create a comment. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CreateCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/delete": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Delete a comment. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["DeleteCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/report": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Report a comment. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["ReportCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentReportResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/remove": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Remove a comment as a moderator. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["RemoveCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/mark_as_read": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Mark a comment reply as read. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["MarkCommentAsReadRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentReplyResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/lock": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Lock a comment chain as a moderator. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["LockCommentRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetCommentResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/comment/like/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** View comment votes as a moderator. */
        get: {
            parameters: {
                query: {
                    comment_id: number;
                    page?: number;
                    limit?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListCommentLikesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** List posts. */
        get: {
            parameters: {
                query?: {
                    q?: string;
                    sort?: "Hot" | "Top" | "TopHour" | "TopSixHour" | "TopTwelveHour" | "TopWeek" | "TopDay" | "TopMonth" | "TopThreeMonths" | "TopSixMonths" | "TopNineMonths" | "TopYear" | "TopAll" | "New" | "Scaled" | "Active";
                    type_?: "All" | "Local" | "Subscribed" | "Popular" | "Moderating" | "ModeratorView";
                    community_name?: string;
                    community_id?: number;
                    saved_only?: boolean;
                    person_id?: number;
                    limit?: number;
                    page?: number;
                    page_cursor?: number;
                    liked_only?: boolean;
                    feed_id?: number;
                    topic_id?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListPostsResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get/fetch a post */
        get: {
            parameters: {
                query: {
                    id: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Edit a post. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["EditPostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Create a new post. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CreatePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/replies": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get replies/comments for a post with nested structure. */
        get: {
            parameters: {
                query?: {
                    post_id?: number;
                    parent_id?: number;
                    sort?: "Hot" | "Top" | "New" | "Old";
                    max_depth?: number;
                    page?: string;
                    limit?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostRepliesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/like": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Like or unlike a post. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["LikePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/save": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Save or unsave a post. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["SavePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/subscribe": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Subscribe or unsubscribe to a post. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["SubscribePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/delete": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Delete or restore a post. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["DeletePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/report": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Report a post. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["ReportPostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PostReportResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/lock": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Lock or unlock a post. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["LockPostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/feature": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Feature or unfeature a post. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["FeaturePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/remove": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Remove or restore a post as a moderator. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["RemovePostRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPostResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/mark_as_read": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Mark one or more posts as read or unread. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["MarkPostAsReadRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["SuccessResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/like/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** View post votes as a moderator. */
        get: {
            parameters: {
                query: {
                    post_id: number;
                    page?: number;
                    limit?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListPostLikesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/post/assign_flair": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Add/remove flair from a post */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["PostSetFlairRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PostSetFlairResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/upload/image": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Upload a general image. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "multipart/form-data": components["schemas"]["ImageUploadRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ImageUploadResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/upload/community_image": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Upload a community image. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "multipart/form-data": components["schemas"]["ImageUploadRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ImageUploadResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/upload/user_image": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Upload a user image. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "multipart/form-data": components["schemas"]["ImageUploadRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ImageUploadResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/private_message/list": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** List private messages. */
        get: {
            parameters: {
                query?: {
                    page?: number;
                    limit?: number;
                    unread_only?: boolean;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListPrivateMessagesResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/private_message/conversation": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Get conversation with a specific person. */
        get: {
            parameters: {
                query: {
                    person_id: number;
                    page?: number;
                    limit?: number;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["GetPrivateMessageConversationResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/private_message": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /** Edit a private message. */
        put: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["EditPrivateMessageRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PrivateMessageResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        /** Create a new private message. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["CreatePrivateMessageRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PrivateMessageResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
                /** @description Too Many Requests */
                429: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/private_message/mark_as_read": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Mark a private message as read or unread. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["MarkPrivateMessageAsReadRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PrivateMessageResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/private_message/delete": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Delete or restore a private message. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["DeletePrivateMessageRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PrivateMessageResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/api/alpha/private_message/report": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Report a private message. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["ReportPrivateMessageRequest"];
                };
            };
            responses: {
                /** @description OK */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["PrivateMessageResponse"];
                    };
                };
                /** @description Bad Request */
                400: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["DefaultError"];
                    };
                };
                422: components["responses"]["UNPROCESSABLE_CONTENT"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
}
interface components {
    schemas: {
        Error: {
            /** @description Error code */
            code?: number;
            /** @description Error name */
            status?: string;
            /** @description Error message */
            message?: string;
            /** @description Errors */
            errors?: {
                [key: string]: unknown;
            };
        };
        PaginationMetadata: {
            total?: number;
            total_pages?: number;
            first_page?: number;
            last_page?: number;
            page?: number;
            previous_page?: number;
            next_page?: number;
        };
        DefaultError: {
            message?: string;
        };
        PersonAggregates: {
            comment_count: number;
            person_id: number;
            post_count: number;
        };
        Person: {
            /** @example https://piefed.social/u/rimu */
            actor_id: string;
            banned: boolean;
            bot: boolean;
            deleted: boolean;
            id: number;
            instance_id: number;
            local: boolean;
            user_name: string;
            /** Format: markdown */
            about?: string;
            /** Format: html */
            about_html?: string;
            /** Format: url */
            avatar?: string | null;
            /** Format: url */
            banner?: string | null;
            flair?: string;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published?: string;
            title?: string | null;
        };
        PersonView: {
            activity_alert: boolean;
            counts: components["schemas"]["PersonAggregates"];
            is_admin: boolean;
            person: components["schemas"]["Person"];
        };
        LanguageView: {
            /** @example en */
            code?: string;
            /** @example 2 */
            id?: number;
            /** @example English */
            name?: string;
        };
        Site: {
            /**
             * Format: url
             * @example https://piefed.social
             */
            actor_id: string;
            name: string;
            all_languages?: components["schemas"]["LanguageView"][];
            description?: string;
            enable_downvotes?: boolean;
            /** Format: url */
            icon?: string | null;
            /** @enum {string} */
            registration_mode?: "Closed" | "RequireApplication" | "Open";
            /** Format: html */
            sidebar?: string;
            /** Format: markdown */
            sidebar_md?: string;
            user_count?: number;
        };
        Community: {
            /**
             * Format: url
             * @example https://piefed.social/c/piefed_meta
             */
            actor_id: string;
            /** @example piefed.social */
            ap_domain?: string;
            deleted: boolean;
            hidden: boolean;
            id: number;
            instance_id: number;
            local: boolean;
            name: string;
            nsfw: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            removed: boolean;
            restricted_to_mods: boolean;
            title: string;
            banned?: boolean;
            /** Format: url */
            banner?: string | null;
            /** Format: markdown */
            description?: string;
            /** Format: url */
            icon?: string | null;
            posting_warning?: string | null;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated?: string;
        };
        CommunityBlockView: {
            community?: components["schemas"]["Community"];
            person?: components["schemas"]["Person"];
        };
        CommunityFollowerView: {
            community: components["schemas"]["Community"];
            follower: components["schemas"]["Person"];
        };
        Instance: {
            /** @example piefed.social */
            domain: string;
            id: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            software?: string;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated?: string;
            version?: string;
        };
        InstanceBlockView: {
            instance: components["schemas"]["Instance"];
            person: components["schemas"]["Person"];
        };
        LocalUser: {
            /** @enum {string} */
            default_comment_sort_type: "Hot" | "Top" | "New" | "Old";
            /** @enum {string} */
            default_listing_type: "All" | "Local" | "Subscribed" | "Popular" | "Moderating" | "ModeratorView";
            /** @enum {string} */
            default_sort_type?: "Active" | "Hot" | "New" | "Top" | "TopHour" | "TopSixHour" | "TopTwelveHour" | "TopDay" | "TopWeek" | "TopMonth" | "TopThreeMonths" | "TopSixMonths" | "TopNineMonths" | "TopYear" | "TopAll" | "Scaled" | "Old";
            show_bot_accounts: boolean;
            show_nsfl: boolean;
            show_nsfw: boolean;
            show_read_posts: boolean;
            show_scores: boolean;
        };
        LocalUserView: {
            counts: components["schemas"]["PersonAggregates"];
            local_user: components["schemas"]["LocalUser"];
            person: components["schemas"]["Person"];
        };
        CommunityModeratorView: {
            community: components["schemas"]["Community"];
            moderator: components["schemas"]["Person"];
        };
        PersonBlockView: {
            person: components["schemas"]["Person"];
            target: components["schemas"]["Person"];
        };
        MyUserInfo: {
            community_blocks: components["schemas"]["CommunityBlockView"][];
            discussion_languages: components["schemas"]["LanguageView"][];
            follows: components["schemas"]["CommunityFollowerView"][];
            instance_blocks: components["schemas"]["InstanceBlockView"][];
            local_user_view: components["schemas"]["LocalUserView"];
            moderates: components["schemas"]["CommunityModeratorView"][];
            person_blocks: components["schemas"]["PersonBlockView"][];
        };
        GetSiteResponse: {
            admins: components["schemas"]["PersonView"][];
            site: components["schemas"]["Site"];
            /** Software version */
            version: string;
            my_user?: components["schemas"]["MyUserInfo"];
        };
        GetSiteVersionResponse: {
            version: string;
        };
        BlockInstanceRequest: {
            block: boolean;
            instance_id: number;
        };
        BlockInstanceResponse: {
            blocked: boolean;
        };
        GetSiteInstanceChooserResponse: {
            language: components["schemas"]["LanguageView"];
            nsfw: boolean;
            newbie_friendly: boolean;
            name: string;
            elevator_pitch: string;
            description: string;
            about: string;
            sidebar: string;
            logo_url: string;
            maturity: string;
            tos_url: string;
            mau: number;
            can_make_communities: boolean;
            defederation: string[];
            trusts: string[];
            registration_mode: string;
        };
        GetSiteInstanceChooserSearchResponseItem: {
            id: number;
            name: string;
            domain: string;
            elevator_pitch: string;
            description: string;
            about: string;
            sidebar: string;
            logo_url: string;
            maturity: string;
            tos_url: string;
            uptime: string;
            mau: number;
            can_make_communities: boolean;
            newbie_friendly: boolean;
            defederation: string[];
            trusts: string[];
            registration_mode: string;
            language: string;
            monthsmonitored: number;
        };
        GetSiteInstanceChooserSearchResponse: {
            result: components["schemas"]["GetSiteInstanceChooserSearchResponseItem"][];
        };
        CommunityAggregates: {
            id: number;
            post_count: number;
            post_reply_count: number;
            published: string;
            subscriptions_count: number;
            total_subscriptions_count: number;
            active_daily?: number;
            active_weekly?: number;
            active_monthly?: number;
            active_6monthly?: number;
        };
        CommunityFlair: {
            id: number;
            community_id: number;
            flair_title: string;
            /**
             * @description Hex color code for the text of the flair
             * @example #000000
             */
            text_color: string;
            /**
             * @description Hex color code for the background of the flair
             * @example #DEDDDA
             */
            background_color: string;
            blur_images: boolean;
            /**
             * Format: url
             * @description Legacy tags that existed prior to 1.2 and some tags for remote communities might not have a defined ap_id
             */
            ap_id: string | null;
        };
        CommunityView: {
            activity_alert: boolean;
            blocked: boolean;
            community: components["schemas"]["Community"];
            counts: components["schemas"]["CommunityAggregates"];
            /** @enum {string} */
            subscribed: "Subscribed" | "NotSubscribed" | "Pending";
            flair_list?: components["schemas"]["CommunityFlair"][];
        };
        PostAggregates: {
            comments: number;
            downvotes: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            newest_comment_time: string;
            post_id: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            score: number;
            upvotes: number;
            cross_posts: number;
        };
        WidthHeight: {
            width?: number;
            height?: number;
        };
        MiniCrossPosts: {
            post_id?: number;
            reply_count?: number;
            community_name?: string;
        };
        Post: {
            /** Format: url */
            ap_id: string;
            community_id: number;
            deleted: boolean;
            id: number;
            language_id: number;
            local: boolean;
            locked: boolean;
            nsfw: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            removed: boolean;
            sticky: boolean;
            title: string;
            user_id: number;
            alt_text?: string;
            /** Format: markdown */
            body?: string;
            /** Format: url */
            small_thumbnail_url?: string;
            /** Format: url */
            thumbnail_url?: string;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated?: string;
            /** Format: url */
            url?: string;
            image_details?: components["schemas"]["WidthHeight"];
            cross_posts?: components["schemas"]["MiniCrossPosts"][];
        };
        PostView: {
            banned_from_community: boolean;
            community: components["schemas"]["Community"];
            counts: components["schemas"]["PostAggregates"];
            creator: components["schemas"]["Person"];
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: components["schemas"]["Post"];
            read: boolean;
            saved: boolean;
            /** @enum {string} */
            subscribed: "Subscribed" | "NotSubscribed" | "Pending";
            unread_comments: number;
            activity_alert?: boolean;
            my_vote?: number;
            flair_list?: components["schemas"]["CommunityFlair"][];
        };
        Comment: {
            /** Format: url */
            ap_id: string;
            /** Format: markdown */
            body: string;
            deleted: boolean;
            id: number;
            language_id: number;
            local: boolean;
            path: string;
            post_id: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            removed: boolean;
            user_id: number;
            distinguished?: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated?: string;
            locked?: boolean;
        };
        CommentAggregates: {
            child_count: number;
            comment_id: number;
            downvotes: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            score: number;
            upvotes: number;
        };
        CommentView: {
            activity_alert: boolean;
            banned_from_community: boolean;
            comment: components["schemas"]["Comment"];
            community: components["schemas"]["Community"];
            counts: components["schemas"]["CommentAggregates"];
            creator: components["schemas"]["Person"];
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: components["schemas"]["Post"];
            saved: boolean;
            subscribed: string;
            my_vote?: number;
            can_auth_user_moderate?: boolean;
        };
        SearchResponse: {
            /** @enum {string} */
            type_: "Communities" | "Posts" | "Users" | "Url";
            communities: components["schemas"]["CommunityView"][];
            posts: components["schemas"]["PostView"][];
            users: components["schemas"]["PersonView"][];
            comments: components["schemas"]["CommentView"][];
        };
        ResolveObjectResponse: {
            comment?: components["schemas"]["CommentView"];
            post?: components["schemas"]["PostView"];
            community?: components["schemas"]["CommunityView"];
            person?: components["schemas"]["PersonView"];
        };
        InstanceWithoutFederationState: {
            domain: string;
            id: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            software?: string;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated?: string;
            version?: string;
        };
        FederatedInstancesView: {
            allowed: components["schemas"]["InstanceWithoutFederationState"][];
            blocked: components["schemas"]["InstanceWithoutFederationState"][];
            linked: components["schemas"]["InstanceWithoutFederationState"][];
        };
        GetFederatedInstancesResponse: {
            federated_instances?: components["schemas"]["FederatedInstancesView"];
        };
        GetCommunityResponse: {
            community_view: components["schemas"]["CommunityView"];
            discussion_languages: number[];
            moderators: components["schemas"]["CommunityModeratorView"][];
            site?: components["schemas"]["Site"];
        };
        ListCommunitiesResponse: {
            communities: components["schemas"]["CommunityView"][];
            next_page?: string | null;
        };
        FollowCommunityRequest: {
            community_id: number;
            follow: boolean;
        };
        CommunityResponse: {
            community_view: components["schemas"]["CommunityView"];
            discussion_languages: number[];
        };
        BlockCommunityRequest: {
            block: boolean;
            community_id: number;
        };
        BlockCommunityResponse: {
            community_view: components["schemas"]["CommunityView"];
            blocked: boolean;
        };
        CreateCommunityRequest: {
            name: string;
            title: string;
            /** Format: url */
            banner_url?: string | null;
            /** Format: markdown */
            description?: string;
            discussion_languages?: number[];
            /** Format: url */
            icon_url?: string | null;
            local_only?: boolean;
            nsfw?: boolean;
            restricted_to_mods?: boolean;
            rules?: string;
        };
        EditCommunityRequest: {
            community_id: number;
            title: string;
            /** Format: url */
            banner_url?: string | null;
            /** Format: markdown */
            description?: string;
            discussion_languages?: number[];
            /** Format: url */
            icon_url?: string | null;
            local_only?: boolean;
            nsfw?: boolean;
            restricted_to_mods?: boolean;
            rules?: string;
        };
        SubscribeCommunityRequest: {
            community_id: number;
            subscribe: boolean;
        };
        DeleteCommunityRequest: {
            community_id: number;
            deleted: boolean;
        };
        ModCommunityRequest: {
            added: boolean;
            community_id: number;
            person_id: number;
        };
        ModCommunityResponse: {
            moderators: components["schemas"]["CommunityModeratorView"][];
        };
        CommunityModerationBanItem: {
            banned_by?: components["schemas"]["Person"];
            banned_user?: components["schemas"]["Person"];
            community?: components["schemas"]["Community"];
            expired?: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z, null=permanent ban
             */
            expired_at?: string | null;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z, null=permanent ban
             */
            expires_at?: string | null;
            reason?: string;
        };
        CommunityModerationBansListResponse: {
            items?: components["schemas"]["CommunityModerationBanItem"][];
            next_page?: string | null;
        };
        CommunityModerationUnbanRequest: {
            community_id: number;
            user_id: number;
        };
        CommunityModerationBanRequest: {
            community_id: number;
            reason: string;
            user_id: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            expires_at?: string;
            permanent?: boolean;
        };
        CommunityModerationNsfwRequest: {
            post_id: number;
            nsfw_status: boolean;
        };
        CommunityFlairCreateRequest: {
            community_id: number;
            flair_title: string;
            /**
             * @description Hex color code for the text of the flair.
             * @default #000000
             * @example #000 or #000000
             */
            text_color: string;
            /**
             * @description Hex color code for the background of the flair.
             * @default #DEDDDA
             * @example #fff or #FFFFFF
             */
            background_color: string;
            /** @default false */
            blur_images: boolean;
        };
        CommunityFlairCreateResponse: {
            id: number;
            community_id: number;
            flair_title: string;
            /**
             * @description Hex color code for the text of the flair
             * @example #000000
             */
            text_color: string;
            /**
             * @description Hex color code for the background of the flair
             * @example #DEDDDA
             */
            background_color: string;
            blur_images: boolean;
            /**
             * Format: url
             * @description Legacy tags that existed prior to 1.2 and some tags for remote communities might not have a defined ap_id
             */
            ap_id: string | null;
        };
        CommunityFlairEditRequest: {
            flair_id: number;
            flair_title?: string;
            /**
             * @description Hex color code for the text of the flair.
             * @example #000 or #000000
             */
            text_color?: string;
            /**
             * @description Hex color code for the background of the flair.
             * @example #fff or #FFFFFF
             */
            background_color?: string;
            blur_images?: boolean;
        };
        CommunityFlairEditResponse: {
            id: number;
            community_id: number;
            flair_title: string;
            /**
             * @description Hex color code for the text of the flair
             * @example #000000
             */
            text_color: string;
            /**
             * @description Hex color code for the background of the flair
             * @example #DEDDDA
             */
            background_color: string;
            blur_images: boolean;
            /**
             * Format: url
             * @description Legacy tags that existed prior to 1.2 and some tags for remote communities might not have a defined ap_id
             */
            ap_id: string | null;
        };
        CommunityFlairDeleteRequest: {
            flair_id: number;
        };
        CommunityFlairDeleteResponse: {
            community_view: components["schemas"]["CommunityView"];
            discussion_languages: number[];
            moderators: components["schemas"]["CommunityModeratorView"][];
            site?: components["schemas"]["Site"];
        };
        FeedView: {
            /** Format: url */
            actor_id: string;
            ap_domain: string;
            children: components["schemas"]["FeedView"][];
            communities: components["schemas"]["Community"][];
            communities_count: number;
            id: number;
            is_instance_feed: boolean;
            local: boolean;
            name: string;
            nsfl: boolean;
            nsfw: boolean;
            /** @description Is the authorized user the creator of the feed? */
            owner: boolean;
            public: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            show_posts_from_children: boolean;
            subscribed: boolean;
            subscriptions_count: number;
            title: string;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated: string;
            /** @description user_id of the feed creator/owner */
            user_id: number;
            /** Format: url */
            banner?: string | null;
            /** Format: markdown */
            description?: string | null;
            /** Format: html */
            description_html?: string | null;
            /** Format: url */
            icon?: string | null;
            parent_feed_id?: number | null;
        };
        FeedListResponse: {
            feeds: components["schemas"]["FeedView"][];
        };
        TopicView: {
            children: components["schemas"]["TopicView"][];
            communities: components["schemas"]["Community"][];
            communities_count: number;
            id: number;
            name: string;
            show_posts_from_children: boolean;
            title: string;
            parent_topic_id?: number | null;
        };
        TopicListResponse: {
            topics: components["schemas"]["TopicView"][];
        };
        GetUserResponse: {
            comments: components["schemas"]["CommentView"][];
            moderates: components["schemas"]["CommunityModeratorView"][];
            person_view: components["schemas"]["PersonView"];
            posts: components["schemas"]["PostView"][];
            site?: components["schemas"]["Site"];
        };
        UserLoginRequest: {
            username: string;
            password: string;
        };
        UserLoginResponse: {
            jwt: string;
        };
        UserUnreadCountsResponse: {
            /** @description Post and comment mentions */
            mentions: number;
            private_messages: number;
            /** @description Replies to posts and comments */
            replies: number;
            /** @description Any other type of notification (reports, activity alerts, etc.) */
            other: number;
        };
        CommentReply: {
            id: number;
            comment_id: number;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            read: boolean;
            recipient_id: number;
        };
        CommentReplyView: {
            activity_alert: boolean;
            comment: components["schemas"]["Comment"];
            comment_reply: components["schemas"]["CommentReply"];
            community: components["schemas"]["Community"];
            counts: components["schemas"]["CommentAggregates"];
            creator: components["schemas"]["Person"];
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            my_vote: number;
            post: components["schemas"]["Post"];
            recipient: components["schemas"]["Person"];
            saved: boolean;
            /** @enum {string} */
            subscribed: "Subscribed" | "NotSubscribed" | "Pending";
        };
        UserRepliesResponse: {
            next_page?: string | null;
            replies: components["schemas"]["CommentReplyView"][];
        };
        UserMentionsResponse: {
            next_page?: string | null;
            replies: components["schemas"]["CommentReplyView"][];
        };
        UserBlockRequest: {
            block: boolean;
            person_id: number;
        };
        UserBlockResponse: {
            blocked: boolean;
            person_view: components["schemas"]["PersonView"];
        };
        UserMarkAllReadResponse: {
            /** @description Should be empty list */
            replies: components["schemas"]["CommentReplyView"][];
        };
        UserSubscribeRequest: {
            person_id: number;
            subscribe: boolean;
        };
        UserSubscribeResponse: {
            person_view: components["schemas"]["PersonView"];
            subscribed: boolean;
        };
        UserSaveSettingsRequest: {
            /**
             * Format: url
             * @description Pass a null value to remove the image
             */
            avatar?: string | null;
            /** Format: markdown */
            bio?: string;
            /**
             * Format: url
             * @description Pass a null value to remove the image
             */
            cover?: string | null;
            /** @enum {string} */
            default_comment_sort_type?: "Hot" | "Top" | "New" | "Old";
            /** @enum {string} */
            default_sort_type?: "Hot" | "Top" | "New" | "Active" | "Old" | "Scaled";
            show_nsfw?: boolean;
            show_nsfl?: boolean;
            show_read_posts?: boolean;
        };
        UserSaveSettingsResponse: {
            my_user?: components["schemas"]["MyUserInfo"];
        };
        UserNotificationsCounts: {
            unread: number;
            read: number;
            total: number;
        };
        UserNotificationItemView: {
            /** @description returned for all notif types */
            author: components["schemas"]["Person"];
            /** @description returned for all notif types */
            notif_body: string;
            /** @description returned for all notif types */
            notif_id: number;
            /** @description returned for all notif types */
            notif_subtype: string;
            /** @description returned for all notif types */
            notif_type: number;
            /**
             * @description returned for all notif types
             * @enum {string}
             */
            status: "Unread" | "Read";
            /** @description returned for notif_types: 3, 4, 6 (comment_mention subtype) */
            comment?: components["schemas"]["Comment"];
            /** @description returned for notif_types: 3, 4, 6 (comment_mention subtype) */
            comment_id?: number;
            /** @description returned for notif_type 1 */
            community?: components["schemas"]["Community"];
            /** @description returned for notif_types: 0, 1, 2, 3, 4, 5, 6 (post_mention subtype) */
            post?: components["schemas"]["PostView"];
            /** @description returned for notif_types: 0, 1, 2, 3, 4, 5, 6 (post_mention subtype) */
            post_id?: number;
        };
        UserNotificationsResponse: {
            counts: components["schemas"]["UserNotificationsCounts"];
            items: components["schemas"]["UserNotificationItemView"][];
            /** @enum {string} */
            status: "All" | "Unread" | "Read";
            username: string;
            next_page?: string | null;
        };
        UserNotificationStateRequest: {
            notif_id: number;
            /** @description true sets notification as read, false marks it unread */
            read_state: boolean;
        };
        UserNotificationsCountResponse: {
            count: number;
        };
        UserMarkAllNotifsReadResponse: {
            /** @example complete */
            mark_all_notifications_as_read: string;
        };
        UserSetFlairRequest: {
            community_id: number;
            /** @description Either omit or set to null to remove existing flair */
            flair_text?: string | null;
        };
        UserSetFlairResponse: {
            person_view?: components["schemas"]["PersonView"];
        };
        ListCommentsResponse: {
            comments: components["schemas"]["CommentView"][];
            next_page?: string | null;
        };
        LikeCommentRequest: {
            comment_id: number;
            /**
             * @description -1 to downvote, 1 to upvote, 0 to revert previous vote
             * @example 1
             */
            score: number;
            /**
             * @description private votes are not federated to other instances
             * @default false
             */
            private: boolean;
        };
        GetCommentResponse: {
            comment_view: components["schemas"]["CommentView"];
        };
        SaveCommentRequest: {
            comment_id: number;
            save: boolean;
        };
        SubscribeCommentRequest: {
            comment_id: number;
            subscribe: boolean;
        };
        CreateCommentRequest: {
            body: string;
            post_id: number;
            parent_id?: number;
            language_id?: number;
        };
        EditCommentRequest: {
            body: string;
            comment_id: number;
            language_id?: number;
            /**
             * @description Visibly mark reply as from a moderator in the web UI
             * @default false
             */
            distinguished: boolean;
        };
        DeleteCommentRequest: {
            comment_id: number;
            deleted: boolean;
        };
        ReportCommentRequest: {
            comment_id: number;
            reason: string;
            description?: string;
            /**
             * @description Also send report to originating instance
             * @default true
             */
            report_remote: boolean;
        };
        CommentReport: {
            id: number;
            creator_id: number;
            comment_id: number;
            original_comment_text?: string;
            reason?: string;
            resolved: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            updated?: string;
        };
        CommentReportView: {
            activity_alert: boolean;
            banned_from_community: boolean;
            comment: components["schemas"]["Comment"];
            community: components["schemas"]["Community"];
            counts: components["schemas"]["CommentAggregates"];
            creator: components["schemas"]["Person"];
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: components["schemas"]["Post"];
            saved: boolean;
            subscribed: string;
            my_vote?: number;
            can_auth_user_moderate?: boolean;
            comment_report: components["schemas"]["CommentReport"];
            comment_creator: components["schemas"]["Person"];
        };
        GetCommentReportResponse: {
            comment_report_view: components["schemas"]["CommentReportView"];
        };
        RemoveCommentRequest: {
            comment_id: number;
            removed: boolean;
            reason?: string;
        };
        MarkCommentAsReadRequest: {
            comment_reply_id: number;
            read: boolean;
        };
        GetCommentReplyResponse: {
            comment_reply_view: components["schemas"]["CommentReplyView"];
        };
        LockCommentRequest: {
            comment_id: number;
            locked: boolean;
        };
        CommentLikeView: {
            score: number;
            creator_banned_from_community: boolean;
            creator_banned: boolean;
            creator: components["schemas"]["Person"];
        };
        ListCommentLikesResponse: {
            comment_likes: components["schemas"]["CommentLikeView"][];
            next_page?: string | null;
        };
        ListPostsResponse: {
            posts: components["schemas"]["PostView"][];
            next_page?: string | null;
        };
        GetPostResponse: {
            post_view: components["schemas"]["PostView"];
            community_view?: components["schemas"]["CommunityView"];
            moderators?: components["schemas"]["CommunityModeratorView"][];
            cross_posts?: components["schemas"]["PostView"][];
        };
        PostReplyView: {
            activity_alert: boolean;
            banned_from_community: boolean;
            comment: components["schemas"]["Comment"];
            community?: components["schemas"]["Community"];
            counts: components["schemas"]["CommentAggregates"];
            creator: components["schemas"]["Person"];
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post?: components["schemas"]["Post"];
            saved: boolean;
            subscribed: string;
            my_vote?: number;
            can_auth_user_moderate?: boolean;
            replies?: components["schemas"]["PostReplyView"][];
        };
        GetPostRepliesResponse: {
            comments?: components["schemas"]["PostReplyView"][];
            next_page?: string | null;
        };
        LikePostRequest: {
            post_id: number;
            score: number;
            private?: boolean;
            auth?: string;
        };
        SavePostRequest: {
            post_id: number;
            save: boolean;
        };
        SubscribePostRequest: {
            post_id: number;
            subscribe: boolean;
        };
        CreatePostRequest: {
            title: string;
            community_id: number;
            body?: string;
            /** Format: url */
            url?: string;
            nsfw?: boolean;
            language_id?: number;
        };
        EditPostRequest: {
            post_id: number;
            title?: string;
            body?: string;
            /** Format: url */
            url?: string;
            nsfw?: boolean;
            language_id?: number;
        };
        DeletePostRequest: {
            post_id: number;
            deleted: boolean;
        };
        ReportPostRequest: {
            post_id: number;
            reason: string;
        };
        PostReport: {
            id: number;
            creator_id: number;
            post_id: number;
            original_post_name: string;
            original_post_body: string;
            reason: string;
            resolved: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published?: string;
        };
        PostReportView: {
            post_report: components["schemas"]["PostReport"];
            post: components["schemas"]["Post"];
            community: components["schemas"]["Community"];
            creator: components["schemas"]["Person"];
            post_creator: components["schemas"]["Person"];
            counts: components["schemas"]["PostAggregates"];
            creator_banned_from_community: boolean;
            creator_is_moderator: boolean;
            creator_is_admin: boolean;
            creator_blocked: boolean;
            /** @enum {string} */
            subscribed: "Subscribed" | "NotSubscribed" | "Pending";
            saved: boolean;
        };
        PostReportResponse: {
            post_report_view: components["schemas"]["PostReportView"];
        };
        LockPostRequest: {
            post_id: number;
            locked: boolean;
        };
        FeaturePostRequest: {
            post_id: number;
            featured: boolean;
            feature_type: string;
        };
        RemovePostRequest: {
            post_id: number;
            removed: boolean;
            reason?: string;
        };
        MarkPostAsReadRequest: {
            read: boolean;
            post_id?: number;
            post_ids?: number[];
        };
        SuccessResponse: {
            success: boolean;
        };
        PostLikeView: {
            score: number;
            creator_banned_from_community: boolean;
            creator_banned: boolean;
            creator: components["schemas"]["Person"];
        };
        ListPostLikesResponse: {
            post_likes: components["schemas"]["PostLikeView"][];
            next_page?: string | null;
        };
        PostSetFlairRequest: {
            post_id: number;
            /** @description A list of all the flair id to assign to the post. Either pass an empty list or null to remove flair */
            flair_id_list?: number[] | null;
        };
        PostSetFlairResponse: {
            banned_from_community: boolean;
            community: components["schemas"]["Community"];
            counts: components["schemas"]["PostAggregates"];
            creator: components["schemas"]["Person"];
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: components["schemas"]["Post"];
            read: boolean;
            saved: boolean;
            /** @enum {string} */
            subscribed: "Subscribed" | "NotSubscribed" | "Pending";
            unread_comments: number;
            activity_alert?: boolean;
            my_vote?: number;
            flair_list?: components["schemas"]["CommunityFlair"][];
        };
        ImageUploadRequest: {
            /** Format: binary */
            file: string;
        };
        ImageUploadResponse: {
            /** Format: url */
            url: string;
            liked_only?: boolean;
            saved_only?: boolean;
            q?: string;
        };
        PrivateMessage: {
            id: number;
            creator_id: number;
            recipient_id: number;
            content: string;
            deleted: boolean;
            read: boolean;
            /**
             * Format: datetime
             * @example 2025-06-07T02:29:07.980084Z
             */
            published: string;
            /** Format: url */
            ap_id: string;
            local: boolean;
        };
        PrivateMessageView: {
            private_message: components["schemas"]["PrivateMessage"];
            creator: components["schemas"]["Person"];
            recipient: components["schemas"]["Person"];
        };
        ListPrivateMessagesResponse: {
            private_messages: components["schemas"]["PrivateMessageView"][];
        };
        GetPrivateMessageConversationResponse: {
            private_messages: components["schemas"]["PrivateMessageView"][];
        };
        CreatePrivateMessageRequest: {
            content: string;
            recipient_id: number;
        };
        PrivateMessageResponse: {
            private_message_view: components["schemas"]["PrivateMessageView"];
        };
        EditPrivateMessageRequest: {
            private_message_id: number;
            content: string;
        };
        MarkPrivateMessageAsReadRequest: {
            private_message_id: number;
            read: boolean;
        };
        DeletePrivateMessageRequest: {
            private_message_id: number;
            deleted: boolean;
        };
        ReportPrivateMessageRequest: {
            private_message_id: number;
            reason: string;
        };
    };
    responses: {
        /** @description Unprocessable Content */
        UNPROCESSABLE_CONTENT: {
            headers: {
                [name: string]: unknown;
            };
            content: {
                "application/json": components["schemas"]["Error"];
            };
        };
    };
    parameters: never;
    requestBodies: never;
    headers: never;
    pathItems: never;
}

type CommentSortType = CommentSortTypeByMode[keyof CommentSortTypeByMode] | {
    mode?: never;
    sort?: CommentSortTypeByMode["lemmyv0"]["sort"] & CommentSortTypeByMode["lemmyv1"]["sort"] & CommentSortTypeByMode["piefed"]["sort"];
};
type CommentSortTypeByMode = {
    lemmyv0: Required<Pick<GetComments$1, "sort">> & {
        mode: "lemmyv0";
    };
    lemmyv1: Pick<GetComments$2, "time_range_seconds"> & Required<Pick<GetComments$2, "sort">> & {
        mode: "lemmyv1";
    };
    piefed: Pick<Required<NonNullable<paths["/api/alpha/comment/list"]["get"]["parameters"]["query"]>>, "sort"> & {
        mode: "piefed";
    };
};

type CommunitySortType = CommunitySortTypeByMode[keyof CommunitySortTypeByMode] | {
    mode?: never;
    sort?: CommunitySortTypeByMode["lemmyv0"]["sort"] & CommunitySortTypeByMode["lemmyv1"]["sort"] & CommunitySortTypeByMode["piefed"]["sort"];
};
type CommunitySortTypeByMode = {
    lemmyv0: Required<Pick<ListCommunities$1, "sort">> & {
        mode: "lemmyv0";
    };
    lemmyv1: Pick<ListCommunities$2, "time_range_seconds"> & Required<Pick<ListCommunities$2, "sort">> & {
        mode: "lemmyv1";
    };
    piefed: Pick<Required<NonNullable<paths["/api/alpha/community/list"]["get"]["parameters"]["query"]>>, "sort"> & {
        mode: "piefed";
    };
};

interface CreateComment {
    content: string;
    language_id?: number;
    parent_id?: number;
    post_id: number;
}

interface CreatePost {
    /**
     * An optional alt_text, usable for image posts.
     */
    alt_text?: string;
    /**
     * An optional body for the post in markdown.
     */
    body?: string;
    community_id: number;
    /**
     * Instead of fetching a thumbnail, use a custom one.
     */
    custom_thumbnail?: string;
    language_id?: number;
    name: string;
    nsfw?: boolean;
    url?: string;
}

interface EditComment {
    comment_id: number;
    content: string;
    language_id?: number;
}

interface EditPost {
    /**
     * An optional alt_text, usable for image posts.
     */
    alt_text?: string;
    /**
     * An optional body for the post in markdown.
     */
    body?: string;
    /**
     * Instead of fetching a thumbnail, use a custom one.
     */
    custom_thumbnail?: string;
    language_id?: number;
    name?: string;
    nsfw?: boolean;
    post_id: number;
    url?: string;
}

type GetComments = CommentSortType & PageParams & {
    community_id?: number;
    community_name?: string;
    max_depth?: number;
    parent_id?: number;
    post_id?: number;
    type_?: ListingType;
};

interface GetCommunity {
    id?: number;
    /**
     * Example: star_trek , or star_trek@xyz.tld
     */
    name?: string;
}

type PageParams = {
    limit?: number;
    page_cursor?: PageCursor$1;
};
type PageCursor$1 = number | string;

/**
 * Fetches the modlog.
 */
type GetModlog = PageParams & {
    comment_id?: number;
    community_id?: number;
    mod_person_id?: number;
    other_person_id?: number;
    post_id?: number;
};
/**
 * A list of possible types for the various modlog actions.
 */
type ModlogActionType = "AdminPurgeComment" | "AdminPurgeCommunity" | "AdminPurgePerson" | "AdminPurgePost" | "All" | "ModAdd" | "ModAddCommunity" | "ModBan" | "ModBanFromCommunity" | "ModFeaturePost" | "ModHideCommunity" | "ModLockPost" | "ModRemoveComment" | "ModRemoveCommunity" | "ModRemovePost" | "ModTransferCommunity";

/**
 * Get mentions for your user.
 */
type GetPersonMentions = PageParams & {
    unread_only?: boolean;
};

interface GetPost {
    comment_id?: number;
    id: number;
}

type PostSortType = PostSortTypeByMode[keyof PostSortTypeByMode] | {
    mode?: never;
    sort?: PostSortTypeByMode["lemmyv0"]["sort"] & PostSortTypeByMode["lemmyv1"]["sort"] & PostSortTypeByMode["piefed"]["sort"];
};
type PostSortTypeByMode = {
    lemmyv0: Required<Pick<GetPosts$1, "sort">> & {
        mode: "lemmyv0";
    };
    lemmyv1: Pick<GetPosts$2, "time_range_seconds"> & Required<Pick<GetPosts$2, "sort">> & {
        mode: "lemmyv1";
    };
    piefed: Pick<Required<NonNullable<paths["/api/alpha/post/list"]["get"]["parameters"]["query"]>>, "sort"> & {
        mode: "piefed";
    };
};

type GetPosts = PageParams & PostSortType & {
    community_id?: number;
    community_name?: string;
    show_hidden?: boolean;
    /**
     * If true, then show the nsfw posts (even if your user setting is to hide them)
     */
    show_nsfw?: boolean;
    /**
     * If true, then show the read posts (even if your user setting is to hide them)
     */
    show_read?: boolean;
    type_?: ListingType;
};

/**
 * Get your private messages.
 */
type GetPrivateMessages = PageParams & {
    creator_id?: number;
    unread_only?: boolean;
};

/**
 * Get comment replies.
 */
type GetReplies = PageParams & {
    unread_only?: boolean;
};

type LikeType = "Downvoted" | "Upvoted";

/**
 * Fetches a list of communities.
 */
type ListCommunities = CommunitySortType & PageParams & {
    show_nsfw?: boolean;
    type_?: ListingType;
};

/**
 * Gets a person's content (posts and comments)
 *
 * Either person_id, or username are required.
 */
type ListPersonContent = PageParams & {
    page_back?: boolean;
    person_id?: number;
    type?: "All" | "Comments" | "Posts";
};

/**
 * List comment reports.
 */
type ListReports = PageParams & {
    /**
     * if no community is given, it returns reports for all communities moderated by the auth user
     */
    community_id?: number;
    /**
     * Only shows the unresolved reports
     */
    unresolved_only?: boolean;
};

/**
 * Register / Sign up to lemmy.
 */
type Register = {
    /**
     * An answer is mandatory if require application is enabled on the server
     */
    answer?: string;
    /**
     * Your captcha answer.
     */
    captcha_answer?: string;
    /**
     * The UUID of the captcha item.
     */
    captcha_uuid?: string;
    /**
     * email is mandatory if email verification is enabled on the server
     */
    email?: string;
    password: string;
    password_verify: string;
    show_nsfw?: boolean;
    username: string;
};

/**
 * Searches the site, given a query string, and some optional filters.
 */
type Search = PageParams & SearchSortType & {
    community_id?: number;
    community_name?: string;
    creator_id?: number;
    listing_type?: ListingType;
    post_url_only?: boolean;
    q: string;
    title_only?: boolean;
    type_?: SearchType;
};

type SearchSortType = SearchSortTypeByMode[keyof SearchSortTypeByMode] | {
    mode?: never;
    sort?: SearchSortTypeByMode["lemmyv0"]["sort"] & SearchSortTypeByMode["lemmyv1"]["sort"] & SearchSortTypeByMode["piefed"]["sort"];
};
type SearchSortTypeByMode = {
    lemmyv0: Required<Pick<Search$1, "sort">> & {
        mode: "lemmyv0";
    };
    lemmyv1: Pick<Search$2, "time_range_seconds"> & Required<Pick<Search$2, "sort">> & {
        mode: "lemmyv1";
    };
    piefed: Pick<Required<NonNullable<paths["/api/alpha/search"]["get"]["parameters"]["query"]>>, "sort"> & {
        mode: "piefed";
    };
};

/**
 * The type of content returned from a search.
 */
type SearchType = "All" | "Comments" | "Communities" | "Posts" | "Users";

type AdminPurgeComment = z.infer<typeof AdminPurgeComment$1>;
type AdminPurgeCommentView = z.infer<typeof AdminPurgeCommentView$1>;
type AdminPurgeCommunity = z.infer<typeof AdminPurgeCommunity$1>;
type AdminPurgeCommunityView = z.infer<typeof AdminPurgeCommunityView$1>;
type AdminPurgePerson = z.infer<typeof AdminPurgePerson$1>;
type AdminPurgePersonView = z.infer<typeof AdminPurgePersonView$1>;
type AdminPurgePost = z.infer<typeof AdminPurgePost$1>;
type AdminPurgePostView = z.infer<typeof AdminPurgePostView$1>;
type Comment = z.infer<typeof Comment$1>;
type CommentAggregates = z.infer<typeof CommentAggregates$1>;
type CommentReply = z.infer<typeof CommentReply$1>;
type CommentReplyView = z.infer<typeof CommentReplyView$1>;
type CommentReport = z.infer<typeof CommentReport$1>;
type CommentReportView = z.infer<typeof CommentReportView$1>;
type CommentView = z.infer<typeof CommentView$1>;
type Community = z.infer<typeof Community$1>;
type CommunityAggregates = z.infer<typeof CommunityAggregates$1>;
type CommunityFollowerView = z.infer<typeof CommunityFollowerView$1>;
type CommunityModeratorView = z.infer<typeof CommunityModeratorView$1>;
type CommunityView = z.infer<typeof CommunityView$1>;
type CommunityVisibility = z.infer<typeof CommunityVisibility$1>;
type FederatedInstances = z.infer<typeof FederatedInstances$1>;
type GetCaptchaResponse = z.infer<typeof GetCaptchaResponse$1>;
type GetCommunityResponse = z.infer<typeof GetCommunityResponse$1>;
type GetPersonDetailsResponse = z.infer<typeof GetPersonDetailsResponse$1>;
type GetSiteMetadataResponse = z.infer<typeof GetSiteMetadataResponse$1>;
type GetSiteResponse = z.infer<typeof GetSiteResponse$1>;
type GetUnreadCountResponse = z.infer<typeof GetUnreadCountResponse$1>;
type Instance = z.infer<typeof Instance$1>;
type InstanceWithFederationState = z.infer<typeof InstanceWithFederationState$1>;
type LinkMetadata = z.infer<typeof LinkMetadata$1>;
type ListCommentReportsResponse = z.infer<typeof ListCommentReportsResponse$1>;
type ListCommentsResponse = z.infer<typeof ListCommentsResponse$1>;
type ListCommunitiesResponse = z.infer<typeof ListCommunitiesResponse$1>;
type ListingType = z.infer<typeof ListingType$1>;
type ListModlogResponse = z.infer<typeof ListModlogResponse$1>;
type ListNotificationsResponse = z.infer<typeof ListNotificationsResponse$1>;
type ListPersonContentResponse = z.infer<typeof ListPersonContentResponse$1>;
type ListPersonLikedResponse = z.infer<typeof ListPersonLikedResponse$1>;
type ListPersonMentionsResponse = z.infer<typeof ListPersonMentionsResponse$1>;
type ListPostReportsResponse = z.infer<typeof ListPostReportsResponse$1>;
type ListPostsResponse = z.infer<typeof ListPostsResponse$1>;
type ListPrivateMessagesResponse = z.infer<typeof ListPrivateMessagesResponse$1>;
type ListRepliesResponse = z.infer<typeof ListRepliesResponse$1>;
type ListReportsResponse = z.infer<typeof ListReportsResponse$1>;
type ListSearchResponse = z.infer<typeof ListSearchResponse$1>;
type LocalSite = z.infer<typeof LocalSite$1>;
type LoginResponse = z.infer<typeof LoginResponse$1>;
type ModAdd = z.infer<typeof ModAdd$1>;
type ModAddCommunity = z.infer<typeof ModAddCommunity$1>;
type ModAddCommunityView = z.infer<typeof ModAddCommunityView$1>;
type ModAddView = z.infer<typeof ModAddView$1>;
type ModBan = z.infer<typeof ModBan$1>;
type ModBanFromCommunity = z.infer<typeof ModBanFromCommunity$1>;
type ModBanFromCommunityView = z.infer<typeof ModBanFromCommunityView$1>;
type ModBanView = z.infer<typeof ModBanView$1>;
type ModFeaturePost = z.infer<typeof ModFeaturePost$1>;
type ModFeaturePostView = z.infer<typeof ModFeaturePostView$1>;
type ModHideCommunity = z.infer<typeof ModHideCommunity$1>;
type ModHideCommunityView = z.infer<typeof ModHideCommunityView$1>;
type ModLockPost = z.infer<typeof ModLockPost$1>;
type ModLockPostView = z.infer<typeof ModLockPostView$1>;
type ModlogItem = z.infer<typeof ModlogItem$1>;
type ModRemoveComment = z.infer<typeof ModRemoveComment$1>;
type ModRemoveCommentView = z.infer<typeof ModRemoveCommentView$1>;
type ModRemoveCommunity = z.infer<typeof ModRemoveCommunity$1>;
type ModRemoveCommunityView = z.infer<typeof ModRemoveCommunityView$1>;
type ModRemovePost = z.infer<typeof ModRemovePost$1>;
type ModRemovePostView = z.infer<typeof ModRemovePostView$1>;
type ModTransferCommunity = z.infer<typeof ModTransferCommunity$1>;
type ModTransferCommunityView = z.infer<typeof ModTransferCommunityView$1>;
type MyUserInfo = z.infer<typeof MyUserInfo$1>;
type Notification = z.infer<typeof Notification$1>;
type PagableResponse = z.infer<typeof PagableResponse$1>;
type PageCursor = z.infer<typeof PageCursor$2>;
type Person = z.infer<typeof Person$1>;
type PersonAggregates = z.infer<typeof PersonAggregates$1>;
type PersonContentItem = z.infer<typeof PersonContentItem$1>;
type PersonMention = z.infer<typeof PersonMention$1>;
type PersonMentionView = z.infer<typeof PersonMentionView$1>;
type PersonView = z.infer<typeof PersonView$1>;
type Post = z.infer<typeof Post$1>;
type PostAggregates = z.infer<typeof PostAggregates$1>;
type PostReport = z.infer<typeof PostReport$1>;
type PostReportView = z.infer<typeof PostReportView$1>;
type PostView = z.infer<typeof PostView$1>;
type PrivateMessageView = z.infer<typeof PrivateMessageView$1>;
type RegistrationMode = z.infer<typeof RegistrationMode$1>;
type ResolveObjectResponse = z.infer<typeof ResolveObjectResponse$1>;
type SearchItem = z.infer<typeof SearchItem$1>;
type Site = z.infer<typeof Site$1>;
type SiteAggregates = z.infer<typeof SiteAggregates$1>;
type SiteView = z.infer<typeof SiteView$1>;
type SubscribedType = z.infer<typeof SubscribedType$1>;
type UploadImageResponse = z.infer<typeof UploadImageResponse$1>;

interface BaseClientOptions {
    fetchFunction?: typeof fetch;
    headers?: Record<string, string>;
}
interface ProviderInfo {
    name: "lemmy" | "piefed";
    version: string;
}
type RequestOptions = Pick<RequestInit, "signal">;
type ThreadiverseMode = "lemmyv0" | "lemmyv1" | "piefed";
declare abstract class BaseClient {
    static mode: ThreadiverseMode;
    static softwareName: "lemmy" | "piefed";
    /**
     * NPM semver range, e.g. ">=1.0.0 <2.0.0"
     */
    static softwareVersionRange: string;
    abstract banFromCommunity(payload: BanFromCommunity, options?: RequestOptions): Promise<void>;
    abstract blockCommunity(payload: {
        block: boolean;
        community_id: number;
    }, options?: RequestOptions): Promise<{
        community_view: CommunityView;
    }>;
    abstract blockInstance(payload: {
        block: boolean;
        instance_id: number;
    }, options?: RequestOptions): Promise<void>;
    abstract blockPerson(payload: {
        block: boolean;
        person_id: number;
    }, options?: RequestOptions): Promise<{
        person_view: PersonView;
    }>;
    abstract createComment(payload: CreateComment, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract createCommentReport(payload: {
        comment_id: number;
        reason: string;
    }, options?: RequestOptions): Promise<void>;
    abstract createPost(payload: CreatePost, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract createPostReport(payload: {
        post_id: number;
        reason: string;
    }, options?: RequestOptions): Promise<void>;
    abstract createPrivateMessage(payload: {
        content: string;
        recipient_id: number;
    }, options?: RequestOptions): Promise<{
        private_message_view: PrivateMessageView;
    }>;
    abstract createPrivateMessageReport(payload: {
        private_message_id: number;
        reason: string;
    }, options?: RequestOptions): Promise<void>;
    abstract deleteComment(payload: {
        comment_id: number;
        deleted: boolean;
    }, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract deleteImage(payload: {
        delete_token: string;
        url: string;
    }, options?: RequestOptions): Promise<void>;
    abstract deletePost(payload: {
        deleted: boolean;
        post_id: number;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract distinguishComment(payload: {
        comment_id: number;
        distinguished: boolean;
    }, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract editComment(payload: EditComment, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract editPost(payload: EditPost, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract featurePost(payload: {
        feature_type: "Community" | "Local";
        featured: boolean;
        post_id: number;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract followCommunity(payload: {
        community_id: number;
        follow: boolean;
    }, options?: RequestOptions): Promise<{
        community_view: CommunityView;
    }>;
    abstract getCaptcha(options?: RequestOptions): Promise<GetCaptchaResponse>;
    abstract getComments(payload: GetComments, options?: RequestOptions): Promise<ListCommentsResponse>;
    abstract getCommunity(payload: GetCommunity, options?: RequestOptions): Promise<GetCommunityResponse>;
    abstract getFederatedInstances(options?: RequestOptions): Promise<{
        federated_instances?: FederatedInstances;
    }>;
    abstract getModlog(payload: GetModlog, options?: RequestOptions): Promise<ListModlogResponse>;
    abstract getNotifications(payload: GetPersonMentions, options?: RequestOptions): Promise<ListNotificationsResponse>;
    abstract getPersonDetails(payload: {
        person_id: number;
    } | {
        username: string;
    }, options?: RequestOptions): Promise<GetPersonDetailsResponse>;
    abstract getPersonMentions(payload: GetPersonMentions, options?: RequestOptions): Promise<ListPersonMentionsResponse>;
    abstract getPost(payload: GetPost, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract getPosts(payload: GetPosts, options?: RequestOptions): Promise<ListPostsResponse>;
    abstract getPrivateMessages(payload: GetPrivateMessages, options?: RequestOptions): Promise<ListPrivateMessagesResponse>;
    abstract getRandomCommunity(payload: {
        type_: ListingType;
    }, options?: RequestOptions): Promise<{
        community_view: CommunityView;
    }>;
    abstract getReplies(payload: GetReplies, options?: RequestOptions): Promise<ListRepliesResponse>;
    abstract getSite(options?: RequestOptions): Promise<GetSiteResponse>;
    abstract getSiteMetadata(payload: {
        url: string;
    }, options?: RequestOptions): Promise<GetSiteMetadataResponse>;
    abstract getUnreadCount(options?: RequestOptions): Promise<GetUnreadCountResponse>;
    abstract likeComment(payload: {
        comment_id: number;
        score: number;
    }, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract likePost(payload: {
        post_id: number;
        score: number;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract listCommentReports(payload: PageParams & {
        unresolved_only?: boolean;
    }, options?: RequestOptions): Promise<ListCommentReportsResponse>;
    abstract listCommunities(payload: ListCommunities, options?: RequestOptions): Promise<ListCommunitiesResponse>;
    abstract listPersonContent(payload: ListPersonContent, options?: RequestOptions): Promise<ListPersonContentResponse>;
    abstract listPersonLiked(payload: PageParams & {
        type: LikeType;
    }, options?: RequestOptions): Promise<ListPersonLikedResponse>;
    abstract listPersonSaved(payload: PageParams & {
        person_id: number;
    }, options?: RequestOptions): Promise<ListPersonContentResponse>;
    abstract listPostReports(payload: PageParams & {
        unresolved_only?: boolean;
    }, options?: RequestOptions): Promise<ListPostReportsResponse>;
    abstract listReports(payload: ListReports, options?: RequestOptions): Promise<ListReportsResponse>;
    abstract lockPost(payload: {
        locked: boolean;
        post_id: number;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract login(payload: {
        password: string;
        totp_2fa_token?: string;
        username_or_email: string;
    }, options?: RequestOptions): Promise<{
        jwt?: string;
    }>;
    abstract logout(options?: RequestOptions): Promise<void>;
    abstract markAllAsRead(options?: RequestOptions): Promise<void>;
    abstract markCommentReplyAsRead(payload: {
        comment_reply_id: number;
        read: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract markPersonMentionAsRead(payload: {
        person_mention_id: number;
        read: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract markPostAsRead(payload: {
        post_ids: number[];
        read: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract markPrivateMessageAsRead(payload: {
        private_message_id: number;
        read: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract register(payload: Register, options?: RequestOptions): Promise<LoginResponse>;
    abstract removeComment(payload: {
        comment_id: number;
        reason?: string;
        removed: boolean;
    }, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract removePost(payload: {
        post_id: number;
        reason?: string;
        removed: boolean;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract resolveCommentReport(payload: {
        report_id: number;
        resolved: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract resolveObject(payload: {
        q: string;
    }, options?: RequestOptions): Promise<ResolveObjectResponse>;
    abstract resolvePostReport(payload: {
        report_id: number;
        resolved: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract saveComment(payload: {
        comment_id: number;
        save: boolean;
    }, options?: RequestOptions): Promise<{
        comment_view: CommentView;
    }>;
    abstract savePost(payload: {
        post_id: number;
        save: boolean;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    abstract saveUserSettings(payload: {
        show_nsfw: boolean;
    }, options?: RequestOptions): Promise<void>;
    abstract search(payload: Search, options?: RequestOptions): Promise<ListSearchResponse>;
    abstract uploadImage(payload: {
        file: File;
    }, options?: RequestOptions): Promise<UploadImageResponse>;
}

declare class FediverseError extends Error {
    constructor(message: string, errorOptions?: ErrorOptions);
}
declare class InvalidPayloadError extends FediverseError {
    constructor(message: string);
}
declare class UnexpectedResponseError extends FediverseError {
    constructor(message: string);
}
declare class UnsupportedError extends FediverseError {
    constructor(message: string);
}
declare class UnsupportedSoftwareError extends UnsupportedError {
    constructor(message: string);
}

declare class UnsafeLemmyV1Client implements BaseClient {
    #private;
    static mode: "lemmyv1";
    static softwareName: "lemmy";
    static softwareVersionRange: string;
    constructor(hostname: string, options: BaseClientOptions);
    banFromCommunity(...params: Parameters<BaseClient["banFromCommunity"]>): ReturnType<BaseClient["banFromCommunity"]>;
    blockCommunity(...params: Parameters<BaseClient["blockCommunity"]>): ReturnType<BaseClient["blockCommunity"]>;
    blockInstance(...params: Parameters<BaseClient["blockInstance"]>): ReturnType<BaseClient["blockInstance"]>;
    blockPerson(...params: Parameters<BaseClient["blockPerson"]>): ReturnType<BaseClient["blockPerson"]>;
    createComment(...params: Parameters<BaseClient["createComment"]>): ReturnType<BaseClient["createComment"]>;
    createCommentReport(...params: Parameters<BaseClient["createCommentReport"]>): ReturnType<BaseClient["createCommentReport"]>;
    createPost(...params: Parameters<BaseClient["createPost"]>): ReturnType<BaseClient["createPost"]>;
    createPostReport(...params: Parameters<BaseClient["createPostReport"]>): ReturnType<BaseClient["createPostReport"]>;
    createPrivateMessage(...params: Parameters<BaseClient["createPrivateMessage"]>): ReturnType<BaseClient["createPrivateMessage"]>;
    createPrivateMessageReport(...params: Parameters<BaseClient["createPrivateMessageReport"]>): ReturnType<BaseClient["createPrivateMessageReport"]>;
    deleteComment(...params: Parameters<BaseClient["deleteComment"]>): ReturnType<BaseClient["deleteComment"]>;
    deleteImage(payload: Parameters<BaseClient["deleteImage"]>[0], options?: RequestOptions): ReturnType<BaseClient["deleteImage"]>;
    deletePost(...params: Parameters<BaseClient["deletePost"]>): ReturnType<BaseClient["deletePost"]>;
    distinguishComment(...params: Parameters<BaseClient["distinguishComment"]>): ReturnType<BaseClient["distinguishComment"]>;
    editComment(...params: Parameters<BaseClient["editComment"]>): ReturnType<BaseClient["editComment"]>;
    editPost(...params: Parameters<BaseClient["editPost"]>): ReturnType<BaseClient["editPost"]>;
    featurePost(...params: Parameters<BaseClient["featurePost"]>): ReturnType<BaseClient["featurePost"]>;
    followCommunity(...params: Parameters<BaseClient["followCommunity"]>): ReturnType<BaseClient["followCommunity"]>;
    getCaptcha(...params: Parameters<BaseClient["getCaptcha"]>): ReturnType<BaseClient["getCaptcha"]>;
    getComments(payload: Parameters<BaseClient["getComments"]>[0], options?: RequestOptions): ReturnType<BaseClient["getComments"]>;
    getCommunity(...params: Parameters<BaseClient["getCommunity"]>): ReturnType<BaseClient["getCommunity"]>;
    getFederatedInstances(...params: Parameters<BaseClient["getFederatedInstances"]>): ReturnType<BaseClient["getFederatedInstances"]>;
    getModlog(payload: Parameters<BaseClient["getModlog"]>[0], options?: RequestOptions): ReturnType<BaseClient["getModlog"]>;
    getNotifications(payload: Parameters<BaseClient["getNotifications"]>[0], options?: RequestOptions): ReturnType<BaseClient["getNotifications"]>;
    getPersonDetails(...params: Parameters<BaseClient["getPersonDetails"]>): ReturnType<BaseClient["getPersonDetails"]>;
    getPersonMentions(payload: Parameters<BaseClient["getPersonMentions"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPersonMentions"]>;
    getPost(...params: Parameters<BaseClient["getPost"]>): ReturnType<BaseClient["getPost"]>;
    getPosts(payload: Parameters<BaseClient["getPosts"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPosts"]>;
    getPrivateMessages(payload: Parameters<BaseClient["getPrivateMessages"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPrivateMessages"]>;
    getRandomCommunity(..._params: Parameters<BaseClient["getRandomCommunity"]>): ReturnType<BaseClient["getRandomCommunity"]>;
    getReplies(payload: Parameters<BaseClient["getReplies"]>[0], options?: RequestOptions): ReturnType<BaseClient["getReplies"]>;
    getSite(...params: Parameters<BaseClient["getSite"]>): ReturnType<BaseClient["getSite"]>;
    getSiteMetadata(...params: Parameters<BaseClient["getSiteMetadata"]>): ReturnType<BaseClient["getSiteMetadata"]>;
    getUnreadCount(...params: Parameters<BaseClient["getUnreadCount"]>): ReturnType<BaseClient["getUnreadCount"]>;
    likeComment(...params: Parameters<BaseClient["likeComment"]>): ReturnType<BaseClient["likeComment"]>;
    likePost(...params: Parameters<BaseClient["likePost"]>): ReturnType<BaseClient["likePost"]>;
    listCommentReports(payload: Parameters<BaseClient["listCommentReports"]>[0], options?: RequestOptions): ReturnType<BaseClient["listCommentReports"]>;
    listCommunities(payload: Parameters<BaseClient["listCommunities"]>[0], options?: RequestOptions): ReturnType<BaseClient["listCommunities"]>;
    listPersonContent(payload: Parameters<BaseClient["listPersonContent"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPersonContent"]>;
    listPersonLiked(payload: Parameters<BaseClient["listPersonLiked"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPersonLiked"]>;
    listPersonSaved(payload: Parameters<BaseClient["listPersonSaved"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPersonSaved"]>;
    listPostReports(payload: Parameters<BaseClient["listPostReports"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPostReports"]>;
    listReports(payload: Parameters<BaseClient["listReports"]>[0], options?: RequestOptions): ReturnType<BaseClient["listReports"]>;
    lockPost(...params: Parameters<BaseClient["lockPost"]>): ReturnType<BaseClient["lockPost"]>;
    login(...params: Parameters<BaseClient["login"]>): ReturnType<BaseClient["login"]>;
    logout(...params: Parameters<BaseClient["logout"]>): ReturnType<BaseClient["logout"]>;
    markAllAsRead(...params: Parameters<BaseClient["markAllAsRead"]>): ReturnType<BaseClient["markAllAsRead"]>;
    markCommentReplyAsRead(...params: Parameters<BaseClient["markCommentReplyAsRead"]>): ReturnType<BaseClient["markCommentReplyAsRead"]>;
    markPersonMentionAsRead(payload: Parameters<BaseClient["markPersonMentionAsRead"]>[0], options?: RequestOptions): ReturnType<BaseClient["markPersonMentionAsRead"]>;
    markPostAsRead(...params: Parameters<BaseClient["markPostAsRead"]>): ReturnType<BaseClient["markPostAsRead"]>;
    markPrivateMessageAsRead(...params: Parameters<BaseClient["markPrivateMessageAsRead"]>): ReturnType<BaseClient["markPrivateMessageAsRead"]>;
    register(...params: Parameters<BaseClient["register"]>): ReturnType<BaseClient["register"]>;
    removeComment(...params: Parameters<BaseClient["removeComment"]>): ReturnType<BaseClient["removeComment"]>;
    removePost(...params: Parameters<BaseClient["removePost"]>): ReturnType<BaseClient["removePost"]>;
    resolveCommentReport(...params: Parameters<BaseClient["resolveCommentReport"]>): ReturnType<BaseClient["resolveCommentReport"]>;
    resolveObject(payload: Parameters<BaseClient["resolveObject"]>[0], options?: RequestOptions): ReturnType<BaseClient["resolveObject"]>;
    resolvePostReport(...params: Parameters<BaseClient["resolvePostReport"]>): ReturnType<BaseClient["resolvePostReport"]>;
    saveComment(...params: Parameters<BaseClient["saveComment"]>): ReturnType<BaseClient["saveComment"]>;
    savePost(...params: Parameters<BaseClient["savePost"]>): ReturnType<BaseClient["savePost"]>;
    saveUserSettings(...params: Parameters<BaseClient["saveUserSettings"]>): ReturnType<BaseClient["saveUserSettings"]>;
    search(payload: Parameters<BaseClient["search"]>[0], options?: RequestOptions): ReturnType<BaseClient["search"]>;
    uploadImage(payload: Parameters<BaseClient["uploadImage"]>[0], options?: RequestOptions): ReturnType<BaseClient["uploadImage"]>;
}
declare const _default$2: typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient;

declare class UnsafePiefedClient implements BaseClient {
    #private;
    static mode: "piefed";
    static softwareName: "piefed";
    static softwareVersionRange: string;
    constructor(url: string, options: BaseClientOptions);
    banFromCommunity(payload: Parameters<BaseClient["banFromCommunity"]>[0], options?: RequestOptions): ReturnType<BaseClient["banFromCommunity"]>;
    blockCommunity(payload: Parameters<BaseClient["blockCommunity"]>[0], options?: RequestOptions): ReturnType<BaseClient["blockCommunity"]>;
    blockInstance(payload: Parameters<BaseClient["blockInstance"]>[0], options?: RequestOptions): ReturnType<BaseClient["blockInstance"]>;
    blockPerson(payload: Parameters<BaseClient["blockPerson"]>[0], options?: RequestOptions): ReturnType<BaseClient["blockPerson"]>;
    createComment(payload: Parameters<BaseClient["createComment"]>[0], options?: RequestOptions): ReturnType<BaseClient["createComment"]>;
    createCommentReport(payload: Parameters<BaseClient["createCommentReport"]>[0], options?: RequestOptions): ReturnType<BaseClient["createCommentReport"]>;
    createPost(payload: Parameters<BaseClient["createPost"]>[0], options?: RequestOptions): Promise<{
        post_view: {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        };
    }>;
    createPostReport(payload: Parameters<BaseClient["createPostReport"]>[0], options?: RequestOptions): ReturnType<BaseClient["createPostReport"]>;
    createPrivateMessage(payload: Parameters<BaseClient["createPrivateMessage"]>[0], options?: RequestOptions): ReturnType<BaseClient["createPrivateMessage"]>;
    createPrivateMessageReport(..._params: Parameters<BaseClient["createPrivateMessageReport"]>): ReturnType<BaseClient["createPrivateMessageReport"]>;
    deleteComment(payload: Parameters<BaseClient["deleteComment"]>[0], options?: RequestOptions): ReturnType<BaseClient["deleteComment"]>;
    deleteImage(..._params: Parameters<BaseClient["deleteImage"]>): ReturnType<BaseClient["deleteImage"]>;
    deletePost(payload: {
        deleted: boolean;
        post_id: number;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    distinguishComment(..._params: Parameters<BaseClient["distinguishComment"]>): ReturnType<BaseClient["distinguishComment"]>;
    editComment(payload: Parameters<BaseClient["editComment"]>[0], options?: RequestOptions): ReturnType<BaseClient["editComment"]>;
    editPost(payload: Parameters<BaseClient["editPost"]>[0], options?: RequestOptions): Promise<{
        post_view: {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        };
    }>;
    featurePost(payload: Parameters<BaseClient["featurePost"]>[0], options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    followCommunity(payload: Parameters<BaseClient["followCommunity"]>[0], options?: RequestOptions): ReturnType<BaseClient["followCommunity"]>;
    getCaptcha(..._params: Parameters<BaseClient["getCaptcha"]>): ReturnType<BaseClient["getCaptcha"]>;
    getComments(payload: Parameters<BaseClient["getComments"]>[0], options?: RequestOptions): ReturnType<BaseClient["getComments"]>;
    getCommunity(payload: Parameters<BaseClient["getCommunity"]>[0], options?: RequestOptions): ReturnType<BaseClient["getCommunity"]>;
    getFederatedInstances(..._params: Parameters<BaseClient["getFederatedInstances"]>): ReturnType<BaseClient["getFederatedInstances"]>;
    getModlog(..._params: Parameters<BaseClient["getModlog"]>): ReturnType<BaseClient["getModlog"]>;
    getNotifications(...params: Parameters<BaseClient["getNotifications"]>): ReturnType<BaseClient["getNotifications"]>;
    getPersonDetails(payload: Parameters<BaseClient["getPersonDetails"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPersonDetails"]>;
    getPersonMentions(payload: Parameters<BaseClient["getPersonMentions"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPersonMentions"]>;
    getPost(payload: Parameters<BaseClient["getPost"]>[0], options?: RequestOptions): Promise<{
        post_view: {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        };
    }>;
    getPosts(payload: Parameters<BaseClient["getPosts"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPosts"]>;
    getPrivateMessages(payload: Parameters<BaseClient["getPrivateMessages"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPrivateMessages"]>;
    getRandomCommunity(..._params: Parameters<BaseClient["getRandomCommunity"]>): ReturnType<BaseClient["getRandomCommunity"]>;
    getReplies(payload: Parameters<BaseClient["getReplies"]>[0], options?: RequestOptions): ReturnType<BaseClient["getReplies"]>;
    getSite(options?: RequestOptions): ReturnType<BaseClient["getSite"]>;
    getSiteMetadata(..._params: Parameters<BaseClient["getSiteMetadata"]>): ReturnType<BaseClient["getSiteMetadata"]>;
    getUnreadCount(options?: RequestOptions): Promise<{
        mentions: number;
        private_messages: number;
        replies: number;
        other: number;
    }>;
    likeComment(payload: Parameters<BaseClient["likeComment"]>[0], options?: RequestOptions): ReturnType<BaseClient["likeComment"]>;
    likePost(payload: Parameters<BaseClient["likePost"]>[0], options?: RequestOptions): Promise<{
        post_view: {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        };
    }>;
    listCommentReports(..._params: Parameters<BaseClient["listCommentReports"]>): ReturnType<BaseClient["listCommentReports"]>;
    listCommunities(payload: Parameters<BaseClient["listCommunities"]>[0], options?: RequestOptions): ReturnType<BaseClient["listCommunities"]>;
    listPersonContent(payload: ListPersonContent, options?: RequestOptions): Promise<ListPersonContentResponse>;
    listPersonLiked(..._params: Parameters<BaseClient["listPersonLiked"]>): ReturnType<BaseClient["listPersonLiked"]>;
    listPersonSaved(payload: Parameters<BaseClient["listPersonContent"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPersonContent"]>;
    listPostReports(..._params: Parameters<BaseClient["listPostReports"]>): ReturnType<BaseClient["listPostReports"]>;
    listReports(..._params: Parameters<BaseClient["listReports"]>): ReturnType<BaseClient["listReports"]>;
    lockPost(payload: {
        locked: boolean;
        post_id: number;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    login(payload: Parameters<BaseClient["login"]>[0], options?: RequestOptions): Promise<{
        jwt: string;
    }>;
    logout(_options?: RequestOptions): Promise<void>;
    markAllAsRead(options: Parameters<BaseClient["markAllAsRead"]>[0]): Promise<void>;
    markCommentReplyAsRead(payload: Parameters<BaseClient["markCommentReplyAsRead"]>[0], options?: RequestOptions): ReturnType<BaseClient["markCommentReplyAsRead"]>;
    markPersonMentionAsRead(payload: Parameters<BaseClient["markPersonMentionAsRead"]>[0], options?: RequestOptions): ReturnType<BaseClient["markPersonMentionAsRead"]>;
    markPostAsRead(payload: Parameters<BaseClient["markPostAsRead"]>[0], options?: RequestOptions): ReturnType<BaseClient["markPostAsRead"]>;
    markPrivateMessageAsRead(payload: Parameters<BaseClient["markPrivateMessageAsRead"]>[0], options?: RequestOptions): ReturnType<BaseClient["markPrivateMessageAsRead"]>;
    register(..._params: Parameters<BaseClient["register"]>): ReturnType<BaseClient["register"]>;
    removeComment(payload: Parameters<BaseClient["removeComment"]>[0], options?: RequestOptions): ReturnType<BaseClient["removeComment"]>;
    removePost(payload: {
        post_id: number;
        removed: boolean;
    }, options?: RequestOptions): Promise<{
        post_view: PostView;
    }>;
    resolveCommentReport(..._params: Parameters<BaseClient["resolveCommentReport"]>): ReturnType<BaseClient["resolveCommentReport"]>;
    resolveObject(payload: Parameters<BaseClient["resolveObject"]>[0], options?: RequestOptions): ReturnType<BaseClient["resolveObject"]>;
    resolvePostReport(..._params: Parameters<BaseClient["resolvePostReport"]>): ReturnType<BaseClient["resolvePostReport"]>;
    saveComment(payload: Parameters<BaseClient["saveComment"]>[0], options?: RequestOptions): ReturnType<BaseClient["saveComment"]>;
    savePost(payload: Parameters<BaseClient["savePost"]>[0], options?: RequestOptions): ReturnType<BaseClient["savePost"]>;
    saveUserSettings(..._params: Parameters<BaseClient["saveUserSettings"]>): ReturnType<BaseClient["saveUserSettings"]>;
    search(payload: Parameters<BaseClient["search"]>[0], options?: RequestOptions): ReturnType<BaseClient["search"]>;
    uploadImage(payload: Parameters<BaseClient["uploadImage"]>[0], options?: RequestOptions): Promise<{
        url: any;
    }>;
}
declare const _default$1: typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient;

declare class UnsafeLemmyV0Client implements BaseClient {
    #private;
    static mode: "lemmyv0";
    static softwareName: "lemmy";
    static softwareVersionRange: string;
    constructor(hostname: string, options: BaseClientOptions);
    banFromCommunity(...params: Parameters<BaseClient["banFromCommunity"]>): ReturnType<BaseClient["banFromCommunity"]>;
    blockCommunity(...params: Parameters<BaseClient["blockCommunity"]>): ReturnType<BaseClient["blockCommunity"]>;
    blockInstance(...params: Parameters<BaseClient["blockInstance"]>): ReturnType<BaseClient["blockInstance"]>;
    blockPerson(...params: Parameters<BaseClient["blockPerson"]>): ReturnType<BaseClient["blockPerson"]>;
    createComment(...params: Parameters<BaseClient["createComment"]>): ReturnType<BaseClient["createComment"]>;
    createCommentReport(...params: Parameters<BaseClient["createCommentReport"]>): ReturnType<BaseClient["createCommentReport"]>;
    createPost(...params: Parameters<BaseClient["createPost"]>): ReturnType<BaseClient["createPost"]>;
    createPostReport(...params: Parameters<BaseClient["createPostReport"]>): ReturnType<BaseClient["createPostReport"]>;
    createPrivateMessage(...params: Parameters<BaseClient["createPrivateMessage"]>): ReturnType<BaseClient["createPrivateMessage"]>;
    createPrivateMessageReport(...params: Parameters<BaseClient["createPrivateMessageReport"]>): ReturnType<BaseClient["createPrivateMessageReport"]>;
    deleteComment(...params: Parameters<BaseClient["deleteComment"]>): ReturnType<BaseClient["deleteComment"]>;
    deleteImage(payload: Parameters<BaseClient["deleteImage"]>[0], options?: RequestOptions): ReturnType<BaseClient["deleteImage"]>;
    deletePost(...params: Parameters<BaseClient["deletePost"]>): ReturnType<BaseClient["deletePost"]>;
    distinguishComment(...params: Parameters<BaseClient["distinguishComment"]>): ReturnType<BaseClient["distinguishComment"]>;
    editComment(...params: Parameters<BaseClient["editComment"]>): ReturnType<BaseClient["editComment"]>;
    editPost(...params: Parameters<BaseClient["editPost"]>): ReturnType<BaseClient["editPost"]>;
    featurePost(...params: Parameters<BaseClient["featurePost"]>): ReturnType<BaseClient["featurePost"]>;
    followCommunity(...params: Parameters<BaseClient["followCommunity"]>): ReturnType<BaseClient["followCommunity"]>;
    getCaptcha(...params: Parameters<BaseClient["getCaptcha"]>): ReturnType<BaseClient["getCaptcha"]>;
    getComments(payload: Parameters<BaseClient["getComments"]>[0], options?: RequestOptions): ReturnType<BaseClient["getComments"]>;
    getCommunity(...params: Parameters<BaseClient["getCommunity"]>): ReturnType<BaseClient["getCommunity"]>;
    getFederatedInstances(...params: Parameters<BaseClient["getFederatedInstances"]>): ReturnType<BaseClient["getFederatedInstances"]>;
    getModlog(payload: Parameters<BaseClient["getModlog"]>[0], options?: RequestOptions): ReturnType<BaseClient["getModlog"]>;
    getNotifications(payload: Parameters<BaseClient["getNotifications"]>[0], options?: RequestOptions): ReturnType<BaseClient["getNotifications"]>;
    getPersonDetails(payload: Parameters<BaseClient["getPersonDetails"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPersonDetails"]>;
    getPersonMentions(payload: Parameters<BaseClient["getPersonMentions"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPersonMentions"]>;
    getPost(...params: Parameters<BaseClient["getPost"]>): ReturnType<BaseClient["getPost"]>;
    getPosts(payload: Parameters<BaseClient["getPosts"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPosts"]>;
    getPostSortType(): Promise<readonly [{
        readonly sort: "Top";
    }, {
        readonly sort: "All";
    }]>;
    getPrivateMessages(payload: Parameters<BaseClient["getPrivateMessages"]>[0], options?: RequestOptions): ReturnType<BaseClient["getPrivateMessages"]>;
    getRandomCommunity(..._params: Parameters<BaseClient["getRandomCommunity"]>): ReturnType<BaseClient["getRandomCommunity"]>;
    getReplies(payload: Parameters<BaseClient["getReplies"]>[0], options?: RequestOptions): ReturnType<BaseClient["getReplies"]>;
    getSite(...params: Parameters<BaseClient["getSite"]>): ReturnType<BaseClient["getSite"]>;
    getSiteMetadata(...params: Parameters<BaseClient["getSiteMetadata"]>): ReturnType<BaseClient["getSiteMetadata"]>;
    getUnreadCount(...params: Parameters<BaseClient["getUnreadCount"]>): ReturnType<BaseClient["getUnreadCount"]>;
    likeComment(...params: Parameters<BaseClient["likeComment"]>): ReturnType<BaseClient["likeComment"]>;
    likePost(...params: Parameters<BaseClient["likePost"]>): ReturnType<BaseClient["likePost"]>;
    listCommentReports(payload: Parameters<BaseClient["listCommentReports"]>[0], options?: RequestOptions): ReturnType<BaseClient["listCommentReports"]>;
    listCommunities(payload: Parameters<BaseClient["listCommunities"]>[0], options?: RequestOptions): ReturnType<BaseClient["listCommunities"]>;
    listPersonContent(payload: Parameters<BaseClient["listPersonContent"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPersonContent"]>;
    listPersonLiked({ type, ...payload }: Parameters<BaseClient["listPersonLiked"]>[0], options?: RequestOptions): Promise<ListPersonLikedResponse>;
    listPersonSaved(payload: Parameters<BaseClient["listPersonSaved"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPersonSaved"]>;
    listPostReports(payload: Parameters<BaseClient["listPostReports"]>[0], options?: RequestOptions): ReturnType<BaseClient["listPostReports"]>;
    listReports(payload: Parameters<BaseClient["listReports"]>[0], options?: RequestOptions): ReturnType<BaseClient["listReports"]>;
    lockPost(...params: Parameters<BaseClient["lockPost"]>): ReturnType<BaseClient["lockPost"]>;
    login(...params: Parameters<BaseClient["login"]>): ReturnType<BaseClient["login"]>;
    logout(...params: Parameters<BaseClient["logout"]>): ReturnType<BaseClient["logout"]>;
    markAllAsRead(...params: Parameters<BaseClient["markAllAsRead"]>): ReturnType<BaseClient["markAllAsRead"]>;
    markCommentReplyAsRead(...params: Parameters<BaseClient["markCommentReplyAsRead"]>): ReturnType<BaseClient["markCommentReplyAsRead"]>;
    markPersonMentionAsRead(...params: Parameters<BaseClient["markPersonMentionAsRead"]>): ReturnType<BaseClient["markPersonMentionAsRead"]>;
    markPostAsRead(...params: Parameters<BaseClient["markPostAsRead"]>): ReturnType<BaseClient["markPostAsRead"]>;
    markPrivateMessageAsRead(...params: Parameters<BaseClient["markPrivateMessageAsRead"]>): ReturnType<BaseClient["markPrivateMessageAsRead"]>;
    register(...params: Parameters<BaseClient["register"]>): ReturnType<BaseClient["register"]>;
    removeComment(...params: Parameters<BaseClient["removeComment"]>): ReturnType<BaseClient["removeComment"]>;
    removePost(...params: Parameters<BaseClient["removePost"]>): ReturnType<BaseClient["removePost"]>;
    resolveCommentReport(...params: Parameters<BaseClient["resolveCommentReport"]>): ReturnType<BaseClient["resolveCommentReport"]>;
    resolveObject(payload: Parameters<BaseClient["resolveObject"]>[0], options?: RequestOptions): ReturnType<BaseClient["resolveObject"]>;
    resolvePostReport(...params: Parameters<BaseClient["resolvePostReport"]>): ReturnType<BaseClient["resolvePostReport"]>;
    saveComment(...params: Parameters<BaseClient["saveComment"]>): ReturnType<BaseClient["saveComment"]>;
    savePost(...params: Parameters<BaseClient["savePost"]>): ReturnType<BaseClient["savePost"]>;
    saveUserSettings(...params: Parameters<BaseClient["saveUserSettings"]>): ReturnType<BaseClient["saveUserSettings"]>;
    search(payload: Parameters<BaseClient["search"]>[0], options?: RequestOptions): ReturnType<BaseClient["search"]>;
    uploadImage(payload: Parameters<BaseClient["uploadImage"]>[0], options?: RequestOptions): ReturnType<BaseClient["uploadImage"]>;
}
declare const _default: typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient;

interface Nodeinfo21Payload {
    software: {
        name: string;
        version: string;
    };
}

declare class ThreadiverseClient implements BaseClient {
    /**
     * Important: First match wins.
     */
    static get supportedSoftware(): readonly [typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient, typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient, typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient];
    get software(): ProviderInfo;
    private delegateClient;
    private discoveredSoftware;
    private hostname;
    private options;
    constructor(hostname: string, options: BaseClientOptions);
    static resolveClient(software: Nodeinfo21Payload["software"]): (typeof UnsafeLemmyV0Client | typeof UnsafeLemmyV1Client | typeof UnsafePiefedClient) | undefined;
    banFromCommunity(...params: Parameters<BaseClient["banFromCommunity"]>): Promise<void>;
    blockCommunity(...params: Parameters<BaseClient["blockCommunity"]>): Promise<{
        community_view: CommunityView;
    }>;
    blockInstance(...params: Parameters<BaseClient["blockInstance"]>): Promise<void>;
    blockPerson(...params: Parameters<BaseClient["blockPerson"]>): Promise<{
        person_view: PersonView;
    }>;
    createComment(...params: Parameters<BaseClient["createComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    createCommentReport(...params: Parameters<BaseClient["createCommentReport"]>): Promise<void>;
    createPost(...params: Parameters<BaseClient["createPost"]>): Promise<{
        post_view: PostView;
    }>;
    createPostReport(...params: Parameters<BaseClient["createPostReport"]>): Promise<void>;
    createPrivateMessage(...params: Parameters<BaseClient["createPrivateMessage"]>): Promise<{
        private_message_view: PrivateMessageView;
    }>;
    createPrivateMessageReport(...params: Parameters<BaseClient["createPrivateMessageReport"]>): Promise<void>;
    deleteComment(...params: Parameters<BaseClient["deleteComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    deleteImage(...params: Parameters<BaseClient["deleteImage"]>): Promise<void>;
    deletePost(...params: Parameters<BaseClient["deletePost"]>): Promise<{
        post_view: PostView;
    }>;
    distinguishComment(...params: Parameters<BaseClient["distinguishComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    editComment(...params: Parameters<BaseClient["editComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    editPost(...params: Parameters<BaseClient["editPost"]>): Promise<{
        post_view: PostView;
    }>;
    featurePost(...params: Parameters<BaseClient["featurePost"]>): Promise<{
        post_view: PostView;
    }>;
    followCommunity(...params: Parameters<BaseClient["followCommunity"]>): Promise<{
        community_view: CommunityView;
    }>;
    getCaptcha(...params: Parameters<BaseClient["getCaptcha"]>): Promise<{
        ok?: {
            png: string;
            uuid: string;
            wav: string;
        } | undefined;
    }>;
    getComments(...params: Parameters<BaseClient["getComments"]>): Promise<{
        data: {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getCommunity(...params: Parameters<BaseClient["getCommunity"]>): Promise<{
        community_view: {
            blocked: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                posts: number;
                subscribers: number;
            } | {
                comments: number;
                posts: number;
                subscribers: number;
                subscribers_local: number;
                users_active_day: number;
                users_active_half_year: number;
                users_active_month: number;
                users_active_week: number;
            };
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
        };
        moderators: {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            moderator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        }[];
    }>;
    getFederatedInstances(...params: Parameters<BaseClient["getFederatedInstances"]>): Promise<{
        federated_instances?: FederatedInstances;
    }>;
    getMode(): Promise<ThreadiverseMode>;
    getModlog(...params: Parameters<BaseClient["getModlog"]>): Promise<{
        data: ({
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_remove_post: {
                id: number;
                mod_person_id: number;
                post_id: number;
                removed: boolean;
                when_: string;
                reason?: string | undefined;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_lock_post: {
                id: number;
                locked: boolean;
                mod_person_id: number;
                post_id: number;
                when_: string;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_feature_post: {
                featured: boolean;
                id: number;
                is_featured_community: boolean;
                mod_person_id: number;
                post_id: number;
                when_: string;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            commenter: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_remove_comment: {
                comment_id: number;
                id: number;
                mod_person_id: number;
                removed: boolean;
                when_: string;
                reason?: string | undefined;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_remove_community: {
                community_id: number;
                id: number;
                mod_person_id: number;
                removed: boolean;
                when_: string;
                reason?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            banned_person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_ban_from_community: {
                banned: boolean;
                community_id: number;
                id: number;
                mod_person_id: number;
                other_person_id: number;
                when_: string;
                expires?: string | undefined;
                reason?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            banned_person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            mod_ban: {
                banned: boolean;
                id: number;
                mod_person_id: number;
                other_person_id: number;
                when_: string;
                expires?: string | undefined;
                reason?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_add_community: {
                community_id: number;
                id: number;
                mod_person_id: number;
                other_person_id: number;
                removed: boolean;
                when_: string;
            };
            modded_person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_transfer_community: {
                community_id: number;
                id: number;
                mod_person_id: number;
                other_person_id: number;
                when_: string;
            };
            modded_person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            mod_add: {
                id: number;
                mod_person_id: number;
                other_person_id: number;
                removed: boolean;
                when_: string;
            };
            modded_person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            moderator?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            admin_purge_person: {
                admin_person_id: number;
                id: number;
                when_: string;
                reason?: string | undefined;
            };
            admin?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            admin_purge_community: {
                admin_person_id: number;
                id: number;
                when_: string;
                reason?: string | undefined;
            };
            admin?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            admin_purge_post: {
                admin_person_id: number;
                community_id: number;
                id: number;
                when_: string;
                reason?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            admin?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            admin_purge_comment: {
                admin_person_id: number;
                id: number;
                post_id: number;
                when_: string;
                reason?: string | undefined;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            admin?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            mod_hide_community: {
                community_id: number;
                hidden: boolean;
                id: number;
                mod_person_id: number;
                when_: string;
                reason?: string | undefined;
            };
            admin?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getNotifications(...params: Parameters<BaseClient["getNotifications"]>): Promise<{
        data: ({
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            private_message: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                id: number;
                local: boolean;
                published: string;
                read: boolean;
                recipient_id: number;
                updated?: string | undefined;
            };
            recipient: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        } | {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            comment_reply: {
                comment_id: number;
                id: number;
                published: string;
                read: boolean;
                recipient_id: number;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            recipient: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        } | {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            person_mention: {
                comment_id: number;
                id: number;
                published: string;
                read: boolean;
                recipient_id: number;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            recipient: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getPersonDetails(...params: Parameters<BaseClient["getPersonDetails"]>): Promise<{
        moderates: {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            moderator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        }[];
        person_view: {
            counts: {
                comment_count: number;
                post_count: number;
            };
            is_admin: boolean;
            person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        };
    }>;
    getPersonMentions(...params: Parameters<BaseClient["getPersonMentions"]>): Promise<{
        data: {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            person_mention: {
                comment_id: number;
                id: number;
                published: string;
                read: boolean;
                recipient_id: number;
            };
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            recipient: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getPost(...params: Parameters<BaseClient["getPost"]>): Promise<{
        post_view: PostView;
    }>;
    getPosts(...params: Parameters<BaseClient["getPosts"]>): Promise<{
        data: {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getPrivateMessages(...params: Parameters<BaseClient["getPrivateMessages"]>): Promise<{
        data: {
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            private_message: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                id: number;
                local: boolean;
                published: string;
                read: boolean;
                recipient_id: number;
                updated?: string | undefined;
            };
            recipient: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getRandomCommunity(...params: Parameters<BaseClient["getRandomCommunity"]>): Promise<{
        community_view: CommunityView;
    }>;
    getReplies(...params: Parameters<BaseClient["getReplies"]>): Promise<{
        data: {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            comment_reply: {
                comment_id: number;
                id: number;
                published: string;
                read: boolean;
                recipient_id: number;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            recipient: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    getSite(...params: Parameters<BaseClient["getSite"]>): Promise<{
        admins: {
            counts: {
                comment_count: number;
                post_count: number;
            };
            is_admin: boolean;
            person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        }[];
        site_view: {
            local_site: {
                captcha_enabled: boolean;
                comment_downvotes: "All" | "Local" | "Disable";
                comment_upvotes: "All" | "Local" | "Disable";
                post_downvotes: "All" | "Local" | "Disable";
                post_upvotes: "All" | "Local" | "Disable";
                registration_mode: "Closed" | "RequireApplication" | "Open";
                require_email_verification: boolean;
                application_question?: string | undefined;
                legal_information?: string | undefined;
            };
            site: {
                actor_id: string;
                name: string;
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                sidebar?: string | undefined;
                version?: string | undefined;
            };
            counts?: {
                comments: number;
                communities: number;
                posts: number;
                users: number;
                users_active_day: number;
                users_active_half_year: number;
                users_active_month: number;
                users_active_week: number;
            } | undefined;
        };
        version: string;
        my_user?: {
            community_blocks: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            }[];
            follows: {
                community: {
                    actor_id: string;
                    deleted: boolean;
                    hidden: boolean;
                    id: number;
                    local: boolean;
                    name: string;
                    nsfw: boolean;
                    posting_restricted_to_mods: boolean;
                    published: string;
                    removed: boolean;
                    title: string;
                    visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                    banner?: string | undefined;
                    description?: string | undefined;
                    icon?: string | undefined;
                    updated?: string | undefined;
                };
                follower: {
                    actor_id: string;
                    bot_account: boolean;
                    deleted: boolean;
                    id: number;
                    local: boolean;
                    name: string;
                    published: string;
                    avatar?: string | undefined;
                    banner?: string | undefined;
                    bio?: string | undefined;
                    display_name?: string | undefined;
                };
            }[];
            instance_blocks: {
                domain: string;
                id: number;
                published: string;
                software?: string | undefined;
                updated?: string | undefined;
                version?: string | undefined;
            }[];
            local_user_view: {
                counts: {
                    comment_count: number;
                    post_count: number;
                };
                local_user: {
                    admin: boolean;
                    show_nsfw: boolean;
                };
                person: {
                    actor_id: string;
                    bot_account: boolean;
                    deleted: boolean;
                    id: number;
                    local: boolean;
                    name: string;
                    published: string;
                    avatar?: string | undefined;
                    banner?: string | undefined;
                    bio?: string | undefined;
                    display_name?: string | undefined;
                };
            };
            moderates: {
                community: {
                    actor_id: string;
                    deleted: boolean;
                    hidden: boolean;
                    id: number;
                    local: boolean;
                    name: string;
                    nsfw: boolean;
                    posting_restricted_to_mods: boolean;
                    published: string;
                    removed: boolean;
                    title: string;
                    visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                    banner?: string | undefined;
                    description?: string | undefined;
                    icon?: string | undefined;
                    updated?: string | undefined;
                };
                moderator: {
                    actor_id: string;
                    bot_account: boolean;
                    deleted: boolean;
                    id: number;
                    local: boolean;
                    name: string;
                    published: string;
                    avatar?: string | undefined;
                    banner?: string | undefined;
                    bio?: string | undefined;
                    display_name?: string | undefined;
                };
            }[];
            person_blocks: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            }[];
        } | undefined;
    }>;
    getSiteMetadata(...params: Parameters<BaseClient["getSiteMetadata"]>): Promise<{
        metadata: {
            content_type?: string | undefined;
            description?: string | undefined;
            embed_video_url?: string | undefined;
            image?: string | undefined;
            title?: string | undefined;
        };
    }>;
    getSoftware(): Promise<ProviderInfo>;
    getUnreadCount(...params: Parameters<BaseClient["getUnreadCount"]>): Promise<{
        mentions: number;
        private_messages: number;
        replies: number;
    }>;
    likeComment(...params: Parameters<BaseClient["likeComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    likePost(...params: Parameters<BaseClient["likePost"]>): Promise<{
        post_view: PostView;
    }>;
    listCommentReports(...params: Parameters<BaseClient["listCommentReports"]>): Promise<{
        data: {
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            comment_creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            comment_report: {
                comment_id: number;
                creator_id: number;
                id: number;
                original_comment_text: string;
                published: string;
                reason: string;
                resolved: boolean;
                resolver_id?: number | undefined;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
            resolver?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    listCommunities(...params: Parameters<BaseClient["listCommunities"]>): Promise<{
        data: {
            blocked: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                posts: number;
                subscribers: number;
            } | {
                comments: number;
                posts: number;
                subscribers: number;
                subscribers_local: number;
                users_active_day: number;
                users_active_half_year: number;
                users_active_month: number;
                users_active_week: number;
            };
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    listPersonContent(...params: Parameters<BaseClient["listPersonContent"]>): Promise<{
        data: ({
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        } | {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    listPersonLiked(...params: Parameters<BaseClient["listPersonLiked"]>): Promise<{
        data: ({
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        } | {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    listPersonSaved(...params: Parameters<BaseClient["listPersonSaved"]>): Promise<{
        data: ({
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        } | {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    listPostReports(...params: Parameters<BaseClient["listPostReports"]>): Promise<{
        data: {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            post_creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            post_report: {
                creator_id: number;
                id: number;
                original_post_name: string;
                post_id: number;
                published: string;
                reason: string;
                resolved: boolean;
                original_post_body?: string | undefined;
                original_post_url?: string | undefined;
                resolver_id?: number | undefined;
                updated?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
            resolver?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        }[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    listReports(...params: Parameters<BaseClient["listReports"]>): Promise<{
        data: ({
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            comment_creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            comment_report: {
                comment_id: number;
                creator_id: number;
                id: number;
                original_comment_text: string;
                published: string;
                reason: string;
                resolved: boolean;
                resolver_id?: number | undefined;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
            resolver?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        } | {
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            post_creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            post_report: {
                creator_id: number;
                id: number;
                original_post_name: string;
                post_id: number;
                published: string;
                reason: string;
                resolved: boolean;
                original_post_body?: string | undefined;
                original_post_url?: string | undefined;
                resolver_id?: number | undefined;
                updated?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
            resolver?: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            } | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    lockPost(...params: Parameters<BaseClient["lockPost"]>): Promise<{
        post_view: PostView;
    }>;
    login(...params: Parameters<BaseClient["login"]>): Promise<{
        jwt?: string;
    }>;
    logout(...params: Parameters<BaseClient["logout"]>): Promise<void>;
    markAllAsRead(...params: Parameters<BaseClient["markAllAsRead"]>): Promise<void>;
    markCommentReplyAsRead(...params: Parameters<BaseClient["markCommentReplyAsRead"]>): Promise<void>;
    markPersonMentionAsRead(...params: Parameters<BaseClient["markPersonMentionAsRead"]>): Promise<void>;
    markPostAsRead(...params: Parameters<BaseClient["markPostAsRead"]>): Promise<void>;
    markPrivateMessageAsRead(...params: Parameters<BaseClient["markPrivateMessageAsRead"]>): Promise<void>;
    register(...params: Parameters<BaseClient["register"]>): Promise<{
        jwt?: string | undefined;
        registration_created?: boolean | undefined;
        verify_email_sent?: boolean | undefined;
    }>;
    removeComment(...params: Parameters<BaseClient["removeComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    removePost(...params: Parameters<BaseClient["removePost"]>): Promise<{
        post_view: PostView;
    }>;
    resolveCommentReport(...params: Parameters<BaseClient["resolveCommentReport"]>): Promise<void>;
    resolveObject(...params: Parameters<BaseClient["resolveObject"]>): Promise<{
        comment?: {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        } | undefined;
        community?: {
            blocked: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                posts: number;
                subscribers: number;
            } | {
                comments: number;
                posts: number;
                subscribers: number;
                subscribers_local: number;
                users_active_day: number;
                users_active_half_year: number;
                users_active_month: number;
                users_active_week: number;
            };
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
        } | undefined;
        person?: {
            counts: {
                comment_count: number;
                post_count: number;
            };
            is_admin: boolean;
            person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        } | undefined;
        post?: {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        } | undefined;
    }>;
    resolvePostReport(...params: Parameters<BaseClient["resolvePostReport"]>): Promise<void>;
    saveComment(...params: Parameters<BaseClient["saveComment"]>): Promise<{
        comment_view: CommentView;
    }>;
    savePost(...params: Parameters<BaseClient["savePost"]>): Promise<{
        post_view: PostView;
    }>;
    saveUserSettings(...params: Parameters<BaseClient["saveUserSettings"]>): Promise<void>;
    search(...params: Parameters<BaseClient["search"]>): Promise<{
        data: ({
            blocked: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                posts: number;
                subscribers: number;
            } | {
                comments: number;
                posts: number;
                subscribers: number;
                subscribers_local: number;
                users_active_day: number;
                users_active_half_year: number;
                users_active_month: number;
                users_active_week: number;
            };
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
        } | {
            counts: {
                comment_count: number;
                post_count: number;
            };
            is_admin: boolean;
            person: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
        } | {
            banned_from_community: boolean;
            comment: {
                ap_id: string;
                content: string;
                creator_id: number;
                deleted: boolean;
                distinguished: boolean;
                id: number;
                language_id: number;
                local: boolean;
                path: string;
                post_id: number;
                published: string;
                removed: boolean;
                updated?: string | undefined;
            };
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                child_count: number;
                comment_id: number;
                downvotes: number;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            my_vote?: number | undefined;
        } | {
            banned_from_community: boolean;
            community: {
                actor_id: string;
                deleted: boolean;
                hidden: boolean;
                id: number;
                local: boolean;
                name: string;
                nsfw: boolean;
                posting_restricted_to_mods: boolean;
                published: string;
                removed: boolean;
                title: string;
                visibility: "Public" | "Unlisted" | "LocalOnlyPublic" | "LocalOnlyPrivate" | "Private";
                banner?: string | undefined;
                description?: string | undefined;
                icon?: string | undefined;
                updated?: string | undefined;
            };
            counts: {
                comments: number;
                downvotes: number;
                newest_comment_time: string;
                published: string;
                score: number;
                upvotes: number;
            };
            creator: {
                actor_id: string;
                bot_account: boolean;
                deleted: boolean;
                id: number;
                local: boolean;
                name: string;
                published: string;
                avatar?: string | undefined;
                banner?: string | undefined;
                bio?: string | undefined;
                display_name?: string | undefined;
            };
            creator_banned_from_community: boolean;
            creator_blocked: boolean;
            creator_is_admin: boolean;
            creator_is_moderator: boolean;
            hidden: boolean;
            post: {
                ap_id: string;
                community_id: number;
                creator_id: number;
                deleted: boolean;
                featured_community: boolean;
                featured_local: boolean;
                id: number;
                language_id: number;
                local: boolean;
                locked: boolean;
                name: string;
                nsfw: boolean;
                published: string;
                removed: boolean;
                alt_text?: string | undefined;
                body?: string | undefined;
                embed_description?: string | undefined;
                embed_title?: string | undefined;
                thumbnail_url?: string | undefined;
                updated?: string | undefined;
                url?: string | undefined;
                url_content_type?: string | undefined;
            };
            read: boolean;
            saved: boolean;
            subscribed: "Subscribed" | "NotSubscribed" | "Pending" | "ApprovalRequired";
            unread_comments: number;
            my_vote?: number | undefined;
        })[];
        next_page?: string | number | undefined;
        prev_page?: string | number | undefined;
    }>;
    uploadImage(...params: Parameters<BaseClient["uploadImage"]>): Promise<{
        url: string;
        delete_token?: string | undefined;
    }>;
    private ensureClient;
}

export { BaseClient, FediverseError, InvalidPayloadError, _default as LemmyV0Client, _default$2 as LemmyV1Client, _default$1 as PiefedClient, ThreadiverseClient, UnexpectedResponseError, UnsupportedError, UnsupportedSoftwareError };
export type { AdminPurgeComment, AdminPurgeCommentView, AdminPurgeCommunity, AdminPurgeCommunityView, AdminPurgePerson, AdminPurgePersonView, AdminPurgePost, AdminPurgePostView, BanFromCommunity, BaseClientOptions, Comment, CommentAggregates, CommentReply, CommentReplyView, CommentReport, CommentReportView, CommentSortType, CommentSortTypeByMode, CommentView, Community, CommunityAggregates, CommunityFollowerView, CommunityModeratorView, CommunitySortType, CommunitySortTypeByMode, CommunityView, CommunityVisibility, CreateComment, CreatePost, EditComment, EditPost, FederatedInstances, GetCaptchaResponse, GetComments, GetCommunity, GetCommunityResponse, GetModlog, GetPersonDetailsResponse, GetPersonMentions, GetPost, GetPosts, GetPrivateMessages, GetReplies, GetSiteMetadataResponse, GetSiteResponse, GetUnreadCountResponse, Instance, InstanceWithFederationState, LikeType, LinkMetadata, ListCommentReportsResponse, ListCommentsResponse, ListCommunities, ListCommunitiesResponse, ListModlogResponse, ListNotificationsResponse, ListPersonContent, ListPersonContentResponse, ListPersonLikedResponse, ListPersonMentionsResponse, ListPostReportsResponse, ListPostsResponse, ListPrivateMessagesResponse, ListRepliesResponse, ListReports, ListReportsResponse, ListSearchResponse, ListingType, LocalSite, LoginResponse, ModAdd, ModAddCommunity, ModAddCommunityView, ModAddView, ModBan, ModBanFromCommunity, ModBanFromCommunityView, ModBanView, ModFeaturePost, ModFeaturePostView, ModHideCommunity, ModHideCommunityView, ModLockPost, ModLockPostView, ModRemoveComment, ModRemoveCommentView, ModRemoveCommunity, ModRemoveCommunityView, ModRemovePost, ModRemovePostView, ModTransferCommunity, ModTransferCommunityView, ModlogActionType, ModlogItem, MyUserInfo, Notification, PagableResponse, PageCursor, PageParams, Person, PersonAggregates, PersonContentItem, PersonMention, PersonMentionView, PersonView, Post, PostAggregates, PostReport, PostReportView, PostSortType, PostSortTypeByMode, PostView, PrivateMessageView, ProviderInfo, Register, RegistrationMode, RequestOptions, ResolveObjectResponse, Search, SearchItem, SearchSortType, SearchSortTypeByMode, SearchType, Site, SiteAggregates, SiteView, SubscribedType, ThreadiverseMode, UploadImageResponse };
