import pc from 'picocolors';
const testMode = !!+process.env.PAG_TEST_MODE;
const logger = (prefix, options) => {
    const isLogEnabled = options && options.hasOwnProperty('log') ? options.log : true;
    const getTime = () => pc.inverse(new Date().toLocaleTimeString());
    const getPrefix = () => (prefix ? pc.gray(prefix) : '');
    const raw = (...args) => {
        if (!isLogEnabled)
            return;
        console.log(...args);
    };
    const log = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.log(getTime(), getPrefix(), ...args);
    };
    const warn = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.warn(getTime(), getPrefix(), pc.yellow(args.join(' ')), '🤔');
    };
    const trace = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.trace(getTime(), getPrefix(), ...args);
    };
    const error = (...args) => {
        console.error(getTime(), getPrefix(), pc.red(args.join(' ')), '😭');
    };
    const success = (...args) => {
        if (testMode || !isLogEnabled)
            return;
        console.log(getTime(), getPrefix(), pc.green(args.join(' ')), '🙌');
    };
    return {
        raw,
        log,
        warn,
        trace,
        error,
        success,
    };
};
export default logger;
//# sourceMappingURL=logger.js.map