import { isDeepStrictEqual } from 'node:util';
import constants from '../config/constants.js';
const uniqWithDeepStrictEqual = (arr) => arr.filter((item, idx) => arr.findIndex((other) => isDeepStrictEqual(item, other)) === idx);
const mapToIconImageFileObj = (fileNamePrefix, width, height) => ({
    name: `${fileNamePrefix}-${width}${height ? `-${height}` : ''}`,
    width,
    height: height ?? width,
    orientation: null,
    scaleFactor: 1,
});
const mapToImageFileObj = (fileNamePrefix, width, height, scaleFactor, orientation) => ({
    name: `${fileNamePrefix}-${width}-${height}`,
    width,
    height,
    scaleFactor,
    orientation,
});
const getIconImages = (options) => {
    let icons = [
        ...constants.APPLE_ICON_SIZES.map((size) => mapToIconImageFileObj(constants.APPLE_ICON_FILENAME_PREFIX, size)),
        ...constants.MANIFEST_ICON_SIZES.map((size) => mapToIconImageFileObj(constants.MANIFEST_ICON_FILENAME_PREFIX, size)),
    ];
    if (options.favicon) {
        icons = [
            ...icons,
            ...constants.FAVICON_SIZES.map((size) => mapToIconImageFileObj(constants.FAVICON_FILENAME_PREFIX, size)),
        ];
    }
    if (options.mstile) {
        icons = [
            ...icons,
            ...constants.MS_ICON_SIZES.map((size) => {
                if (typeof size === 'object') {
                    return mapToIconImageFileObj(constants.MS_ICON_FILENAME_PREFIX, size.width, size.height);
                }
                return mapToIconImageFileObj(constants.MS_ICON_FILENAME_PREFIX, size);
            }),
        ];
    }
    return uniqWithDeepStrictEqual(icons);
};
const getSplashScreenImages = (splashScreenData, options) => {
    let appleSplashFilenamePrefix = constants.APPLE_SPLASH_FILENAME_PREFIX;
    if (options.darkMode) {
        appleSplashFilenamePrefix +=
            constants.APPLE_SPLASH_FILENAME_DARK_MODE_POSTFIX;
    }
    return uniqWithDeepStrictEqual(splashScreenData.reduce((acc, curr) => {
        let images = acc;
        if (!options.landscapeOnly) {
            images = [
                ...images,
                mapToImageFileObj(appleSplashFilenamePrefix, curr.portrait.width, curr.portrait.height, curr.scaleFactor, 'portrait'),
            ];
        }
        if (!options.portraitOnly) {
            images = [
                ...images,
                mapToImageFileObj(appleSplashFilenamePrefix, curr.landscape.width, curr.landscape.height, curr.scaleFactor, 'landscape'),
            ];
        }
        return images;
    }, []));
};
export default {
    getIconImages,
    getSplashScreenImages,
};
//# sourceMappingURL=images.js.map