import os from 'node:os';
import constants from '../config/constants.js';
const normalizeOnlyFlagPairs = (flag1Key, flag2Key, opts, logger) => {
    const stripOnly = (key) => key.replace('Only', '');
    if (opts[flag1Key] && opts[flag2Key]) {
        logger.warn(`Hmm, you want to _only_ generate both ${stripOnly(flag1Key)} and ${stripOnly(flag2Key)} set. Ignoring --x-only settings as this is default behavior`);
        return {
            [flag1Key]: false,
            [flag2Key]: false,
        };
    }
    return {};
};
const normalizeOutput = (output) => {
    if (!output) {
        return '.';
    }
    return output;
};
const getDefaultOptions = () => {
    const flags = constants.FLAGS;
    return Object.keys(flags).reduce((acc, curr) => {
        const flagKey = curr;
        if (flags[flagKey].hasOwnProperty('default')) {
            const val = flags[flagKey].default;
            if (val) {
                acc[flagKey] = val;
            }
        }
        return acc;
    }, {});
};
const normalizeSandboxOption = (noSandbox, logger) => {
    let sandboxDisabled = false;
    if (noSandbox) {
        if (os.platform() !== 'linux') {
            logger.warn('Disabling sandbox is only relevant on Linux platforms, request declined!');
        }
        else {
            sandboxDisabled = true;
        }
    }
    return {
        noSandbox: sandboxDisabled,
    };
};
export default {
    normalizeOnlyFlagPairs,
    normalizeOutput,
    getDefaultOptions,
    normalizeSandboxOption,
};
//# sourceMappingURL=flags.js.map