/**
 * @typedef {import('micromark-util-types').CompileContext} CompileContext
 * @typedef {import('micromark-util-types').Handle} _Handle
 * @typedef {import('micromark-util-types').HtmlExtension} HtmlExtension
 */
/**
 * Create an extension for `micromark` to support superscript and subscript when serializing
 * to HTML.
 *
 * @returns {HtmlExtension}
 *   Extension for `micromark` that can be passed in `htmlExtensions`, to
 *   support superscript and subscript when serializing to HTML.
 */
export function supersubHtml(): HtmlExtension;
export type CompileContext = import('micromark-util-types').CompileContext;
export type _Handle = import('micromark-util-types').Handle;
export type HtmlExtension = import('micromark-util-types').HtmlExtension;
