/**
 * Create an extension for `micromark` to support spoilers when serializing
 * to HTML.
 *
 * @returns {HtmlExtension}
 *   Extension for `micromark` that can be passed in `htmlExtensions`, to
 *   support spoilers when serializing to HTML.
 */
export function spoilerHtml(): HtmlExtension;
export type CompileContext = import('micromark-util-types').CompileContext;
export type _Handle = import('micromark-util-types').Handle;
export type HtmlExtension = import('micromark-util-types').HtmlExtension;
/**
 * Structure representing a spoiler.
 */
export type Spoiler = {
    /**
     *   Kind.
     */
    type: SpoilerType;
    /**
     *   Name of spoiler.
     */
    name: string;
    /**
     * Compiled HTML content inside spoiler.
     */
    content?: string | undefined;
    /**
     * Private :)
     */
    _fenceCount?: number | undefined;
};
/**
 * Kind.
 */
export type SpoilerType = 'spoiler';
