/**
 * @import {Element, ElementContent, Properties} from 'hast'
 * @import {Parents, TableRow} from 'mdast'
 * @import {State} from '../state.js'
 */
/**
 * Turn an mdast `tableRow` node into hast.
 *
 * @param {State} state
 *   Info passed around.
 * @param {TableRow} node
 *   mdast node.
 * @param {Parents | undefined} parent
 *   Parent of `node`.
 * @returns {Element}
 *   hast node.
 */
export function tableRow(state: State, node: TableRow, parent: Parents | undefined): Element;
import type { State } from '../state.js';
import type { TableRow } from 'mdast';
import type { Parents } from 'mdast';
import type { Element } from 'hast';
//# sourceMappingURL=table-row.d.ts.map