/**
 * @typedef {import('mdast').Nodes} Nodes
 * @typedef {import('mdast').Paragraph} Paragraph
 *
 * @typedef {import('mdast-util-from-markdown').CompileContext} CompileContext
 * @typedef {import('mdast-util-from-markdown').Extension} FromMarkdownExtension
 * @typedef {import('mdast-util-from-markdown').Handle} FromMarkdownHandle
 * @typedef {import('mdast-util-from-markdown').Token} Token
 *
 * @typedef {import('../index.js').Sub} Sub
 * @typedef {import('../index.js').Sup} Sup
 */
/**
 * Create an extension for `mdast-util-from-markdown` to enable sub and sup in
 * markdown.
 *
 * @returns {FromMarkdownExtension}
 *   Extension for `mdast-util-from-markdown` to enable sub and sup.
 */
export function supersubFromMarkdown(): FromMarkdownExtension;
export type Nodes = import("mdast").Nodes;
export type Paragraph = import("mdast").Paragraph;
export type CompileContext = import("mdast-util-from-markdown").CompileContext;
export type FromMarkdownExtension = import("mdast-util-from-markdown").Extension;
export type FromMarkdownHandle = import("mdast-util-from-markdown").Handle;
export type Token = import("mdast-util-from-markdown").Token;
export type Sub = import("../index.js").Sub;
export type Sup = import("../index.js").Sup;
