import type { PersonId } from "./PersonId";
import type { PrivateMessageId } from "./PrivateMessageId";
import type { PrivateMessageReportId } from "./PrivateMessageReportId";
/**
 * The private message report.
 */
export type PrivateMessageReport = {
    id: PrivateMessageReportId;
    creator_id: PersonId;
    private_message_id: PrivateMessageId;
    /**
     * The original text.
     */
    original_pm_text: string;
    reason: string;
    resolved: boolean;
    resolver_id?: PersonId;
    published_at: string;
    updated_at?: string;
};
