"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _LemmyHttp_instances, _LemmyHttp_apiUrl, _LemmyHttp_headers, _LemmyHttp_pictrsUrl, _LemmyHttp_fetchFunction, _LemmyHttp_buildFullUrl, _LemmyHttp_wrapper;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LemmyHttp = void 0;
const other_types_1 = require("./other_types");
var HttpType;
(function (HttpType) {
    HttpType["Get"] = "GET";
    HttpType["Post"] = "POST";
    HttpType["Put"] = "PUT";
})(HttpType || (HttpType = {}));
/**
 * Helps build lemmy HTTP requests.
 */
class LemmyHttp {
    /**
     * Generates a new instance of LemmyHttp.
     * @param baseUrl the base url, without the vX version: https://lemmy.ml -> goes to https://lemmy.ml/api/vX
     * @param headers optional headers. Should contain `x-real-ip` and `x-forwarded-for` .
     */
    constructor(baseUrl, options) {
        _LemmyHttp_instances.add(this);
        _LemmyHttp_apiUrl.set(this, void 0);
        _LemmyHttp_headers.set(this, {});
        _LemmyHttp_pictrsUrl.set(this, void 0);
        _LemmyHttp_fetchFunction.set(this, fetch.bind(globalThis));
        __classPrivateFieldSet(this, _LemmyHttp_apiUrl, `${baseUrl.replace(/\/+$/, "")}/api/${other_types_1.VERSION}`, "f");
        __classPrivateFieldSet(this, _LemmyHttp_pictrsUrl, `${baseUrl}/pictrs/image`, "f");
        if (options === null || options === void 0 ? void 0 : options.headers) {
            __classPrivateFieldSet(this, _LemmyHttp_headers, options.headers, "f");
        }
        if (options === null || options === void 0 ? void 0 : options.fetchFunction) {
            __classPrivateFieldSet(this, _LemmyHttp_fetchFunction, options.fetchFunction, "f");
        }
    }
    /**
     * Gets the site, and your user data.
     *
     * `HTTP.GET /site`
     */
    getSite(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/site", {}, options);
    }
    /**
     * Create your site.
     *
     * `HTTP.POST /site`
     */
    createSite(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/site", form, options);
    }
    /**
     * Edit your site.
     *
     * `HTTP.PUT /site`
     */
    editSite(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/site", form, options);
    }
    /**
     * Leave the Site admins.
     *
     * `HTTP.POST /user/leave_admin`
     */
    leaveAdmin(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/leave_admin", {}, options);
    }
    /**
     * Generate a TOTP / two-factor secret.
     *
     * Afterwards you need to call `/user/totp/update` with a valid token to enable it.
     *
     * `HTTP.POST /user/totp/generate`
     */
    generateTotpSecret(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/totp/generate", {}, options);
    }
    /**
     * Export a backup of your user settings, including your saved content,
     * followed communities, and blocks.
     *
     * `HTTP.GET /user/export_settings`
     */
    exportSettings(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/export_settings", {}, options);
    }
    /**
     * Import a backup of your user settings.
     *
     * `HTTP.POST /user/import_settings`
     */
    importSettings(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/import_settings", form, options);
    }
    /**
     * List login tokens for your user
     *
     * `HTTP.GET /user/list_logins`
     */
    listLogins(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/list_logins", {}, options);
    }
    /**
     * Returns an error message if your auth token is invalid
     *
     * `HTTP.GET /user/validate_auth`
     */
    validateAuth(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/validate_auth", {}, options);
    }
    /**
     * List all the media for your user
     *
     * `HTTP.GET /account/list_media`
     */
    listMedia(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/account/list_media", form, options);
    }
    /**
     * List all the media known to your instance.
     *
     * `HTTP.GET /admin/list_all_media`
     */
    listAllMedia(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/list_all_media", form, options);
    }
    /**
     * Enable / Disable TOTP / two-factor authentication.
     *
     * To enable, you need to first call `/user/totp/generate` and then pass a valid token to this.
     *
     * Disabling is only possible if 2FA was previously enabled. Again it is necessary to pass a valid token.
     *
     * `HTTP.POST /user/totp/update`
     */
    updateTotp(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/totp/update", form, options);
    }
    /**
     * Get the modlog.
     *
     * `HTTP.GET /modlog`
     */
    getModlog(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/modlog", form, options);
    }
    /**
     * Search lemmy.
     *
     * `HTTP.GET /search`
     */
    search(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/search", form, options);
    }
    /**
     * Fetch a non-local / federated object.
     *
     * `HTTP.GET /resolve_object`
     */
    resolveObject(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/resolve_object", form, options);
    }
    /**
     * Create a new community.
     *
     * `HTTP.POST /community`
     */
    createCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community", form, options);
    }
    /**
     * Get / fetch a community.
     *
     * `HTTP.GET /community`
     */
    getCommunity(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community", form, options);
    }
    /**
     * Edit a community.
     *
     * `HTTP.PUT /community`
     */
    editCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/community", form, options);
    }
    /**
     * List communities, with various filters.
     *
     * `HTTP.GET /community/list`
     */
    listCommunities(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community/list", form, options);
    }
    /**
     * Follow / subscribe to a community.
     *
     * `HTTP.POST /community/follow`
     */
    followCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/follow", form, options);
    }
    getCommunityPendingFollowsCount(community_id, options) {
        const form = { community_id };
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community/pending_follows/count", form, options);
    }
    listCommunityPendingFollows(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community/pending_follows/list", form, options);
    }
    approveCommunityPendingFollow(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/pending_follows/approve", form, options);
    }
    /**
     * Block a community.
     *
     * `HTTP.POST /community/block`
     */
    blockCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/block", form, options);
    }
    /**
     * Delete a community.
     *
     * `HTTP.POST /community/delete`
     */
    deleteCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/delete", form, options);
    }
    /**
     * Hide a community from public / "All" view. Admins only.
     *
     * `HTTP.PUT /community/hide`
     */
    hideCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/community/hide", form, options);
    }
    /**
     * A moderator remove for a community.
     *
     * `HTTP.POST /community/remove`
     */
    removeCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/remove", form, options);
    }
    /**
     * Transfer your community to an existing moderator.
     *
     * `HTTP.POST /community/transfer`
     */
    transferCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/transfer", form, options);
    }
    /**
     * Ban a user from a community.
     *
     * `HTTP.POST /community/ban_user`
     */
    banFromCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/ban_user", form, options);
    }
    /**
     * Add a moderator to your community.
     *
     * `HTTP.POST /community/mod`
     */
    addModToCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/community/mod", form, options);
    }
    /**
     * Get a random community.
     *
     * `HTTP.GET /community/random`
     */
    getRandomCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/community/random", form, options);
    }
    /**
     * Create a post.
     *
     * `HTTP.POST /post`
     */
    createPost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post", form, options);
    }
    /**
     * Get / fetch a post.
     *
     * `HTTP.GET /post`
     */
    getPost(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post", form, options);
    }
    /**
     * Edit a post.
     *
     * `HTTP.PUT /post`
     */
    editPost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/post", form, options);
    }
    /**
     * Delete a post.
     *
     * `HTTP.POST /post/delete`
     */
    deletePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/delete", form, options);
    }
    /**
     * A moderator remove for a post.
     *
     * `HTTP.POST /post/remove`
     */
    removePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/remove", form, options);
    }
    /**
     * Mark a post as read.
     *
     * `HTTP.POST /post/mark_as_read`
     */
    markPostAsRead(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/mark_as_read", form, options);
    }
    /**
     * Hide a post from list views.
     *
     * `HTTP.POST /post/hide`
     */
    hidePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/hide", form, options);
    }
    /**
     * A moderator can lock a post ( IE disable new comments ).
     *
     * `HTTP.POST /post/lock`
     */
    lockPost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/lock", form, options);
    }
    /**
     * A moderator can feature a community post ( IE stick it to the top of a community ).
     *
     * `HTTP.POST /post/feature`
     */
    featurePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/feature", form, options);
    }
    /**
     * Get / fetch posts, with various filters.
     *
     * `HTTP.GET /post/list`
     */
    getPosts(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/list", form, options);
    }
    /**
     * Like / vote on a post.
     *
     * `HTTP.POST /post/like`
     */
    likePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/like", form, options);
    }
    /**
     * List a post's likes. Admin-only.
     *
     * `HTTP.GET /post/like/list`
     */
    listPostLikes(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/like/list", form, options);
    }
    /**
     * Save a post.
     *
     * `HTTP.PUT /post/save`
     */
    savePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/post/save", form, options);
    }
    /**
     * Report a post.
     *
     * `HTTP.POST /post/report`
     */
    createPostReport(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/post/report", form, options);
    }
    /**
     * Resolve a post report. Only a mod can do this.
     *
     * `HTTP.PUT /post/report/resolve`
     */
    resolvePostReport(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/post/report/resolve", form, options);
    }
    /**
     * List post reports.
     *
     * `HTTP.GET /post/report/list`
     */
    listPostReports(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/report/list", form, options);
    }
    /**
     * Fetch metadata for any given site.
     *
     * `HTTP.GET /post/site_metadata`
     */
    getSiteMetadata(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/post/site_metadata", form, options);
    }
    /**
     * Create a comment.
     *
     * `HTTP.POST /comment`
     */
    createComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment", form, options);
    }
    /**
     * Edit a comment.
     *
     * `HTTP.PUT /comment`
     */
    editComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/comment", form, options);
    }
    /**
     * Delete a comment.
     *
     * `HTTP.POST /comment/delete`
     */
    deleteComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/delete", form, options);
    }
    /**
     * A moderator remove for a comment.
     *
     * `HTTP.POST /comment/remove`
     */
    removeComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/remove", form, options);
    }
    /**
     * Mark a comment as read.
     *
     * `HTTP.POST /comment/mark_as_read`
     */
    markCommentReplyAsRead(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/mark_as_read", form, options);
    }
    /**
     * Like / vote on a comment.
     *
     * `HTTP.POST /comment/like`
     */
    likeComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/like", form, options);
    }
    /**
     * List a comment's likes. Admin-only.
     *
     * `HTTP.GET /comment/like/list`
     */
    listCommentLikes(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment/like/list", form, options);
    }
    /**
     * Save a comment.
     *
     * `HTTP.PUT /comment/save`
     */
    saveComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/comment/save", form, options);
    }
    /**
     * Distinguishes a comment (speak as moderator)
     *
     * `HTTP.POST /comment/distinguish`
     */
    distinguishComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/distinguish", form, options);
    }
    /**
     * Get / fetch comments.
     *
     * `HTTP.GET /comment/list`
     */
    getComments(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment/list", form, options);
    }
    /**
     * Get / fetch comment.
     *
     * `HTTP.GET /comment`
     */
    getComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment", form, options);
    }
    /**
     * Report a comment.
     *
     * `HTTP.POST /comment/report`
     */
    createCommentReport(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/comment/report", form, options);
    }
    /**
     * Resolve a comment report. Only a mod can do this.
     *
     * `HTTP.PUT /comment/report/resolve`
     */
    resolveCommentReport(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/comment/report/resolve", form, options);
    }
    /**
     * List comment reports.
     *
     * `HTTP.GET /comment/report/list`
     */
    listCommentReports(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/comment/report/list", form, options);
    }
    /**
     * Get / fetch private messages.
     *
     * `HTTP.GET /private_message/list`
     */
    getPrivateMessages(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/private_message/list", form, options);
    }
    /**
     * Create a private message.
     *
     * `HTTP.POST /private_message`
     */
    createPrivateMessage(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message", form, options);
    }
    /**
     * Edit a private message.
     *
     * `HTTP.PUT /private_message`
     */
    editPrivateMessage(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/private_message", form, options);
    }
    /**
     * Delete a private message.
     *
     * `HTTP.POST /private_message/delete`
     */
    deletePrivateMessage(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message/delete", form, options);
    }
    /**
     * Mark a private message as read.
     *
     * `HTTP.POST /private_message/mark_as_read`
     */
    markPrivateMessageAsRead(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message/mark_as_read", form, options);
    }
    /**
     * Create a report for a private message.
     *
     * `HTTP.POST /private_message/report`
     */
    createPrivateMessageReport(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/private_message/report", form, options);
    }
    /**
     * Resolve a report for a private message.
     *
     * `HTTP.PUT /private_message/report/resolve`
     */
    resolvePrivateMessageReport(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/private_message/report/resolve", form, options);
    }
    /**
     * List private message reports.
     *
     * `HTTP.GET /private_message/report/list`
     */
    listPrivateMessageReports(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/private_message/report/list", form, options);
    }
    /**
     * Register a new user.
     *
     * `HTTP.POST /user/register`
     */
    register(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/register", form, options);
    }
    /**
     * Log into lemmy.
     *
     * `HTTP.POST /user/login`
     */
    login(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/login", form, options);
    }
    /**
     * Invalidate the currently used auth token.
     *
     * `HTTP.POST /user/logout`
     */
    logout(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/logout", {}, options);
    }
    /**
     * Get the details for a person.
     *
     * `HTTP.GET /user`
     */
    getPersonDetails(form = {}, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user", form, options);
    }
    /**
     * Get mentions for your user.
     *
     * `HTTP.GET /user/mention`
     */
    getPersonMentions(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/mention", form, options);
    }
    /**
     * Mark a person mention as read.
     *
     * `HTTP.POST /user/mention/mark_as_read`
     */
    markPersonMentionAsRead(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/mention/mark_as_read", form, options);
    }
    /**
     * Get comment replies.
     *
     * `HTTP.GET /user/replies`
     */
    getReplies(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/replies", form, options);
    }
    /**
     * Ban a person from your site.
     *
     * `HTTP.POST /user/ban`
     */
    banPerson(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/ban", form, options);
    }
    /**
     * Get a list of banned users
     *
     * `HTTP.GET /user/banned`
     */
    getBannedPersons(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/banned", {}, options);
    }
    /**
     * Block a person.
     *
     * `HTTP.POST /user/block`
     */
    blockPerson(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/block", form, options);
    }
    /**
     * Fetch a Captcha.
     *
     * `HTTP.GET /user/get_captcha`
     */
    getCaptcha(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/get_captcha", {}, options);
    }
    /**
     * Delete your account.
     *
     * `HTTP.POST /user/delete_account`
     */
    deleteAccount(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/delete_account", form, options);
    }
    /**
     * Reset your password.
     *
     * `HTTP.POST /user/password_reset`
     */
    passwordReset(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/password_reset", form, options);
    }
    /**
     * Change your password from an email / token based reset.
     *
     * `HTTP.POST /user/password_change`
     */
    passwordChangeAfterReset(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/password_change", form, options);
    }
    /**
     * Mark all replies as read.
     *
     * `HTTP.POST /user/mark_all_as_read`
     */
    markAllAsRead(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/mark_all_as_read", {}, options);
    }
    /**
     * Save your user settings.
     *
     * `HTTP.PUT /user/save_user_settings`
     */
    saveUserSettings(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/user/save_user_settings", form, options);
    }
    /**
     * Change your user password.
     *
     * `HTTP.PUT /user/change_password`
     */
    changePassword(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/user/change_password", form, options);
    }
    /**
     * Get counts for your reports
     *
     * `HTTP.GET /user/report_count`
     */
    getReportCount(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/report_count", form, options);
    }
    /**
     * Get your unread counts
     *
     * `HTTP.GET /user/unread_count`
     */
    getUnreadCount(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/user/unread_count", {}, options);
    }
    /**
     * Verify your email
     *
     * `HTTP.POST /user/verify_email`
     */
    verifyEmail(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/user/verify_email", form, options);
    }
    /**
     * Add an admin to your site.
     *
     * `HTTP.POST /admin/add`
     */
    addAdmin(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/add", form, options);
    }
    /**
     * Get the unread registration applications count.
     *
     * `HTTP.GET /admin/registration_application/count`
     */
    getUnreadRegistrationApplicationCount(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/registration_application/count", {}, options);
    }
    /**
     * List the registration applications.
     *
     * `HTTP.GET /admin/registration_application/list`
     */
    listRegistrationApplications(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/registration_application/list", form, options);
    }
    /**
     * Approve a registration application
     *
     * `HTTP.PUT /admin/registration_application/approve`
     */
    approveRegistrationApplication(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/admin/registration_application/approve", form, options);
    }
    /**
     * Get the application a user submitted when they first registered their account
     *
     * `HTTP.GET /admin/registration_application`
     */
    getRegistrationApplication(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/registration_application", form, options);
    }
    /**
     * Purge / Delete a person from the database.
     *
     * `HTTP.POST /admin/purge/person`
     */
    purgePerson(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/person", form, options);
    }
    /**
     * Purge / Delete a community from the database.
     *
     * `HTTP.POST /admin/purge/community`
     */
    purgeCommunity(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/community", form, options);
    }
    /**
     * Purge / Delete a post from the database.
     *
     * `HTTP.POST /admin/purge/post`
     */
    purgePost(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/post", form, options);
    }
    /**
     * Purge / Delete a comment from the database.
     *
     * `HTTP.POST /admin/purge/comment`
     */
    purgeComment(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/purge/comment", form, options);
    }
    /**
     * Create a new custom emoji
     *
     * `HTTP.POST /custom_emoji`
     */
    createCustomEmoji(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/custom_emoji", form, options);
    }
    /**
     * Edit an existing custom emoji
     *
     * `HTTP.PUT /custom_emoji`
     */
    editCustomEmoji(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/custom_emoji", form, options);
    }
    /**
     * Delete a custom emoji
     *
     * `HTTP.Post /custom_emoji/delete`
     */
    deleteCustomEmoji(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/custom_emoji/delete", form, options);
    }
    /**
     * List custom emojis
     *
     * `HTTP.GET /custom_emoji/list`
     */
    listCustomEmojis(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/custom_emoji/list", form, options);
    }
    /**
     * Create a new tagline
     *
     * `HTTP.POST /admin/tagline`
     */
    createTagline(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/tagline", form, options);
    }
    /**
     * Edit an existing tagline
     *
     * `HTTP.PUT /admin/tagline`
     */
    editTagline(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/admin/tagline", form, options);
    }
    /**
     * Delete a tagline
     *
     * `HTTP.Post /admin/tagline/delete`
     */
    deleteTagline(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/admin/tagline/delete", form, options);
    }
    /**
     * List taglines
     *
     * `HTTP.GET /admin/tagline/list`
     */
    listTaglines(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/admin/tagline/list", form, options);
    }
    /**
     * Create a new oauth provider method
     *
     * `HTTP.POST /oauth_provider`
     */
    createOAuthProvider(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/oauth_provider", form, options);
    }
    /**
     * Edit an existing oauth provider method
     *
     * `HTTP.PUT /oauth_provider`
     */
    editOAuthProvider(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Put, "/oauth_provider", form, options);
    }
    /**
     * Delete an oauth provider method
     *
     * `HTTP.Post /oauth_provider/delete`
     */
    deleteOAuthProvider(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/oauth_provider/delete", form, options);
    }
    /**
     * Authenticate with OAuth
     *
     * `HTTP.Post /oauth/authenticate`
     */
    authenticateWithOAuth(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/oauth/authenticate", form, options);
    }
    /**
     * Fetch federated instances.
     *
     * `HTTP.Get /federated_instances`
     */
    getFederatedInstances(options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Get, "/federated_instances", {}, options);
    }
    /**
     * Block an instance.
     *
     * `HTTP.Post /site/block`
     */
    blockInstance(form, options) {
        return __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_wrapper).call(this, HttpType.Post, "/site/block", form, options);
    }
    /**
     * Upload an image to the server.
     */
    uploadImage(_a, options_1) {
        return __awaiter(this, arguments, void 0, function* ({ image }, options) {
            const formData = createFormData(image);
            let url = undefined;
            let delete_url = undefined;
            const response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, __classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f"), Object.assign(Object.assign({}, options), { method: HttpType.Post, body: formData, headers: __classPrivateFieldGet(this, _LemmyHttp_headers, "f") }));
            if (response.status === 413) {
                return { msg: "too_large" };
            }
            const responseJson = yield response.json();
            if (responseJson.msg === "ok") {
                const { file: hash, delete_token: deleteToken } = responseJson.files[0];
                delete_url = `${__classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f")}/delete/${deleteToken}/${hash}`;
                url = `${__classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f")}/${hash}`;
            }
            return Object.assign(Object.assign({}, responseJson), { url,
                delete_url });
        });
    }
    /**
     * Delete a pictrs image
     */
    deleteImage(_a, options_1) {
        return __awaiter(this, arguments, void 0, function* ({ token, filename }, options) {
            const deleteUrl = `${__classPrivateFieldGet(this, _LemmyHttp_pictrsUrl, "f")}/delete/${token}/${filename}`;
            const response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, deleteUrl, Object.assign(Object.assign({}, options), { method: HttpType.Get, headers: __classPrivateFieldGet(this, _LemmyHttp_headers, "f") }));
            return response.status == 204;
        });
    }
    /**
     * Set the headers (can be used to set the auth header)
     */
    setHeaders(headers) {
        __classPrivateFieldSet(this, _LemmyHttp_headers, headers, "f");
    }
}
exports.LemmyHttp = LemmyHttp;
_LemmyHttp_apiUrl = new WeakMap(), _LemmyHttp_headers = new WeakMap(), _LemmyHttp_pictrsUrl = new WeakMap(), _LemmyHttp_fetchFunction = new WeakMap(), _LemmyHttp_instances = new WeakSet(), _LemmyHttp_buildFullUrl = function _LemmyHttp_buildFullUrl(endpoint) {
    return `${__classPrivateFieldGet(this, _LemmyHttp_apiUrl, "f")}${endpoint}`;
}, _LemmyHttp_wrapper = function _LemmyHttp_wrapper(type_, endpoint, form, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        let response;
        if (type_ === HttpType.Get) {
            const getUrl = `${__classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_buildFullUrl).call(this, endpoint)}?${encodeGetParams(form)}`;
            response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, getUrl, Object.assign(Object.assign({}, options), { method: HttpType.Get, headers: __classPrivateFieldGet(this, _LemmyHttp_headers, "f") }));
        }
        else {
            response = yield __classPrivateFieldGet(this, _LemmyHttp_fetchFunction, "f").call(this, __classPrivateFieldGet(this, _LemmyHttp_instances, "m", _LemmyHttp_buildFullUrl).call(this, endpoint), Object.assign(Object.assign({}, options), { method: type_, headers: Object.assign({ "Content-Type": "application/json" }, __classPrivateFieldGet(this, _LemmyHttp_headers, "f")), body: JSON.stringify(form) }));
        }
        let json = undefined;
        try {
            json = yield response.json();
        }
        catch (_b) {
            throw new Error(response.statusText);
        }
        if (!response.ok) {
            throw new Error((_a = json["error"]) !== null && _a !== void 0 ? _a : response.statusText);
        }
        else {
            return json;
        }
    });
};
function encodeGetParams(p) {
    return Object.entries(p)
        .filter(kv => kv[1] !== undefined && kv[1] !== null)
        .map(kv => kv.map(encodeURIComponent).join("="))
        .join("&");
}
function createFormData(image) {
    let formData = new FormData();
    if (image instanceof File) {
        formData.append("images[]", image);
    }
    else {
        // The filename doesn't affect the file type or file name that ends up in pictrs
        formData.append("images[]", new Blob([image], { type: "image/jpeg" }), "image.jpg");
    }
    return formData;
}
