import {
  orderJsonSchema,
  buildTypeJsonSchema,
  buildFallbackSortJsonSchema,
  buildRegexJsonSchema,
} from './common-json-schemas.js'
let newlinesBetweenJsonSchema = {
  oneOf: [
    {
      description: 'Specifies how to handle newlines between groups.',
      enum: ['ignore'],
      type: 'string',
    },
    {
      type: 'number',
      minimum: 0,
    },
  ],
}
let newlinesInsideJsonSchema = {
  oneOf: [
    {
      description: 'Specifies how to handle newlines between groups elements',
      enum: ['ignore'],
      type: 'string',
    },
    {
      type: 'number',
      minimum: 0,
    },
  ],
}
function buildCustomGroupsArrayJsonSchema({
  additionalFallbackSortProperties,
  singleCustomGroupJsonSchema,
  allowedAdditionalTypeValues,
}) {
  let commonCustomGroupJsonSchemas = buildCommonCustomGroupJsonSchemas({
    additionalFallbackSortProperties,
    allowedAdditionalTypeValues,
  })
  let populatedSingleCustomGroupJsonSchema =
    buildPopulatedSingleCustomGroupJsonSchema(singleCustomGroupJsonSchema)
  return {
    items: {
      oneOf: [
        {
          properties: {
            ...commonCustomGroupJsonSchemas,
            anyOf: {
              items: {
                properties: populatedSingleCustomGroupJsonSchema,
                description: 'Custom group.',
                additionalProperties: false,
                type: 'object',
              },
              type: 'array',
            },
          },
          description: 'Custom group block.',
          required: ['groupName', 'anyOf'],
          additionalProperties: false,
          type: 'object',
        },
        {
          properties: {
            ...commonCustomGroupJsonSchemas,
            ...populatedSingleCustomGroupJsonSchema,
          },
          description: 'Custom group.',
          additionalProperties: false,
          required: ['groupName'],
          minProperties: 2,
          type: 'object',
        },
      ],
    },
    description: 'Defines custom groups to match specific members.',
    type: 'array',
  }
}
function buildGroupsJsonSchema({ allowedAdditionalTypeValues }) {
  return {
    items: {
      oneOf: [
        {
          type: 'string',
        },
        {
          items: {
            type: 'string',
          },
          type: 'array',
          minItems: 1,
        },
        {
          properties: {
            newlinesBetween: newlinesBetweenJsonSchema,
          },
          required: ['newlinesBetween'],
          additionalProperties: false,
          type: 'object',
        },
        {
          properties: {
            group: {
              oneOf: [
                {
                  type: 'string',
                },
                {
                  items: {
                    type: 'string',
                  },
                  type: 'array',
                  minItems: 1,
                },
              ],
            },
            commentAbove: {
              description: 'Specifies a comment to enforce above the group.',
              type: 'string',
            },
            type: buildTypeJsonSchema({
              allowedAdditionalValues: allowedAdditionalTypeValues,
            }),
            newlinesInside: newlinesInsideJsonSchema,
            order: orderJsonSchema,
          },
          additionalProperties: false,
          required: ['group'],
          minProperties: 2,
          type: 'object',
        },
      ],
    },
    description: 'Specifies a list of groups for sorting.',
    type: 'array',
  }
}
function buildCommonGroupsJsonSchemas({
  additionalFallbackSortProperties,
  singleCustomGroupJsonSchema,
  allowedAdditionalTypeValues,
} = {}) {
  return {
    customGroups: buildCustomGroupsArrayJsonSchema({
      additionalFallbackSortProperties,
      allowedAdditionalTypeValues,
      singleCustomGroupJsonSchema,
    }),
    newlinesInside: {
      oneOf: [
        newlinesInsideJsonSchema,
        { enum: ['newlinesBetween'], type: 'string' },
      ],
    },
    groups: buildGroupsJsonSchema({
      allowedAdditionalTypeValues,
    }),
    newlinesBetween: newlinesBetweenJsonSchema,
  }
}
function buildCustomGroupModifiersJsonSchema(modifiers) {
  return {
    items: {
      enum: [...modifiers],
      type: 'string',
    },
    description: 'Modifier filters.',
    type: 'array',
  }
}
function buildCustomGroupSelectorJsonSchema(selectors) {
  return {
    description: 'Selector filter.',
    enum: [...selectors],
    type: 'string',
  }
}
function buildCommonCustomGroupJsonSchemas({
  additionalFallbackSortProperties,
  allowedAdditionalTypeValues,
}) {
  return {
    fallbackSort: buildFallbackSortJsonSchema({
      additionalProperties: additionalFallbackSortProperties,
      allowedAdditionalTypeValues,
    }),
    type: buildTypeJsonSchema({
      allowedAdditionalValues: allowedAdditionalTypeValues,
    }),
    groupName: {
      description: 'Custom group name.',
      type: 'string',
    },
    newlinesInside: newlinesInsideJsonSchema,
    order: orderJsonSchema,
  }
}
function buildPopulatedSingleCustomGroupJsonSchema(
  singleCustomGroupJsonSchema,
) {
  return {
    elementNamePattern: buildRegexJsonSchema(),
    ...singleCustomGroupJsonSchema,
  }
}
export {
  buildCommonGroupsJsonSchemas,
  buildCustomGroupModifiersJsonSchema,
  buildCustomGroupSelectorJsonSchema,
  buildCustomGroupsArrayJsonSchema,
  buildGroupsJsonSchema,
  newlinesBetweenJsonSchema,
  newlinesInsideJsonSchema,
}
