interface GeneratePredefinedGroupsParameters {
  cache: Map<string, string[]>
  modifiers: string[]
  selectors: string[]
}
/**
 * Generates an ordered list of group names associated with the provided
 * modifiers and selectors. The groups are generated by combining all possible
 * combinations of modifiers with each selector at the end. Selectors are
 * prioritized over the quantity of modifiers. For example, `protected abstract
 * override get fields();` should prioritize the `'get-method'` group over the
 * `'protected-abstract-override-method'` group.
 *
 * @param props - The properties including selectors, modifiers, and cache.
 * @param props.selectors - The list of selectors.
 * @param props.modifiers - The list of modifiers.
 * @param props.cache - Cache to store computed groups.
 * @returns An array of generated group names.
 */
export declare function generatePredefinedGroups({
  selectors,
  modifiers,
  cache,
}: GeneratePredefinedGroupsParameters): string[]
export {}
