/**
 * Converts a boolean value to a sort direction multiplier.
 *
 * Used in sorting functions to convert boolean comparisons into numeric values
 * suitable for array sort callbacks. This allows for concise expression of sort
 * direction logic.
 *
 * @example
 *   // In ascending sort
 *   convertBooleanToSign(true) // Returns: 1
 *   convertBooleanToSign(false) // Returns: -1
 *
 * @example
 *   // Usage in sorting
 *   const sortMultiplier = convertBooleanToSign(order === 'asc')
 *   return sortMultiplier * (a - b)
 *
 * @param value - Boolean value to convert to a sign.
 * @returns 1 if value is true, -1 if value is false.
 */
export declare function convertBooleanToSign(value: boolean): -1 | 1
