import { isGroupWithOverridesOption } from './is-group-with-overrides-option.js'
import { computeGroupName } from './compute-group-name.js'
function computeOverriddenOptionsByGroupIndex(options, groupIndex) {
  let { customGroups, fallbackSort, groups, order, type } = options
  let group = groups[groupIndex]
  let groupName = group ? computeGroupName(group) : null
  let customGroup = customGroups.find(
    currentGroup => groupName === currentGroup.groupName,
  )
  if (group && isGroupWithOverridesOption(group)) {
    type = group.type ?? type
    order = group.order ?? order
  }
  if (customGroup) {
    let fallbackOrder = customGroup.fallbackSort?.order ?? fallbackSort.order
    fallbackSort = {
      type: customGroup.fallbackSort?.type ?? fallbackSort.type,
      ...(fallbackOrder ? { order: fallbackOrder } : {}),
    }
    order = customGroup.order ?? order
    type = customGroup.type ?? type
  }
  return {
    ...options,
    fallbackSort,
    order,
    type,
  }
}
export { computeOverriddenOptionsByGroupIndex }
