import { computeGroupsNames } from './compute-groups-names.js'
function computeGroup({ customGroupMatcher, predefinedGroups, options }) {
  let group
  let groupsSet = new Set(computeGroupsNames(options.groups))
  function defineGroup(value) {
    if (Array.isArray(value)) {
      return value.some(defineGroup)
    }
    if (group || !groupsSet.has(value)) {
      return false
    }
    group = value
    return true
  }
  for (let customGroup of options.customGroups) {
    if (customGroupMatcher?.(customGroup)) {
      let groupDefined = defineGroup(customGroup.groupName)
      if (groupDefined) {
        break
      }
    }
  }
  defineGroup(predefinedGroups)
  return group ?? 'unknown'
}
export { computeGroup }
