import { CommonOptions } from '../../types/common-options.js'
/**
 * Adjusts a comparison result value based on the specified sort order.
 *
 * For ascending order, returns the value unchanged. For descending order,
 * negates the value to reverse the sort direction.
 *
 * @param value - The comparison result value to adjust.
 * @param order - The order direction ('asc' or 'desc').
 * @returns The adjusted comparison value.
 */
export declare function computeOrderedValue(
  value: number,
  order: CommonOptions['order'],
): number
