import { Comparator } from './default-comparator-by-options-computer.js'
import { CommonOptions } from '../../types/common-options.js'
import { SortingNode } from '../../types/sorting-node.js'
/**
 * Creates a comparator function that sorts nodes by their line length.
 *
 * @param options - Options containing the sort order.
 * @param options.order - The order direction ('asc' or 'desc').
 * @returns A comparator function that compares two sorting nodes by their size.
 */
export declare function buildLineLengthComparator({
  order,
}: Pick<CommonOptions, 'order'>): Comparator<SortingNode>
