import { TSESTree } from '@typescript-eslint/types'
import { TSESLint } from '@typescript-eslint/utils'
/**
 * Compute the name for a property-like node.
 *
 * @param params - Parameters.
 * @param params.node - Starting node to search from.
 * @param params.sourceCode - The source code object.
 * @returns The property or variable declaration name.
 */
export declare function computePropertyOrVariableDeclaratorName({
  sourceCode,
  node,
}: {
  node: TSESTree.VariableDeclarator | TSESTree.Property
  sourceCode: TSESLint.SourceCode
}): string
