import { TSESLint } from '@typescript-eslint/utils'
import { ScopedRegexOption } from '../../types/scoped-regex-option.js'
import { ObjectTypeParent } from './types.js'
/**
 * Checks whether the parent node's name matches the given pattern.
 *
 * @param params - The parameters object.
 * @param params.declarationMatchesPattern - The regex pattern to match against.
 * @param params.parentNodes - The parent nodes to check.
 * @param params.sourceCode - The source code object.
 * @returns True if the parent node's name passes the pattern filter, false
 *   otherwise.
 */
export declare function passesDeclarationMatchesPatternFilter({
  declarationMatchesPattern,
  parentNodes,
  sourceCode,
}: {
  declarationMatchesPattern: ScopedRegexOption | undefined
  parentNodes: ObjectTypeParent[]
  sourceCode: TSESLint.SourceCode
}): boolean
