import { AST_NODE_TYPES } from '@typescript-eslint/types'
import { UnreachableCaseError } from '../../utils/unreachable-case-error.js'
function isMemberOptional(node) {
  switch (node.type) {
    case AST_NODE_TYPES.TSPropertySignature:
    case AST_NODE_TYPES.TSMethodSignature:
      return node.optional
    case AST_NODE_TYPES.TSIndexSignature:
      return false
    /* v8 ignore next 2 -- @preserve Exhaustive guard. */
    default:
      throw new UnreachableCaseError(node)
  }
}
export { isMemberOptional }
