import { TSESLint } from '@typescript-eslint/utils'
import { ObjectTypeParent } from './types.js'
/**
 * Computes the name of an object-type-like parent node.
 *
 * @param node - The AST node representing an object-type-like node.
 * @param sourceCode - ESLint source code object for text extraction.
 * @returns The name of the object-type like node.
 */
export declare function computeNodeParentName(
  node: ObjectTypeParent,
  sourceCode: TSESLint.SourceCode,
): string
