import { computeOverriddenOptionsByGroupIndex } from '../../utils/compute-overridden-options-by-group-index.js'
import { computeGroupName } from '../../utils/compute-group-name.js'
function buildOptionsByGroupIndexComputer(options) {
  return groupIndex => computeOptionsForGroupIndex(options, groupIndex)
}
function computeOptionsForGroupIndex(options, groupIndex) {
  let overriddenOptions = computeOverriddenOptionsByGroupIndex(
    options,
    groupIndex,
  )
  let { fallbackSort, customGroups, sortBy, groups } = options
  let fallbackSortBy = fallbackSort.sortBy
  let group = groups[groupIndex]
  let groupName = group ? computeGroupName(group) : null
  let customGroup = customGroups.find(
    currentGroup => groupName === currentGroup.groupName,
  )
  if (customGroup) {
    fallbackSortBy = customGroup.fallbackSort?.sortBy ?? fallbackSortBy
    if ('sortBy' in customGroup && customGroup.sortBy) {
      ;({ sortBy } = customGroup)
    }
  }
  return {
    ...overriddenOptions,
    fallbackSort: {
      ...overriddenOptions.fallbackSort,
      ...(fallbackSortBy ? { sortBy: fallbackSortBy } : {}),
    },
    sortBy,
  }
}
export { buildOptionsByGroupIndexComputer }
