import { OptionsByGroupIndexComputer } from '../../utils/sort-nodes-by-groups.js'
import { Options } from './types.js'
/**
 * Retrieves sorting options for a specific group with object-type-specific
 * overrides.
 *
 * Extends the base custom groups functionality to support 'sortBy' option,
 * which determines whether to sort object type members by their key name or
 * value. Custom groups can override both the primary sortBy and fallback sortBy
 * settings.
 *
 * @param options - Rule options including custom groups configuration.
 * @returns Sorting options with appropriate node value getters for the sort
 *   strategy.
 */
export declare function buildOptionsByGroupIndexComputer(
  options: Required<Options[number]>,
): OptionsByGroupIndexComputer<Required<Options[number]>>
