import { TSESTree } from '@typescript-eslint/types'
/**
 * Computes the name of an export specifier node.
 *
 * @param node - The export specifier node.
 * @param ignoreAlias - Whether to ignore the alias and use the local name.
 * @returns The computed name of the export specifier.
 */
export declare function computeNodeName(
  node: TSESTree.ExportSpecifier,
  ignoreAlias: boolean,
): string
