import { GroupsOptions } from '../../types/common-groups-options.js'
/**
 * Checks if a group is a side-effect-only group.
 *
 * A side-effect-only group is one that contains no imports or exports, and is
 * typically used for modules that only execute code without exporting any
 * values.
 *
 * @param group - The group to check.
 * @returns True if the group is a side-effect-only group, false otherwise.
 */
export declare function isSideEffectOnlyGroup(
  group: GroupsOptions[0] | undefined,
): boolean
