import { TSESTree } from '@typescript-eslint/types'
type Modifier = 'wildcard' | 'default' | 'named'
/**
 * Computes the specifier modifiers of an import-like AST node.
 *
 * @param node - The AST node representing an import-like declaration.
 * @returns A list of specifier modifiers.
 */
export declare function computeSpecifierModifiers(
  node:
    | TSESTree.TSImportEqualsDeclaration
    | TSESTree.VariableDeclaration
    | TSESTree.ImportDeclaration,
): Modifier[]
export {}
