import { defaultComparatorByOptionsComputer } from '../../utils/compare/default-comparator-by-options-computer.js'
import { computeOrderedValue } from '../../utils/compare/compute-ordered-value.js'
import { UnreachableCaseError } from '../../utils/unreachable-case-error.js'
let comparatorByOptionsComputer = options => {
  switch (options.type) {
    case 'type-import-first':
      return (a, b) => compareTypeImportFirst(a, b, options)
    case 'alphabetical':
    case 'line-length':
    case 'unsorted':
    case 'natural':
    case 'custom':
      return defaultComparatorByOptionsComputer({
        ...options,
        type: options.type,
      })
    /* v8 ignore next 2 -- @preserve Exhaustive guard. */
    default:
      throw new UnreachableCaseError(options.type)
  }
}
function compareTypeImportFirst(a, b, options) {
  if (a.isTypeImport && b.isTypeImport) {
    return 0
  }
  if (!a.isTypeImport && !b.isTypeImport) {
    return 0
  }
  return computeOrderedValue(a.isTypeImport ? -1 : 1, options.order)
}
export { comparatorByOptionsComputer }
