import { JSONSchema4 } from '@typescript-eslint/utils/json-schema'
import { TSESTree } from '@typescript-eslint/types'
import {
  CommonOptions,
  RegexOption,
  TypeOption,
} from '../../types/common-options.js'
import { SortingNodeWithDependencies } from '../../utils/sort-nodes-by-dependencies.js'
import { CommonPartitionOptions } from '../../types/common-partition-options.js'
import { CommonGroupsOptions } from '../../types/common-groups-options.js'
/**
 * Configuration options for the sort-enums rule.
 *
 * This rule enforces consistent ordering of TypeScript enum members to improve
 * code readability and maintainability.
 */
export type Options = Partial<
  {
    /**
     * Whether to sort enum members by their values instead of names. When
     * "always", compares enum values; when "never", compares enum member
     * names.
     *
     * @default ifNumericEnum
     */
    sortByValue: 'ifNumericEnum' | 'always' | 'never'
  } & CommonGroupsOptions<
    SingleCustomGroup,
    Record<string, never>,
    TypeOption
  > &
    CommonOptions<TypeOption> &
    CommonPartitionOptions
>[]
export interface SortEnumsSortingNode extends SortingNodeWithDependencies<TSESTree.TSEnumMember> {
  numericValue: number | null
  value: string | null
}
/** Additional configuration for a single custom group. */
interface SingleCustomGroup {
  /**
   * Regular expression pattern to match enum member values. Members with
   * values matching this pattern will be included in this custom group.
   */
  elementValuePattern?: RegexOption
}
/**
 * JSON schema definition for validating single custom group configurations.
 * Used by ESLint to validate rule options at configuration time.
 */
export declare let singleCustomGroupJsonSchema: Record<string, JSONSchema4>
export {}
