import { TSESTree } from '@typescript-eslint/types'
import { CommonPartitionOptions } from '../../types/common-partition-options.js'
import { CommonGroupsOptions } from '../../types/common-groups-options.js'
import { CommonOptions, TypeOption } from '../../types/common-options.js'
import { SortingNode } from '../../types/sorting-node.js'
export type Options = Partial<
  {
    sortOnParameters: boolean
    sortOnProperties: boolean
    sortOnAccessors: boolean
    sortOnMethods: boolean
    sortOnClasses: boolean
  } & CommonGroupsOptions<
    SingleCustomGroup,
    Record<string, never>,
    TypeOption
  > &
    CommonOptions<TypeOption> &
    CommonPartitionOptions
>[]
export type SortDecoratorsSortingNode = SortingNode<TSESTree.Decorator>
/** Additional configuration for a single custom group. */
type SingleCustomGroup = Record<string, never>
export {}
