"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a, _b, _c, _d, _e, _f;
    const entitlements = op.value;
    const build = op.iosBuild;
    let entitlementsList = entitlements;
    let replace = false;
    if (!Array.isArray(entitlements)) {
        entitlementsList = entitlements.entries;
        if (entitlements.replace === true) {
            replace = true;
        }
    }
    for (const entitlement of entitlementsList) {
        try {
            if (build) {
                // If build is specified, apply only to that build
                if (replace) {
                    await ((_a = ctx.project.ios) === null || _a === void 0 ? void 0 : _a.setEntitlements(op.iosTarget, build, entitlement));
                }
                else {
                    await ((_b = ctx.project.ios) === null || _b === void 0 ? void 0 : _b.addEntitlements(op.iosTarget, build, entitlement));
                }
            }
            else {
                // Otherwise, apply to both debug and release builds
                if (replace) {
                    await ((_c = ctx.project.ios) === null || _c === void 0 ? void 0 : _c.setEntitlements(op.iosTarget, 'Debug', entitlement));
                    await ((_d = ctx.project.ios) === null || _d === void 0 ? void 0 : _d.setEntitlements(op.iosTarget, 'Release', entitlement));
                }
                else {
                    await ((_e = ctx.project.ios) === null || _e === void 0 ? void 0 : _e.addEntitlements(op.iosTarget, 'Debug', entitlement));
                    await ((_f = ctx.project.ios) === null || _f === void 0 ? void 0 : _f.addEntitlements(op.iosTarget, 'Release', entitlement));
                }
            }
        }
        catch (e) {
            log_1.logger.warn(`Skipping ${op.id} (${e.message})`);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'ios.entitlements'
];
//# sourceMappingURL=entitlements.js.map