/// <reference types="mdast-util-lemmy-supersub" />

/**
 * @typedef {import('mdast').Root} Root
 * @typedef {import('unified').Processor<Root>} Processor
 */

import {supersubFromMarkdown} from 'mdast-util-lemmy-supersub'
import {supersub} from 'micromark-extension-lemmy-supersub'

/**
 * Add support for lemmy supersub.
 */
export default function remarkDirective() {
  // @ts-expect-error: TS is wrong about `this`.
  // eslint-disable-next-line unicorn/no-this-assignment
  const self = /** @type {Processor} */ (this)
  const data = self.data()

  const micromarkExtensions =
    data.micromarkExtensions || (data.micromarkExtensions = [])
  const fromMarkdownExtensions =
    data.fromMarkdownExtensions || (data.fromMarkdownExtensions = [])

  // @ts-ignore
  micromarkExtensions.push(supersub)
  fromMarkdownExtensions.push(supersubFromMarkdown())
}
