import type { OutgoingHttpHeaders } from 'node:http';
type HeaderNames = keyof OutgoingHttpHeaders;
type HeaderValue<H extends HeaderNames> = OutgoingHttpHeaders[H];
export declare class Controller {
    private statusCode?;
    private headers;
    setStatus(statusCode: number): void;
    getStatus(): number | undefined;
    setHeader<H extends HeaderNames>(name: H, value?: HeaderValue<H>): void;
    setHeader(name: string, value?: string | string[]): void;
    getHeader(name: string): string | string[] | undefined;
    getHeaders(): {
        [name: string]: string | string[] | undefined;
    };
}
export {};
