import type { ModalOptions } from '@ionic/core/components';
import type { ReactComponentOrElement } from '../models/ReactComponentOrElement';
import type { HookOverlayOptions } from './HookOverlayOptions';
/**
 * A hook for presenting/dismissing an IonModal component
 * @param component The component that the modal will show. Can be a React Component, a functional component, or a JSX Element
 * @param componentProps The props that will be passed to the component, if required
 * @returns Returns the present and dismiss methods in an array
 */
export declare function useIonModal(component: ReactComponentOrElement, componentProps?: any): UseIonModalResult;
export type UseIonModalResult = [
    (options?: Omit<ModalOptions, 'component' | 'componentProps'> & HookOverlayOptions) => void,
    /**
     * Dismisses the modal
     */
    (data?: any, role?: string) => void
];
