/** @internal */
/**
 * @internal
 */
const sort = (arr) => {
    return [...arr].sort((a, b) => a - b);
};

const styleToString = (obj) => {
    return Object.keys(obj).reduce((acc, k) => {
        const value = obj[k];
        if (value == null) {
            return acc;
        }
        return acc + `${k}:${value};`;
    }, "");
};
const defaultGetKey = (_data, i) => "_" + i;
function* iterRange([start, end], keepMounted) {
    if (keepMounted) {
        const mounted = new Set(keepMounted);
        for (let i = start; i <= end; i++) {
            mounted.add(i);
        }
        for (const index of sort([...mounted])) {
            yield index;
        }
    }
    else {
        for (let i = start; i <= end; i++) {
            yield i;
        }
    }
}

export { defaultGetKey, iterRange, styleToString };
//# sourceMappingURL=utils.js.map
