import type { CLIOptions } from './models/options.js';
import type { Result } from './models/result.js';
import type { LoggerFunction } from './models/logger.js';
/**
 Generates PWA assets based on a source input and saves generated images in the output folder provided

 @param source - A local image file, a local HTML file, a remote image or remote HTML file path
 @param outputFolderPath - The path of the folder to save the images in
 @param options - Option flags of the library in an object, keeps default values
 @param loggerFn - An optional logger function to log the output
 @returns A promise of result object that resolves when all images are generated and file updates are finalized

 @example
 ```javascript
 import pwaAssetGenerator = require('pwa-asset-generator');

 (async () => {
    const { savedImages, htmlMeta, manifestJsonContent } = await pwaAssetGenerator.generateImages(
      'https://raw.githubusercontent.com/onderceylan/pwa-asset-generator/HEAD/static/logo.png',
      './temp',
       {
          scrape: false,
          background: "linear-gradient(to right, #fa709a 0%, #fee140 100%)",
          splashOnly: true,
          portraitOnly: true,
          log: false
       });
  })();
 ```
 */
declare function generateImages(source: string, outputFolderPath: string, options?: CLIOptions, loggerFn?: LoggerFunction): Promise<Result>;
/**
 Static data for Apple Device specs that are used for generating launch images
 */
declare const appleDeviceSpecsForLaunchImages: any;
export { generateImages, appleDeviceSpecsForLaunchImages };
