import { AdditionalProps } from './additionalProps';
import { TsoaRoute } from './tsoa-route';
export declare function ValidateParam(property: TsoaRoute.PropertySchema, value: any, generatedModels: TsoaRoute.Models, name: string | undefined, fieldErrors: FieldErrors, isBodyParam: boolean, parent: string | undefined, config: AdditionalProps): any;
export declare class ValidationService {
    private readonly models;
    private readonly config;
    constructor(models: TsoaRoute.Models, config: AdditionalProps);
    ValidateParam(property: TsoaRoute.PropertySchema, rawValue: any, name: string | undefined, fieldErrors: FieldErrors, isBodyParam: boolean, parent?: string): any;
    hasCorrectJsType(value: any, type: 'object' | 'boolean' | 'number' | 'string', isBodyParam: boolean): boolean;
    validateNestedObjectLiteral(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, nestedProperties: {
        [name: string]: TsoaRoute.PropertySchema;
    } | undefined, additionalProperties: TsoaRoute.PropertySchema | boolean | undefined, parent: string): any;
    validateInt(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, validators?: IntegerValidator, parent?: string): number | undefined;
    validateFloat(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, validators?: FloatValidator, parent?: string): number | undefined;
    validateEnum(name: string, value: unknown, fieldErrors: FieldErrors, members?: Array<string | number | boolean | null>, parent?: string): unknown;
    validateDate(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, validators?: DateValidator, parent?: string): Date | undefined;
    validateDateTime(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, validators?: DateTimeValidator, parent?: string): Date | undefined;
    validateString(name: string, value: any, fieldErrors: FieldErrors, validators?: StringValidator, parent?: string): string | undefined;
    validateBool(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, validators?: BooleanValidator, parent?: string): any;
    validateUndefined(name: string, value: any, fieldErrors: FieldErrors, parent?: string): undefined;
    validateArray(name: string, value: any[], fieldErrors: FieldErrors, isBodyParam: boolean, schema?: TsoaRoute.PropertySchema, validators?: ArrayValidator, parent?: string): any[] | undefined;
    validateBuffer(_name: string, value: string): Buffer<ArrayBuffer>;
    validateUnion(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, property: TsoaRoute.PropertySchema, parent?: string): any;
    validateIntersection(name: string, value: any, fieldErrors: FieldErrors, isBodyParam: boolean, subSchemas: TsoaRoute.PropertySchema[] | undefined, parent?: string): any;
    private toModelLike;
    /**
     * combine all schemas once, ignoring order ie
     * input: [[value1], [value2]] should be [[value1, value2]]
     * not [[value1, value2],[value2, value1]]
     * and
     * input: [[value1, value2], [value3, value4], [value5, value6]] should be [
     *   [value1, value3, value5],
     *   [value1, value3, value6],
     *   [value1, value4, value5],
     *   [value1, value4, value6],
     *   [value2, value3, value5],
     *   [value2, value3, value6],
     *   [value2, value4, value5],
     *   [value2, value4, value6],
     * ]
     * @param modelSchemass
     */
    private selfIntersectionCombinations;
    private getAllCombinations;
    private combineProperties;
    private getExcessPropertiesFor;
    validateModel(input: {
        name: string;
        value: any;
        modelDefinition: TsoaRoute.ModelSchema;
        fieldErrors: FieldErrors;
        isBodyParam: boolean;
        parent?: string;
    }): any;
}
export interface IntegerValidator {
    isInt?: {
        errorMsg?: string;
    };
    isLong?: {
        errorMsg?: string;
    };
    minimum?: {
        value: number;
        errorMsg?: string;
    };
    maximum?: {
        value: number;
        errorMsg?: string;
    };
}
export interface FloatValidator {
    isFloat?: {
        errorMsg?: string;
    };
    isDouble?: {
        errorMsg?: string;
    };
    minimum?: {
        value: number;
        errorMsg?: string;
    };
    maximum?: {
        value: number;
        errorMsg?: string;
    };
}
export interface DateValidator {
    isDate?: {
        errorMsg?: string;
    };
    minDate?: {
        value: string;
        errorMsg?: string;
    };
    maxDate?: {
        value: string;
        errorMsg?: string;
    };
}
export interface DateTimeValidator {
    isDateTime?: {
        errorMsg?: string;
    };
    minDate?: {
        value: string;
        errorMsg?: string;
    };
    maxDate?: {
        value: string;
        errorMsg?: string;
    };
}
export interface StringValidator {
    isString?: {
        errorMsg?: string;
    };
    minLength?: {
        value: number;
        errorMsg?: string;
    };
    maxLength?: {
        value: number;
        errorMsg?: string;
    };
    pattern?: {
        value: string;
        errorMsg?: string;
    };
    title?: {
        value: string;
        errorMsg?: string;
    };
}
export interface BooleanValidator {
    isBoolean?: {
        errorMsg?: string;
    };
}
export interface ArrayValidator {
    isArray?: {
        errorMsg?: string;
    };
    minItems?: {
        value: number;
        errorMsg?: string;
    };
    maxItems?: {
        value: number;
        errorMsg?: string;
    };
    uniqueItems?: {
        errorMsg?: string;
    };
}
export type Validator = IntegerValidator | FloatValidator | DateValidator | DateTimeValidator | StringValidator | BooleanValidator | ArrayValidator;
export interface FieldErrors {
    [name: string]: {
        message: string;
        value?: any;
    };
}
export interface Exception extends Error {
    status: number;
}
export declare class ValidateError extends Error implements Exception {
    fields: FieldErrors;
    message: string;
    status: number;
    name: string;
    constructor(fields: FieldErrors, message: string);
}
