"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const project_1 = require("@trapezedev/project");
const path_1 = require("path");
const log_1 = require("../../util/log");
function getXmlFile(path, vfs) {
    const existing = vfs.get(path);
    if (existing) {
        return existing.getData();
    }
    return new project_1.XmlFile(path, vfs);
}
async function execute(ctx, op) {
    const xmlOp = op;
    const entries = xmlOp.value;
    for (const entry of entries) {
        let filename = entry.file;
        if (!filename) {
            continue;
        }
        let xmlFile = getXmlFile((0, path_1.join)(ctx.project.projectRoot, filename), ctx.project.vfs);
        try {
            await xmlFile.load();
        }
        catch (e) {
            (0, log_1.error)('Unable to load the XML file here', e);
            return;
        }
        if (entry.attrs) {
            await xmlFile.setAttrs(entry.target, entry.merge);
        }
        else if (entry.inject) {
            await xmlFile.injectFragment(entry.target, entry.inject);
        }
        else if (entry.merge) {
            await xmlFile.mergeFragment(entry.target, entry.merge);
        }
        else if (entry.replace) {
            await xmlFile.replaceFragment(entry.target, entry.replace);
        }
        else if (entry.delete) {
            await xmlFile.deleteNodes(entry.delete);
        }
        else if (entry.deleteAttributes) {
            await xmlFile.deleteAttributes(entry.target, entry.deleteAttributes);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'project.xml'
];
//# sourceMappingURL=xml.js.map